/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.efento;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.util.TriConsumer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.thingsboard.server.common.adaptor.AdaptorException;
import org.thingsboard.server.common.adaptor.ProtoConverter;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.device.profile.CoapDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.DeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.EfentoCoapDeviceTypeConfiguration;
import org.thingsboard.server.common.transport.TransportContext;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.SessionInfoCreator;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.gen.transport.coap.ConfigProtos;
import org.thingsboard.server.gen.transport.coap.DeviceInfoProtos;
import org.thingsboard.server.gen.transport.coap.MeasurementsProtos;
import org.thingsboard.server.transport.coap.AbstractCoapTransportResource;
import org.thingsboard.server.transport.coap.CoapTransportContext;
import org.thingsboard.server.transport.coap.callback.CoapDeviceAuthCallback;
import org.thingsboard.server.transport.coap.callback.CoapEfentoCallback;
import org.thingsboard.server.transport.coap.efento.utils.CoapEfentoUtils;
import org.thingsboard.server.transport.coap.efento.utils.PulseCounterType;

public class CoapEfentoTransportResource
extends AbstractCoapTransportResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoapEfentoTransportResource.class);
    private static final int CHILD_RESOURCE_POSITION = 2;

    public CoapEfentoTransportResource(CoapTransportContext context, String name) {
        super(context, name);
        this.setObservable(true);
        this.setObserveType(CoAP.Type.CON);
    }

    @Override
    protected void processHandleGet(CoapExchange exchange) {
        boolean validPath;
        Exchange advanced = exchange.advanced();
        Request request = advanced.getRequest();
        List uriPath = request.getOptions().getUriPath();
        boolean bl = validPath = uriPath.size() == 2 && ((String)uriPath.get(1)).equals("t");
        if (!validPath) {
            log.trace("Invalid path: [{}]", (Object)uriPath);
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
        } else {
            int dateInSec = (int)(System.currentTimeMillis() / 1000L);
            byte[] bytes = ByteBuffer.allocate(4).putInt(dateInSec).array();
            exchange.respond(CoAP.ResponseCode.CONTENT, bytes);
        }
    }

    @Override
    protected void processHandlePost(CoapExchange exchange) {
        String requestType;
        Exchange advanced = exchange.advanced();
        Request request = advanced.getRequest();
        List uriPath = request.getOptions().getUriPath();
        if (uriPath.size() != 2) {
            log.trace("Unexpected uri path size, uri path: [{}]", (Object)uriPath);
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
            return;
        }
        switch (requestType = (String)uriPath.get(1)) {
            case "m": {
                this.processMeasurementsRequest(exchange);
                break;
            }
            case "i": {
                this.processDeviceInfoRequest(exchange);
                break;
            }
            case "c": {
                this.processConfigurationRequest(exchange);
                break;
            }
            default: {
                log.trace("Unexpected request type: [{}]", (Object)requestType);
                exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
            }
        }
    }

    private void processMeasurementsRequest(CoapExchange exchange) {
        byte[] bytes = exchange.advanced().getRequest().getPayload();
        try {
            MeasurementsProtos.ProtoMeasurements protoMeasurements = MeasurementsProtos.ProtoMeasurements.parseFrom(bytes);
            log.trace("Successfully parsed Efento ProtoMeasurements: [{}]", (Object)protoMeasurements.getCloudToken());
            this.validateAndProcessEffentoMessage(protoMeasurements.getCloudToken(), exchange, (TriConsumer<DeviceProfile, TransportProtos.SessionInfoProto, UUID>)((TriConsumer)(deviceProfile, sessionInfo, sessionId) -> {
                try {
                    List<EfentoTelemetry> measurements = this.getEfentoMeasurements(protoMeasurements, (UUID)sessionId);
                    this.transportService.process(sessionInfo, this.transportContext.getEfentoCoapAdaptor().convertToPostTelemetry((UUID)sessionId, measurements), (TransportServiceCallback)new CoapEfentoCallback(exchange, CoAP.ResponseCode.CREATED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
                }
                catch (AdaptorException e) {
                    log.error("[{}] Failed to decode Efento ProtoMeasurements: ", sessionId, (Object)e);
                    exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
                }
            }));
        }
        catch (Exception e) {
            log.error("Failed to decode Efento ProtoMeasurements: ", (Throwable)e);
            exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
        }
    }

    private void processDeviceInfoRequest(CoapExchange exchange) {
        byte[] bytes = exchange.advanced().getRequest().getPayload();
        try {
            DeviceInfoProtos.ProtoDeviceInfo protoDeviceInfo = DeviceInfoProtos.ProtoDeviceInfo.parseFrom(bytes);
            String token = protoDeviceInfo.getCloudToken();
            log.trace("Successfully parsed Efento ProtoDeviceInfo: [{}]", (Object)token);
            this.validateAndProcessEffentoMessage(token, exchange, (TriConsumer<DeviceProfile, TransportProtos.SessionInfoProto, UUID>)((TriConsumer)(deviceProfile, sessionInfo, sessionId) -> {
                try {
                    EfentoTelemetry deviceInfo = this.getEfentoDeviceInfo(protoDeviceInfo);
                    this.transportService.process(sessionInfo, this.transportContext.getEfentoCoapAdaptor().convertToPostTelemetry((UUID)sessionId, List.of(deviceInfo)), (TransportServiceCallback)new CoapEfentoCallback(exchange, CoAP.ResponseCode.CREATED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
                }
                catch (AdaptorException e) {
                    log.error("[{}] Failed to decode Efento ProtoDeviceInfo: ", sessionId, (Object)e);
                    exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
                }
            }));
        }
        catch (Exception e) {
            log.error("Failed to decode Efento ProtoDeviceInfo: ", (Throwable)e);
            exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
        }
    }

    private void processConfigurationRequest(CoapExchange exchange) {
        byte[] bytes = exchange.advanced().getRequest().getPayload();
        try {
            ConfigProtos.ProtoConfig protoConfig = ConfigProtos.ProtoConfig.parseFrom(bytes);
            String token = protoConfig.getCloudToken();
            log.trace("Successfully parsed Efento ProtoConfig: [{}]", (Object)token);
            this.validateAndProcessEffentoMessage(token, exchange, (TriConsumer<DeviceProfile, TransportProtos.SessionInfoProto, UUID>)((TriConsumer)(deviceProfile, sessionInfo, sessionId) -> {
                try {
                    JsonElement configuration = this.getEfentoConfiguration(bytes);
                    this.transportService.process(sessionInfo, this.transportContext.getEfentoCoapAdaptor().convertToPostAttributes((UUID)sessionId, configuration), (TransportServiceCallback)new CoapEfentoCallback(exchange, CoAP.ResponseCode.CREATED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
                }
                catch (AdaptorException e) {
                    log.error("[{}] Failed to decode Efento ProtoConfig: ", sessionId, (Object)e);
                    exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
                }
                catch (InvalidProtocolBufferException e) {
                    log.error("[{}] Error while processing efento message: ", sessionId, (Object)e);
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (Exception e) {
            log.error("Failed to decode Efento ProtoConfig: ", (Throwable)e);
            exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
        }
    }

    private void validateAndProcessEffentoMessage(String token, CoapExchange exchange, TriConsumer<DeviceProfile, TransportProtos.SessionInfoProto, UUID> requestProcessor) {
        this.transportService.process(DeviceTransportType.COAP, TransportProtos.ValidateDeviceTokenRequestMsg.newBuilder().setToken(token).build(), (TransportServiceCallback)new CoapDeviceAuthCallback(exchange, (msg, deviceProfile) -> {
            TransportProtos.SessionInfoProto sessionInfo = SessionInfoCreator.create((ValidateDeviceCredentialsResponse)msg, (TransportContext)this.transportContext, (UUID)UUID.randomUUID());
            UUID sessionId = new UUID(sessionInfo.getSessionIdMSB(), sessionInfo.getSessionIdLSB());
            try {
                this.validateEfentoTransportConfiguration((DeviceProfile)deviceProfile);
                requestProcessor.accept(deviceProfile, (Object)sessionInfo, (Object)sessionId);
                this.reportSubscriptionInfo(sessionInfo, false, false);
            }
            catch (AdaptorException e) {
                log.error("[{}] Failed to decode Efento request: ", (Object)sessionId, (Object)e);
                exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
            }
        }));
    }

    public Resource getChild(String name) {
        return this;
    }

    private void validateEfentoTransportConfiguration(DeviceProfile deviceProfile) throws AdaptorException {
        DeviceProfileTransportConfiguration transportConfiguration = deviceProfile.getProfileData().getTransportConfiguration();
        if (transportConfiguration instanceof CoapDeviceProfileTransportConfiguration) {
            CoapDeviceProfileTransportConfiguration coapDeviceProfileTransportConfiguration = (CoapDeviceProfileTransportConfiguration)transportConfiguration;
            if (!(coapDeviceProfileTransportConfiguration.getCoapDeviceTypeConfiguration() instanceof EfentoCoapDeviceTypeConfiguration)) {
                throw new AdaptorException("Invalid CoapDeviceTypeConfiguration type: " + coapDeviceProfileTransportConfiguration.getCoapDeviceTypeConfiguration().getClass().getSimpleName() + "!");
            }
        } else {
            throw new AdaptorException("Invalid DeviceProfileTransportConfiguration type" + transportConfiguration.getClass().getSimpleName() + "!");
        }
    }

    List<EfentoTelemetry> getEfentoMeasurements(MeasurementsProtos.ProtoMeasurements protoMeasurements, UUID sessionId) {
        String serialNumber = CoapEfentoUtils.convertByteArrayToString(protoMeasurements.getSerialNum().toByteArray());
        boolean batteryStatus = protoMeasurements.getBatteryStatus();
        int measurementPeriodBase = protoMeasurements.getMeasurementPeriodBase();
        int measurementPeriodFactor = protoMeasurements.getMeasurementPeriodFactor();
        int signal = protoMeasurements.getSignal();
        long nextTransmissionAtMillis = TimeUnit.SECONDS.toMillis(protoMeasurements.getNextTransmissionAt());
        List<MeasurementsProtos.ProtoChannel> channelsList = protoMeasurements.getChannelsList();
        if (CollectionUtils.isEmpty(channelsList)) {
            throw new IllegalStateException("[" + String.valueOf(sessionId) + "]: Failed to get Efento measurements, reason: channels list is empty!");
        }
        TreeMap<Long, JsonObject> valuesMap = new TreeMap<Long, JsonObject>();
        block0: for (int channel = 0; channel < channelsList.size(); ++channel) {
            MeasurementsProtos.ProtoChannel protoChannel = channelsList.get(channel);
            List<Integer> sampleOffsetsList = protoChannel.getSampleOffsetsList();
            if (CollectionUtils.isEmpty(sampleOffsetsList)) {
                log.trace("[{}][{}] sampleOffsetsList list is empty!", (Object)sessionId, (Object)protoChannel.getType().name());
                continue;
            }
            boolean isBinarySensor = CoapEfentoUtils.isBinarySensor(protoChannel.getType());
            int channelPeriodFactor = measurementPeriodFactor == 0 ? (isBinarySensor ? 14 : 1) : measurementPeriodFactor;
            int measurementPeriod = measurementPeriodBase * channelPeriodFactor;
            long measurementPeriodMillis = TimeUnit.SECONDS.toMillis(measurementPeriod);
            long startTimestampMillis = TimeUnit.SECONDS.toMillis(protoChannel.getTimestamp());
            for (int i = 0; i < sampleOffsetsList.size(); ++i) {
                JsonObject values;
                int sampleOffset = sampleOffsetsList.get(i);
                if (CoapEfentoUtils.isSensorError(sampleOffset)) {
                    log.warn("[{}],[{}] Sensor error value! Ignoring.", (Object)sessionId, (Object)sampleOffset);
                    continue;
                }
                if (isBinarySensor) {
                    Integer previousSampleOffset;
                    boolean currentIsOk = sampleOffset < 0;
                    Integer n = previousSampleOffset = i > 0 ? sampleOffsetsList.get(i - 1) : null;
                    if (previousSampleOffset != null) {
                        boolean previousIsOk;
                        boolean bl = previousIsOk = previousSampleOffset < 0;
                        if (currentIsOk == previousIsOk) continue block0;
                    }
                    long sampleOffsetMillis = TimeUnit.SECONDS.toMillis(sampleOffset);
                    long measurementTimestamp = startTimestampMillis + Math.abs(sampleOffsetMillis);
                    values = valuesMap.computeIfAbsent(measurementTimestamp - 1000L, k -> CoapEfentoUtils.setDefaultMeasurements(serialNumber, batteryStatus, measurementPeriod, nextTransmissionAtMillis, signal, k));
                    this.addBinarySample(protoChannel, currentIsOk, values, channel + 1, sessionId);
                    continue;
                }
                long timestampMillis = startTimestampMillis + (long)i * measurementPeriodMillis;
                values = valuesMap.computeIfAbsent(timestampMillis, k -> CoapEfentoUtils.setDefaultMeasurements(serialNumber, batteryStatus, measurementPeriod, nextTransmissionAtMillis, signal, k));
                this.addContinuesSample(protoChannel, sampleOffset, values, channel + 1, sessionId);
            }
        }
        if (CollectionUtils.isEmpty(valuesMap)) {
            throw new IllegalStateException("[" + String.valueOf(sessionId) + "]: Failed to collect Efento measurements, reason, values map is empty!");
        }
        return valuesMap.entrySet().stream().map(entry -> new EfentoTelemetry((Long)entry.getKey(), (JsonElement)entry.getValue())).collect(Collectors.toList());
    }

    private void addContinuesSample(MeasurementsProtos.ProtoChannel protoChannel, int sampleOffset, JsonObject values, int channelNumber, UUID sessionId) {
        int startPoint = protoChannel.getStartPoint();
        switch (protoChannel.getType()) {
            case MEASUREMENT_TYPE_TEMPERATURE: {
                values.addProperty("temperature_" + channelNumber, (Number)((double)(startPoint + sampleOffset) / 10.0));
                break;
            }
            case MEASUREMENT_TYPE_WATER_METER: {
                values.addProperty("pulse_counter_water_" + channelNumber, (Number)(startPoint + sampleOffset));
                break;
            }
            case MEASUREMENT_TYPE_HUMIDITY: {
                values.addProperty("humidity_" + channelNumber, (Number)(startPoint + sampleOffset));
                break;
            }
            case MEASUREMENT_TYPE_ATMOSPHERIC_PRESSURE: {
                values.addProperty("pressure_" + channelNumber, (Number)((double)(startPoint + sampleOffset) / 10.0));
                break;
            }
            case MEASUREMENT_TYPE_DIFFERENTIAL_PRESSURE: {
                values.addProperty("pressure_diff_" + channelNumber, (Number)(startPoint + sampleOffset));
                break;
            }
            case MEASUREMENT_TYPE_PULSE_CNT: {
                values.addProperty("pulse_cnt_" + channelNumber, (Number)(startPoint + sampleOffset));
                break;
            }
            case MEASUREMENT_TYPE_IAQ: {
                this.addPropertiesForMeasurementTypeWithMetadataFactor(values, "iaq_", channelNumber, startPoint + sampleOffset, 3);
                break;
            }
            case MEASUREMENT_TYPE_ELECTRICITY_METER: {
                values.addProperty("watt_hour_" + channelNumber, (Number)(startPoint + sampleOffset));
                break;
            }
            case MEASUREMENT_TYPE_SOIL_MOISTURE: {
                values.addProperty("soil_moisture_" + channelNumber, (Number)(startPoint + sampleOffset));
                break;
            }
            case MEASUREMENT_TYPE_AMBIENT_LIGHT: {
                values.addProperty("ambient_light_" + channelNumber, (Number)((double)(startPoint + sampleOffset) / 10.0));
                break;
            }
            case MEASUREMENT_TYPE_HIGH_PRESSURE: {
                values.addProperty("high_pressure_" + channelNumber, (Number)(startPoint + sampleOffset));
                break;
            }
            case MEASUREMENT_TYPE_DISTANCE_MM: {
                values.addProperty("distance_mm_" + channelNumber, (Number)(startPoint + sampleOffset));
                break;
            }
            case MEASUREMENT_TYPE_WATER_METER_ACC_MINOR: {
                this.calculateAccPulseCounterTotalValue(values, PulseCounterType.WATER_CNT_ACC, channelNumber, startPoint + sampleOffset, 6);
                break;
            }
            case MEASUREMENT_TYPE_WATER_METER_ACC_MAJOR: {
                this.addPropertiesForMeasurementTypeWithMetadataFactor(values, PulseCounterType.WATER_CNT_ACC.getPrefix(), channelNumber, startPoint + sampleOffset, 4);
                break;
            }
            case MEASUREMENT_TYPE_HUMIDITY_ACCURATE: {
                values.addProperty("humidity_relative_" + channelNumber, (Number)((double)(startPoint + sampleOffset) / 10.0));
                break;
            }
            case MEASUREMENT_TYPE_STATIC_IAQ: {
                this.addPropertiesForMeasurementTypeWithMetadataFactor(values, "static_iaq_", channelNumber, startPoint + sampleOffset, 3);
                break;
            }
            case MEASUREMENT_TYPE_CO2_GAS: {
                this.addPropertiesForMeasurementTypeWithMetadataFactor(values, "co2_gas_", channelNumber, startPoint + sampleOffset, 3);
                break;
            }
            case MEASUREMENT_TYPE_CO2_EQUIVALENT: {
                this.addPropertiesForMeasurementTypeWithMetadataFactor(values, "co2_", channelNumber, startPoint + sampleOffset, 3);
                break;
            }
            case MEASUREMENT_TYPE_BREATH_VOC: {
                this.addPropertiesForMeasurementTypeWithMetadataFactor(values, "breath_voc_", channelNumber, startPoint + sampleOffset, 3);
                break;
            }
            case MEASUREMENT_TYPE_PERCENTAGE: {
                values.addProperty("percentage_" + channelNumber, (Number)((double)(startPoint + sampleOffset) / 100.0));
                break;
            }
            case MEASUREMENT_TYPE_VOLTAGE: {
                values.addProperty("voltage_" + channelNumber, (Number)((double)(startPoint + sampleOffset) / 10.0));
                break;
            }
            case MEASUREMENT_TYPE_CURRENT: {
                values.addProperty("current_" + channelNumber, (Number)((double)(startPoint + sampleOffset) / 100.0));
                break;
            }
            case MEASUREMENT_TYPE_PULSE_CNT_ACC_MINOR: {
                this.calculateAccPulseCounterTotalValue(values, PulseCounterType.PULSE_CNT_ACC, channelNumber, startPoint + sampleOffset, 6);
                break;
            }
            case MEASUREMENT_TYPE_PULSE_CNT_ACC_MAJOR: {
                this.addPropertiesForMeasurementTypeWithMetadataFactor(values, PulseCounterType.PULSE_CNT_ACC.getPrefix(), channelNumber, startPoint + sampleOffset, 4);
                break;
            }
            case MEASUREMENT_TYPE_ELEC_METER_ACC_MINOR: {
                this.calculateAccPulseCounterTotalValue(values, PulseCounterType.ELEC_METER_ACC, channelNumber, startPoint + sampleOffset, 6);
                break;
            }
            case MEASUREMENT_TYPE_ELEC_METER_ACC_MAJOR: {
                this.addPropertiesForMeasurementTypeWithMetadataFactor(values, PulseCounterType.ELEC_METER_ACC.getPrefix(), channelNumber, startPoint + sampleOffset, 4);
                break;
            }
            case MEASUREMENT_TYPE_PULSE_CNT_ACC_WIDE_MINOR: {
                this.calculateAccPulseCounterTotalValue(values, PulseCounterType.PULSE_CNT_ACC_WIDE, channelNumber, startPoint + sampleOffset, 6);
                break;
            }
            case MEASUREMENT_TYPE_PULSE_CNT_ACC_WIDE_MAJOR: {
                this.addPropertiesForMeasurementTypeWithMetadataFactor(values, PulseCounterType.PULSE_CNT_ACC_WIDE.getPrefix(), channelNumber, startPoint + sampleOffset, 4);
                break;
            }
            case MEASUREMENT_TYPE_CURRENT_PRECISE: {
                values.addProperty("current_precise_" + channelNumber, (Number)((double)(startPoint + sampleOffset) / 1000.0));
                break;
            }
            case MEASUREMENT_TYPE_NO_SENSOR: 
            case UNRECOGNIZED: {
                log.trace("[{}][{}] Sensor error value! Ignoring.", (Object)sessionId, (Object)protoChannel.getType().name());
                break;
            }
            default: {
                log.trace("[{}],[{}] Unsupported measurementType! Ignoring.", (Object)sessionId, (Object)protoChannel.getType().name());
            }
        }
    }

    private void addPropertiesForMeasurementTypeWithMetadataFactor(JsonObject values, String prefix, int channelNumber, int value, int metadataFactor) {
        values.addProperty(prefix + channelNumber, (Number)(value / metadataFactor));
        values.addProperty(prefix + "metadata_" + channelNumber, (Number)(value % metadataFactor));
    }

    private void calculateAccPulseCounterTotalValue(JsonObject values, PulseCounterType pulseCounterType, int channelNumber, int value, int metadataFactor) {
        int minorValue = value / metadataFactor;
        int majorChannel = value % metadataFactor + 1;
        String majorPropertyKey = pulseCounterType.getPrefix() + majorChannel;
        JsonElement majorProperty = values.get(majorPropertyKey);
        if (majorProperty != null) {
            int totalValue = majorProperty.getAsInt() * pulseCounterType.getMajorResolution() + minorValue;
            values.addProperty(pulseCounterType.getPrefix() + "total_" + channelNumber, (Number)totalValue);
            values.remove(majorPropertyKey);
        }
    }

    private void addBinarySample(MeasurementsProtos.ProtoChannel protoChannel, boolean valueIsOk, JsonObject values, int channel, UUID sessionId) {
        switch (protoChannel.getType()) {
            case MEASUREMENT_TYPE_OK_ALARM: {
                values.addProperty("ok_alarm_" + channel, valueIsOk ? "OK" : "ALARM");
                break;
            }
            case MEASUREMENT_TYPE_FLOODING: {
                values.addProperty("flooding_" + channel, valueIsOk ? "OK" : "WATER_DETECTED");
                break;
            }
            case MEASUREMENT_TYPE_OUTPUT_CONTROL: {
                values.addProperty("output_control_" + channel, valueIsOk ? "OFF" : "ON");
                break;
            }
            default: {
                log.trace("[{}],[{}] Unsupported binary measurementType! Ignoring.", (Object)sessionId, (Object)protoChannel.getType().name());
            }
        }
    }

    private EfentoTelemetry getEfentoDeviceInfo(DeviceInfoProtos.ProtoDeviceInfo protoDeviceInfo) {
        JsonObject values = new JsonObject();
        values.addProperty("sw_version", (Number)protoDeviceInfo.getSwVersion());
        values.addProperty("nv_storage_status", (Number)protoDeviceInfo.getMemoryStatistics(0));
        values.addProperty("timestamp_of_the_end_of_collecting_statistics", CoapEfentoTransportResource.getDate(protoDeviceInfo.getMemoryStatistics(1)));
        values.addProperty("capacity_of_memory_in_bytes", (Number)protoDeviceInfo.getMemoryStatistics(2));
        values.addProperty("used_space_in_bytes", (Number)protoDeviceInfo.getMemoryStatistics(3));
        values.addProperty("size_of_invalid_packets_in_bytes", (Number)protoDeviceInfo.getMemoryStatistics(4));
        values.addProperty("size_of_corrupted_packets_in_bytes", (Number)protoDeviceInfo.getMemoryStatistics(5));
        values.addProperty("number_of_valid_packets", (Number)protoDeviceInfo.getMemoryStatistics(6));
        values.addProperty("number_of_invalid_packets", (Number)protoDeviceInfo.getMemoryStatistics(7));
        values.addProperty("number_of_corrupted_packets", (Number)protoDeviceInfo.getMemoryStatistics(8));
        values.addProperty("number_of_all_samples_for_channel_1", (Number)protoDeviceInfo.getMemoryStatistics(9));
        values.addProperty("number_of_all_samples_for_channel_2", (Number)protoDeviceInfo.getMemoryStatistics(10));
        values.addProperty("number_of_all_samples_for_channel_3", (Number)protoDeviceInfo.getMemoryStatistics(11));
        values.addProperty("number_of_all_samples_for_channel_4", (Number)protoDeviceInfo.getMemoryStatistics(12));
        values.addProperty("number_of_all_samples_for_channel_5", (Number)protoDeviceInfo.getMemoryStatistics(13));
        values.addProperty("number_of_all_samples_for_channel_6", (Number)protoDeviceInfo.getMemoryStatistics(14));
        values.addProperty("timestamp_of_the_first_binary_measurement", CoapEfentoTransportResource.getDate(protoDeviceInfo.getMemoryStatistics(15)));
        values.addProperty("timestamp_of_the_last_binary_measurement", CoapEfentoTransportResource.getDate(protoDeviceInfo.getMemoryStatistics(16)));
        values.addProperty("timestamp_of_the_first_binary_measurement_sent", CoapEfentoTransportResource.getDate(protoDeviceInfo.getMemoryStatistics(17)));
        values.addProperty("timestamp_of_the_first_continuous_measurement", CoapEfentoTransportResource.getDate(protoDeviceInfo.getMemoryStatistics(18)));
        values.addProperty("timestamp_of_the_last_continuous_measurement", CoapEfentoTransportResource.getDate(protoDeviceInfo.getMemoryStatistics(19)));
        values.addProperty("timestamp_of_the_last_continuous_measurement_sent", CoapEfentoTransportResource.getDate(protoDeviceInfo.getMemoryStatistics(20)));
        values.addProperty("nvm_write_counter", (Number)protoDeviceInfo.getMemoryStatistics(21));
        DeviceInfoProtos.ProtoModem modem = protoDeviceInfo.getModem();
        values.addProperty("modem_types", modem.getType().toString());
        values.addProperty("sc_EARNFCN_offset", (Number)modem.getParameters(0));
        values.addProperty("sc_EARFCN", (Number)modem.getParameters(1));
        values.addProperty("sc_PCI", (Number)modem.getParameters(2));
        values.addProperty("sc_Cell_id", (Number)modem.getParameters(3));
        values.addProperty("sc_RSRP", (Number)modem.getParameters(4));
        values.addProperty("sc_RSRQ", (Number)modem.getParameters(5));
        values.addProperty("sc_RSSI", (Number)modem.getParameters(6));
        values.addProperty("sc_SINR", (Number)modem.getParameters(7));
        values.addProperty("sc_Band", (Number)modem.getParameters(8));
        values.addProperty("sc_TAC", (Number)modem.getParameters(9));
        values.addProperty("sc_ECL", (Number)modem.getParameters(10));
        values.addProperty("sc_TX_PWR", (Number)modem.getParameters(11));
        values.addProperty("op_mode", (Number)modem.getParameters(12));
        values.addProperty("nc_EARFCN", (Number)modem.getParameters(13));
        values.addProperty("nc_EARNFCN_offset", (Number)modem.getParameters(14));
        values.addProperty("nc_PCI", (Number)modem.getParameters(15));
        values.addProperty("nc_RSRP", (Number)modem.getParameters(16));
        values.addProperty("RLC_UL_BLER", (Number)modem.getParameters(17));
        values.addProperty("RLC_DL_BLER", (Number)modem.getParameters(18));
        values.addProperty("MAC_UL_BLER", (Number)modem.getParameters(19));
        values.addProperty("MAC_DL_BLER", (Number)modem.getParameters(20));
        values.addProperty("MAC_UL_TOTAL_BYTES", (Number)modem.getParameters(21));
        values.addProperty("MAC_DL_TOTAL_BYTES", (Number)modem.getParameters(22));
        values.addProperty("MAC_UL_total_HARQ_Tx", (Number)modem.getParameters(23));
        values.addProperty("MAC_DL_total_HARQ_Tx", (Number)modem.getParameters(24));
        values.addProperty("MAC_UL_HARQ_re_Tx", (Number)modem.getParameters(25));
        values.addProperty("MAC_DL_HARQ_re_Tx", (Number)modem.getParameters(26));
        values.addProperty("RLC_UL_tput", (Number)modem.getParameters(27));
        values.addProperty("RLC_DL_tput", (Number)modem.getParameters(28));
        values.addProperty("MAC_UL_tput", (Number)modem.getParameters(29));
        values.addProperty("MAC_DL_tput", (Number)modem.getParameters(30));
        values.addProperty("sleep_duration", (Number)modem.getParameters(31));
        values.addProperty("rx_time", (Number)modem.getParameters(32));
        values.addProperty("tx_time", (Number)modem.getParameters(33));
        DeviceInfoProtos.ProtoRuntime runtimeInfo = protoDeviceInfo.getRuntimeInfo();
        values.addProperty("battery_reset_timestamp", CoapEfentoTransportResource.getDate(runtimeInfo.getBatteryResetTimestamp()));
        values.addProperty("max_mcu_temp", (Number)runtimeInfo.getMaxMcuTemperature());
        values.addProperty("mcu_temp", (Number)runtimeInfo.getMcuTemperature());
        values.addProperty("counter_of_confirmable_messages_attempts", (Number)runtimeInfo.getMessageCounters(0));
        values.addProperty("counter_of_non_confirmable_messages_attempts", (Number)runtimeInfo.getMessageCounters(1));
        values.addProperty("counter_of_succeeded_messages", (Number)runtimeInfo.getMessageCounters(2));
        values.addProperty("min_battery_mcu_temp", (Number)runtimeInfo.getMinBatteryMcuTemperature());
        values.addProperty("min_battery_voltage", (Number)runtimeInfo.getMinBatteryVoltage());
        values.addProperty("min_mcu_temp", (Number)runtimeInfo.getMinMcuTemperature());
        values.addProperty("runtime_errors", (Number)runtimeInfo.getRuntimeErrorsCount());
        values.addProperty("up_time", (Number)runtimeInfo.getUpTime());
        return new EfentoTelemetry(System.currentTimeMillis(), (JsonElement)values);
    }

    private JsonElement getEfentoConfiguration(byte[] bytes) throws InvalidProtocolBufferException {
        return JsonParser.parseString((String)ProtoConverter.dynamicMsgToJson((byte[])bytes, (Descriptors.Descriptor)((Descriptors.Descriptor)ConfigProtos.getDescriptor().getMessageTypes().get(2))));
    }

    private static String getDate(long seconds) {
        if (seconds == -1L || seconds == 0xFFFFFFFFL) {
            return "Undefined";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss Z");
        return simpleDateFormat.format(new Date(TimeUnit.SECONDS.toMillis(seconds)));
    }

    public static class EfentoTelemetry {
        private long ts;
        private JsonElement values;

        @Generated
        public long getTs() {
            return this.ts;
        }

        @Generated
        public JsonElement getValues() {
            return this.values;
        }

        @Generated
        public void setTs(long ts) {
            this.ts = ts;
        }

        @Generated
        public void setValues(JsonElement values) {
            this.values = values;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EfentoTelemetry)) {
                return false;
            }
            EfentoTelemetry other = (EfentoTelemetry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTs() != other.getTs()) {
                return false;
            }
            JsonElement this$values = this.getValues();
            JsonElement other$values = other.getValues();
            return !(this$values == null ? other$values != null : !this$values.equals(other$values));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EfentoTelemetry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $ts = this.getTs();
            result = result * 59 + (int)($ts >>> 32 ^ $ts);
            JsonElement $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : $values.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CoapEfentoTransportResource.EfentoTelemetry(ts=" + this.getTs() + ", values=" + String.valueOf(this.getValues()) + ")";
        }

        @ConstructorProperties(value={"ts", "values"})
        @Generated
        public EfentoTelemetry(long ts, JsonElement values) {
            this.ts = ts;
            this.values = values;
        }
    }
}

