/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.device.data.CoapDeviceTransportConfiguration;
import org.thingsboard.server.common.data.device.data.DeviceData;
import org.thingsboard.server.common.data.device.data.PowerMode;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.TransportConfigurationContainer;
import org.thingsboard.server.transport.coap.adaptors.CoapTransportAdaptor;
import org.thingsboard.server.transport.coap.client.DefaultCoapClientContext;
import org.thingsboard.server.transport.coap.client.TbCoapObservationState;

public class TbCoapClientState {
    private final DeviceId deviceId;
    private final Lock lock;
    private volatile TransportConfigurationContainer configuration;
    private volatile CoapTransportAdaptor adaptor;
    private volatile ValidateDeviceCredentialsResponse credentials;
    private volatile TransportProtos.SessionInfoProto session;
    private volatile DefaultCoapClientContext.CoapSessionListener listener;
    private volatile TbCoapObservationState attrs;
    private volatile TbCoapObservationState rpc;
    private volatile int contentFormat;
    private TransportProtos.AttributeUpdateNotificationMsg missedAttributeUpdates;
    private DeviceProfileId profileId;
    private PowerMode powerMode;
    private Long psmActivityTimer;
    private Long edrxCycle;
    private Long pagingTransmissionWindow;
    private boolean asleep;
    private long lastUplinkTime;
    private Future<Void> sleepTask;
    private boolean firstEdrxDownlink = true;

    public TbCoapClientState(DeviceId deviceId) {
        this.deviceId = deviceId;
        this.lock = new ReentrantLock();
    }

    public void init(ValidateDeviceCredentialsResponse credentials) {
        this.credentials = credentials;
        this.profileId = credentials.getDeviceInfo().getDeviceProfileId();
        this.powerMode = credentials.getDeviceInfo().getPowerMode();
        this.edrxCycle = credentials.getDeviceInfo().getEdrxCycle();
        this.psmActivityTimer = credentials.getDeviceInfo().getPsmActivityTimer();
        this.pagingTransmissionWindow = credentials.getDeviceInfo().getPagingTransmissionWindow();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public long updateLastUplinkTime(long ts) {
        if (ts > this.lastUplinkTime) {
            this.lastUplinkTime = ts;
            this.firstEdrxDownlink = true;
        }
        return this.lastUplinkTime;
    }

    public boolean checkFirstDownlink() {
        boolean result = this.firstEdrxDownlink;
        this.firstEdrxDownlink = false;
        return result;
    }

    public void onDeviceUpdate(Device device) {
        this.profileId = device.getDeviceProfileId();
        DeviceData data = device.getDeviceData();
        if (data.getTransportConfiguration() != null && data.getTransportConfiguration().getType().equals((Object)DeviceTransportType.COAP)) {
            CoapDeviceTransportConfiguration configuration = (CoapDeviceTransportConfiguration)data.getTransportConfiguration();
            this.powerMode = configuration.getPowerMode();
            this.edrxCycle = configuration.getEdrxCycle();
            this.psmActivityTimer = configuration.getPsmActivityTimer();
            this.pagingTransmissionWindow = configuration.getPagingTransmissionWindow();
        }
    }

    public void addQueuedNotification(TransportProtos.AttributeUpdateNotificationMsg msg) {
        if (this.missedAttributeUpdates == null) {
            this.missedAttributeUpdates = msg;
        } else {
            HashMap<String, TransportProtos.TsKvProto> updatedAttrs = new HashMap<String, TransportProtos.TsKvProto>(this.missedAttributeUpdates.getSharedUpdatedCount() + msg.getSharedUpdatedCount());
            HashSet deletedKeys = new HashSet(this.missedAttributeUpdates.getSharedDeletedCount() + msg.getSharedDeletedCount());
            for (TransportProtos.TsKvProto oldUpdatedAttrs : this.missedAttributeUpdates.getSharedUpdatedList()) {
                updatedAttrs.put(oldUpdatedAttrs.getKv().getKey(), oldUpdatedAttrs);
            }
            deletedKeys.addAll(msg.getSharedDeletedList());
            for (TransportProtos.TsKvProto newUpdatedAttrs : msg.getSharedUpdatedList()) {
                updatedAttrs.put(newUpdatedAttrs.getKv().getKey(), newUpdatedAttrs);
            }
            deletedKeys.addAll(msg.getSharedDeletedList());
            for (String deletedKey : msg.getSharedDeletedList()) {
                updatedAttrs.remove(deletedKey);
            }
            this.missedAttributeUpdates = TransportProtos.AttributeUpdateNotificationMsg.newBuilder().addAllSharedUpdated(updatedAttrs.values()).addAllSharedDeleted(deletedKeys).build();
        }
    }

    public TransportProtos.AttributeUpdateNotificationMsg getAndClearMissedUpdates() {
        TransportProtos.AttributeUpdateNotificationMsg result = this.missedAttributeUpdates;
        this.missedAttributeUpdates = null;
        return result;
    }

    @Generated
    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public Lock getLock() {
        return this.lock;
    }

    @Generated
    public TransportConfigurationContainer getConfiguration() {
        return this.configuration;
    }

    @Generated
    public CoapTransportAdaptor getAdaptor() {
        return this.adaptor;
    }

    @Generated
    public ValidateDeviceCredentialsResponse getCredentials() {
        return this.credentials;
    }

    @Generated
    public TransportProtos.SessionInfoProto getSession() {
        return this.session;
    }

    @Generated
    public DefaultCoapClientContext.CoapSessionListener getListener() {
        return this.listener;
    }

    @Generated
    public TbCoapObservationState getAttrs() {
        return this.attrs;
    }

    @Generated
    public TbCoapObservationState getRpc() {
        return this.rpc;
    }

    @Generated
    public int getContentFormat() {
        return this.contentFormat;
    }

    @Generated
    public TransportProtos.AttributeUpdateNotificationMsg getMissedAttributeUpdates() {
        return this.missedAttributeUpdates;
    }

    @Generated
    public DeviceProfileId getProfileId() {
        return this.profileId;
    }

    @Generated
    public boolean isFirstEdrxDownlink() {
        return this.firstEdrxDownlink;
    }

    @Generated
    public void setConfiguration(TransportConfigurationContainer configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setAdaptor(CoapTransportAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    @Generated
    public void setCredentials(ValidateDeviceCredentialsResponse credentials) {
        this.credentials = credentials;
    }

    @Generated
    public void setSession(TransportProtos.SessionInfoProto session) {
        this.session = session;
    }

    @Generated
    public void setListener(DefaultCoapClientContext.CoapSessionListener listener) {
        this.listener = listener;
    }

    @Generated
    public void setAttrs(TbCoapObservationState attrs) {
        this.attrs = attrs;
    }

    @Generated
    public void setRpc(TbCoapObservationState rpc) {
        this.rpc = rpc;
    }

    @Generated
    public void setContentFormat(int contentFormat) {
        this.contentFormat = contentFormat;
    }

    @Generated
    public void setMissedAttributeUpdates(TransportProtos.AttributeUpdateNotificationMsg missedAttributeUpdates) {
        this.missedAttributeUpdates = missedAttributeUpdates;
    }

    @Generated
    public void setProfileId(DeviceProfileId profileId) {
        this.profileId = profileId;
    }

    @Generated
    public void setPowerMode(PowerMode powerMode) {
        this.powerMode = powerMode;
    }

    @Generated
    public void setPsmActivityTimer(Long psmActivityTimer) {
        this.psmActivityTimer = psmActivityTimer;
    }

    @Generated
    public void setEdrxCycle(Long edrxCycle) {
        this.edrxCycle = edrxCycle;
    }

    @Generated
    public void setPagingTransmissionWindow(Long pagingTransmissionWindow) {
        this.pagingTransmissionWindow = pagingTransmissionWindow;
    }

    @Generated
    public void setLastUplinkTime(long lastUplinkTime) {
        this.lastUplinkTime = lastUplinkTime;
    }

    @Generated
    public void setFirstEdrxDownlink(boolean firstEdrxDownlink) {
        this.firstEdrxDownlink = firstEdrxDownlink;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbCoapClientState)) {
            return false;
        }
        TbCoapClientState other = (TbCoapClientState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContentFormat() != other.getContentFormat()) {
            return false;
        }
        if (this.isAsleep() != other.isAsleep()) {
            return false;
        }
        if (this.getLastUplinkTime() != other.getLastUplinkTime()) {
            return false;
        }
        if (this.isFirstEdrxDownlink() != other.isFirstEdrxDownlink()) {
            return false;
        }
        Long this$psmActivityTimer = this.getPsmActivityTimer();
        Long other$psmActivityTimer = other.getPsmActivityTimer();
        if (this$psmActivityTimer == null ? other$psmActivityTimer != null : !((Object)this$psmActivityTimer).equals(other$psmActivityTimer)) {
            return false;
        }
        Long this$edrxCycle = this.getEdrxCycle();
        Long other$edrxCycle = other.getEdrxCycle();
        if (this$edrxCycle == null ? other$edrxCycle != null : !((Object)this$edrxCycle).equals(other$edrxCycle)) {
            return false;
        }
        Long this$pagingTransmissionWindow = this.getPagingTransmissionWindow();
        Long other$pagingTransmissionWindow = other.getPagingTransmissionWindow();
        if (this$pagingTransmissionWindow == null ? other$pagingTransmissionWindow != null : !((Object)this$pagingTransmissionWindow).equals(other$pagingTransmissionWindow)) {
            return false;
        }
        DeviceId this$deviceId = this.getDeviceId();
        DeviceId other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        Lock this$lock = this.getLock();
        Lock other$lock = other.getLock();
        if (this$lock == null ? other$lock != null : !this$lock.equals(other$lock)) {
            return false;
        }
        TransportConfigurationContainer this$configuration = this.getConfiguration();
        TransportConfigurationContainer other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        CoapTransportAdaptor this$adaptor = this.getAdaptor();
        CoapTransportAdaptor other$adaptor = other.getAdaptor();
        if (this$adaptor == null ? other$adaptor != null : !this$adaptor.equals(other$adaptor)) {
            return false;
        }
        ValidateDeviceCredentialsResponse this$credentials = this.getCredentials();
        ValidateDeviceCredentialsResponse other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        TransportProtos.SessionInfoProto this$session = this.getSession();
        TransportProtos.SessionInfoProto other$session = other.getSession();
        if (this$session == null ? other$session != null : !this$session.equals(other$session)) {
            return false;
        }
        DefaultCoapClientContext.CoapSessionListener this$listener = this.getListener();
        DefaultCoapClientContext.CoapSessionListener other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        TbCoapObservationState this$attrs = this.getAttrs();
        TbCoapObservationState other$attrs = other.getAttrs();
        if (this$attrs == null ? other$attrs != null : !((Object)this$attrs).equals(other$attrs)) {
            return false;
        }
        TbCoapObservationState this$rpc = this.getRpc();
        TbCoapObservationState other$rpc = other.getRpc();
        if (this$rpc == null ? other$rpc != null : !((Object)this$rpc).equals(other$rpc)) {
            return false;
        }
        TransportProtos.AttributeUpdateNotificationMsg this$missedAttributeUpdates = this.getMissedAttributeUpdates();
        TransportProtos.AttributeUpdateNotificationMsg other$missedAttributeUpdates = other.getMissedAttributeUpdates();
        if (this$missedAttributeUpdates == null ? other$missedAttributeUpdates != null : !this$missedAttributeUpdates.equals(other$missedAttributeUpdates)) {
            return false;
        }
        DeviceProfileId this$profileId = this.getProfileId();
        DeviceProfileId other$profileId = other.getProfileId();
        if (this$profileId == null ? other$profileId != null : !this$profileId.equals(other$profileId)) {
            return false;
        }
        PowerMode this$powerMode = this.getPowerMode();
        PowerMode other$powerMode = other.getPowerMode();
        if (this$powerMode == null ? other$powerMode != null : !this$powerMode.equals(other$powerMode)) {
            return false;
        }
        Future<Void> this$sleepTask = this.getSleepTask();
        Future<Void> other$sleepTask = other.getSleepTask();
        return !(this$sleepTask == null ? other$sleepTask != null : !this$sleepTask.equals(other$sleepTask));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TbCoapClientState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContentFormat();
        result = result * 59 + (this.isAsleep() ? 79 : 97);
        long $lastUplinkTime = this.getLastUplinkTime();
        result = result * 59 + (int)($lastUplinkTime >>> 32 ^ $lastUplinkTime);
        result = result * 59 + (this.isFirstEdrxDownlink() ? 79 : 97);
        Long $psmActivityTimer = this.getPsmActivityTimer();
        result = result * 59 + ($psmActivityTimer == null ? 43 : ((Object)$psmActivityTimer).hashCode());
        Long $edrxCycle = this.getEdrxCycle();
        result = result * 59 + ($edrxCycle == null ? 43 : ((Object)$edrxCycle).hashCode());
        Long $pagingTransmissionWindow = this.getPagingTransmissionWindow();
        result = result * 59 + ($pagingTransmissionWindow == null ? 43 : ((Object)$pagingTransmissionWindow).hashCode());
        DeviceId $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        Lock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        TransportConfigurationContainer $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        CoapTransportAdaptor $adaptor = this.getAdaptor();
        result = result * 59 + ($adaptor == null ? 43 : $adaptor.hashCode());
        ValidateDeviceCredentialsResponse $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        TransportProtos.SessionInfoProto $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        DefaultCoapClientContext.CoapSessionListener $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        TbCoapObservationState $attrs = this.getAttrs();
        result = result * 59 + ($attrs == null ? 43 : ((Object)$attrs).hashCode());
        TbCoapObservationState $rpc = this.getRpc();
        result = result * 59 + ($rpc == null ? 43 : ((Object)$rpc).hashCode());
        TransportProtos.AttributeUpdateNotificationMsg $missedAttributeUpdates = this.getMissedAttributeUpdates();
        result = result * 59 + ($missedAttributeUpdates == null ? 43 : $missedAttributeUpdates.hashCode());
        DeviceProfileId $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : $profileId.hashCode());
        PowerMode $powerMode = this.getPowerMode();
        result = result * 59 + ($powerMode == null ? 43 : $powerMode.hashCode());
        Future<Void> $sleepTask = this.getSleepTask();
        result = result * 59 + ($sleepTask == null ? 43 : $sleepTask.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TbCoapClientState(deviceId=" + String.valueOf(this.getDeviceId()) + ", lock=" + String.valueOf(this.getLock()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", adaptor=" + String.valueOf(this.getAdaptor()) + ", credentials=" + String.valueOf(this.getCredentials()) + ", session=" + String.valueOf(this.getSession()) + ", listener=" + String.valueOf(this.getListener()) + ", attrs=" + String.valueOf(this.getAttrs()) + ", rpc=" + String.valueOf(this.getRpc()) + ", contentFormat=" + this.getContentFormat() + ", missedAttributeUpdates=" + String.valueOf(this.getMissedAttributeUpdates()) + ", profileId=" + String.valueOf(this.getProfileId()) + ", powerMode=" + String.valueOf(this.getPowerMode()) + ", psmActivityTimer=" + this.getPsmActivityTimer() + ", edrxCycle=" + this.getEdrxCycle() + ", pagingTransmissionWindow=" + this.getPagingTransmissionWindow() + ", asleep=" + this.isAsleep() + ", lastUplinkTime=" + this.getLastUplinkTime() + ", sleepTask=" + String.valueOf(this.getSleepTask()) + ", firstEdrxDownlink=" + this.isFirstEdrxDownlink() + ")";
    }

    @Generated
    public PowerMode getPowerMode() {
        return this.powerMode;
    }

    @Generated
    public Long getPsmActivityTimer() {
        return this.psmActivityTimer;
    }

    @Generated
    public Long getEdrxCycle() {
        return this.edrxCycle;
    }

    @Generated
    public Long getPagingTransmissionWindow() {
        return this.pagingTransmissionWindow;
    }

    @Generated
    public boolean isAsleep() {
        return this.asleep;
    }

    @Generated
    public void setAsleep(boolean asleep) {
        this.asleep = asleep;
    }

    @Generated
    public long getLastUplinkTime() {
        return this.lastUplinkTime;
    }

    @Generated
    public Future<Void> getSleepTask() {
        return this.sleepTask;
    }

    @Generated
    public void setSleepTask(Future<Void> sleepTask) {
        this.sleepTask = sleepTask;
    }
}

