/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.ThingsBoardThreadFactory;

public class NoSecObserveClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoSecObserveClient.class);
    private static final long INFINIT_EXCHANGE_LIFETIME = 0L;
    private CoapClient coapClient;
    private CoapObserveRelation observeRelation;
    private ExecutorService executor = Executors.newFixedThreadPool(1, (ThreadFactory)ThingsBoardThreadFactory.forName((String)this.getClass().getSimpleName()));
    private CountDownLatch latch;

    public NoSecObserveClient(String host, int port, String accessToken) throws URISyntaxException {
        URI uri = new URI(this.getFutureUrl(host, port, accessToken));
        this.coapClient = new CoapClient(uri);
        this.coapClient.setTimeout(Long.valueOf(0L));
        this.latch = new CountDownLatch(5);
    }

    public void start() {
        this.executor.submit(() -> {
            try {
                Request request = Request.newGet();
                request.setObserve();
                this.observeRelation = this.coapClient.observe(request, new CoapHandler(){

                    public void onLoad(CoapResponse response) {
                        String responseText = response.getResponseText();
                        CoAP.ResponseCode code = response.getCode();
                        Integer observe = response.getOptions().getObserve();
                        log.info("CoAP Response received! responseText: {}, code: {}, observe seq number: {}", new Object[]{responseText, code, observe});
                        NoSecObserveClient.this.latch.countDown();
                    }

                    public void onError() {
                        log.error("Ack error!");
                        NoSecObserveClient.this.latch.countDown();
                    }
                });
            }
            catch (Exception e) {
                log.error("Error occurred while sending COAP requests: ");
            }
        });
        try {
            this.latch.await();
            this.observeRelation.proactiveCancel();
        }
        catch (InterruptedException e) {
            log.error("Error occurred: ", (Throwable)e);
        }
    }

    private String getFutureUrl(String host, Integer port, String accessToken) {
        return "coap://" + host + ":" + port + "/api/v1/" + accessToken + "/attributes";
    }

    public static void main(String[] args) throws URISyntaxException {
        log.info("Usage: java -cp ... org.thingsboard.server.transport.coap.client.NoSecObserveClient host port accessToken");
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String accessToken = args[2];
        NoSecObserveClient client = new NoSecObserveClient(host, port, accessToken);
        client.start();
    }
}

