/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.client;

import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.thingsboard.server.coapserver.CoapServerContext;
import org.thingsboard.server.coapserver.TbCoapTransportComponent;
import org.thingsboard.server.common.adaptor.AdaptorException;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.device.data.PowerMode;
import org.thingsboard.server.common.data.device.data.PowerSavingConfiguration;
import org.thingsboard.server.common.data.device.profile.CoapDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.CoapDeviceTypeConfiguration;
import org.thingsboard.server.common.data.device.profile.DefaultCoapDeviceTypeConfiguration;
import org.thingsboard.server.common.data.device.profile.DefaultDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.DeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.JsonTransportPayloadConfiguration;
import org.thingsboard.server.common.data.device.profile.ProtoTransportPayloadConfiguration;
import org.thingsboard.server.common.data.device.profile.TransportPayloadTypeConfiguration;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.rpc.RpcStatus;
import org.thingsboard.server.common.msg.session.FeatureType;
import org.thingsboard.server.common.transport.DeviceDeletedEvent;
import org.thingsboard.server.common.transport.DeviceProfileUpdatedEvent;
import org.thingsboard.server.common.transport.DeviceUpdatedEvent;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.common.transport.TransportContext;
import org.thingsboard.server.common.transport.TransportDeviceProfileCache;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.SessionInfoCreator;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.transport.coap.CoapSessionMsgType;
import org.thingsboard.server.transport.coap.CoapTransportContext;
import org.thingsboard.server.transport.coap.TbCoapMessageObserver;
import org.thingsboard.server.transport.coap.TransportConfigurationContainer;
import org.thingsboard.server.transport.coap.adaptors.CoapTransportAdaptor;
import org.thingsboard.server.transport.coap.callback.AbstractSyncSessionCallback;
import org.thingsboard.server.transport.coap.callback.CoapNoOpCallback;
import org.thingsboard.server.transport.coap.callback.CoapResponseCallback;
import org.thingsboard.server.transport.coap.callback.CoapResponseCodeCallback;
import org.thingsboard.server.transport.coap.client.CoapClientContext;
import org.thingsboard.server.transport.coap.client.TbCoapClientState;
import org.thingsboard.server.transport.coap.client.TbCoapContentFormatUtil;
import org.thingsboard.server.transport.coap.client.TbCoapObservationState;

@Service
@TbCoapTransportComponent
public class DefaultCoapClientContext
implements CoapClientContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCoapClientContext.class);
    private final CoapServerContext config;
    private final CoapTransportContext transportContext;
    private final TransportService transportService;
    private final TransportDeviceProfileCache profileCache;
    private final PartitionService partitionService;
    private final ConcurrentMap<DeviceId, TbCoapClientState> clients = new ConcurrentHashMap<DeviceId, TbCoapClientState>();
    private final ConcurrentMap<String, TbCoapClientState> clientsByToken = new ConcurrentHashMap<String, TbCoapClientState>();

    public DefaultCoapClientContext(CoapServerContext config, @Lazy CoapTransportContext transportContext, TransportService transportService, TransportDeviceProfileCache profileCache, PartitionService partitionService) {
        this.config = config;
        this.transportContext = transportContext;
        this.transportService = transportService;
        this.profileCache = profileCache;
        this.partitionService = partitionService;
    }

    @EventListener(value={DeviceProfileUpdatedEvent.class})
    public void onApplicationEvent(DeviceProfileUpdatedEvent event) {
        DeviceProfile deviceProfile = event.getDeviceProfile();
        this.clients.values().stream().filter(state -> state.getSession() == null).forEach(state -> {
            state.lock();
            try {
                if (deviceProfile.getId().equals((Object)state.getProfileId())) {
                    this.initStateAdaptor(deviceProfile, (TbCoapClientState)state);
                }
            }
            catch (AdaptorException e) {
                log.trace("[{}] Failed to update client state due to: ", (Object)state.getDeviceId(), (Object)e);
            }
            finally {
                state.unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={DeviceUpdatedEvent.class})
    public void onApplicationEvent(DeviceUpdatedEvent event) {
        Device device = event.getDevice();
        TbCoapClientState state = (TbCoapClientState)this.clients.get(device.getId());
        if (state == null) {
            return;
        }
        state.lock();
        try {
            if (state.getSession() == null) {
                this.clients.remove(device.getId());
            }
        }
        finally {
            state.unlock();
        }
    }

    @EventListener(value={DeviceDeletedEvent.class})
    public void onApplicationEvent(DeviceDeletedEvent event) {
        this.clients.remove(event.getDeviceId());
    }

    @Override
    public boolean registerAttributeObservation(TbCoapClientState clientState, String token, CoapExchange exchange) {
        return this.registerFeatureObservation(clientState, token, exchange, FeatureType.ATTRIBUTES);
    }

    @Override
    public boolean registerRpcObservation(TbCoapClientState clientState, String token, CoapExchange exchange) {
        return this.registerFeatureObservation(clientState, token, exchange, FeatureType.RPC);
    }

    @Override
    public AtomicInteger getNotificationCounterByToken(String token) {
        TbCoapClientState state = (TbCoapClientState)this.clientsByToken.get(token);
        if (state == null) {
            log.trace("Failed to find state using token: {}", (Object)token);
            return null;
        }
        if (state.getAttrs() != null && state.getAttrs().getToken().equals(token)) {
            return state.getAttrs().getObserveCounter();
        }
        log.trace("Failed to find attr subscription using token: {}", (Object)token);
        if (state.getRpc() != null && state.getRpc().getToken().equals(token)) {
            return state.getRpc().getObserveCounter();
        }
        log.trace("Failed to find rpc subscription using token: {}", (Object)token);
        return null;
    }

    @Override
    public void registerObserveRelation(String token, ObserveRelation relation) {
        TbCoapClientState state = (TbCoapClientState)this.clientsByToken.get(token);
        if (state == null) {
            log.trace("Failed to find state using token: {}", (Object)token);
            return;
        }
        if (state.getAttrs() != null && state.getAttrs().getToken().equals(token)) {
            state.getAttrs().setObserveRelation(relation);
        } else {
            log.trace("Failed to find attr subscription using token: {}", (Object)token);
        }
        if (state.getRpc() != null && state.getRpc().getToken().equals(token)) {
            state.getRpc().setObserveRelation(relation);
        } else {
            log.trace("Failed to find rpc subscription using token: {}", (Object)token);
        }
    }

    @Override
    public void deregisterObserveRelation(String token) {
        TbCoapClientState state = (TbCoapClientState)this.clientsByToken.remove(token);
        if (state == null) {
            log.trace("Failed to find state using token: {}", (Object)token);
            return;
        }
        if (state.getAttrs() != null && state.getAttrs().getToken().equals(token)) {
            this.cancelAttributeSubscription(state);
        } else {
            log.trace("Failed to find attr subscription using token: {}", (Object)token);
        }
        if (state.getRpc() != null && state.getRpc().getToken().equals(token)) {
            this.cancelRpcSubscription(state);
        } else {
            log.trace("Failed to find rpc subscription using token: {}", (Object)token);
        }
    }

    @Override
    public void reportActivity() {
        for (TbCoapClientState state : this.clients.values()) {
            if (state.getSession() == null) continue;
            this.transportService.recordActivity(state.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUplink(TbCoapClientState client, boolean notifyOtherServers, long uplinkTs) {
        Optional<CoapDeviceProfileTransportConfiguration> clientProfile;
        PowerMode powerMode = client.getPowerMode();
        PowerSavingConfiguration profileSettings = null;
        if (powerMode == null && client.getProfileId() != null && (clientProfile = this.getProfile(client.getProfileId())).isPresent() && (profileSettings = clientProfile.get().getClientSettings()) != null) {
            powerMode = profileSettings.getPowerMode();
        }
        if (powerMode == null || PowerMode.DRX.equals((Object)powerMode)) {
            client.updateLastUplinkTime(uplinkTs);
            return;
        }
        client.lock();
        try {
            long uplinkTime = client.updateLastUplinkTime(uplinkTs);
            long timeout = this.getTimeout(client, powerMode, profileSettings);
            Future<Void> sleepTask = client.getSleepTask();
            if (sleepTask != null) {
                sleepTask.cancel(false);
            }
            ScheduledFuture task = this.transportContext.getScheduler().schedule(() -> {
                if (uplinkTime == client.getLastUplinkTime()) {
                    this.asleep(client);
                }
                return null;
            }, timeout, TimeUnit.MILLISECONDS);
            client.setSleepTask(task);
            if (notifyOtherServers && this.partitionService.countTransportsByType("COAP") > 1) {
                this.transportService.notifyAboutUplink(this.getNewSyncSession(client), TransportProtos.UplinkNotificationMsg.newBuilder().setUplinkTs(uplinkTime).build(), TransportServiceCallback.EMPTY);
            }
        }
        finally {
            client.unlock();
        }
    }

    private long getTimeout(TbCoapClientState client, PowerMode powerMode, PowerSavingConfiguration profileSettings) {
        long timeout;
        if (PowerMode.PSM.equals((Object)powerMode)) {
            Long psmActivityTimer = client.getPsmActivityTimer();
            if (psmActivityTimer == null && profileSettings != null) {
                psmActivityTimer = profileSettings.getPsmActivityTimer();
            }
            if (psmActivityTimer == null || psmActivityTimer == 0L) {
                psmActivityTimer = this.transportContext.getPsmActivityTimer();
            }
            timeout = psmActivityTimer;
        } else {
            Long pagingTransmissionWindow = client.getPagingTransmissionWindow();
            if (pagingTransmissionWindow == null && profileSettings != null) {
                pagingTransmissionWindow = profileSettings.getPagingTransmissionWindow();
            }
            if (pagingTransmissionWindow == null || pagingTransmissionWindow == 0L) {
                pagingTransmissionWindow = this.transportContext.getPagingTransmissionWindow();
            }
            timeout = pagingTransmissionWindow;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerFeatureObservation(TbCoapClientState state, String token, CoapExchange exchange, FeatureType featureType) {
        state.lock();
        try {
            boolean newObservation;
            if (FeatureType.ATTRIBUTES.equals((Object)featureType)) {
                if (state.getAttrs() == null) {
                    newObservation = true;
                    state.setAttrs(new TbCoapObservationState(exchange, token));
                } else {
                    boolean bl = newObservation = !state.getAttrs().getToken().equals(token);
                    if (newObservation) {
                        old = state.getAttrs();
                        state.setAttrs(new TbCoapObservationState(exchange, token));
                        old.getExchange().respond(CoAP.ResponseCode.DELETED);
                    }
                }
            } else if (state.getRpc() == null) {
                newObservation = true;
                state.setRpc(new TbCoapObservationState(exchange, token));
            } else {
                boolean bl = newObservation = !state.getRpc().getToken().equals(token);
                if (newObservation) {
                    old = state.getRpc();
                    state.setRpc(new TbCoapObservationState(exchange, token));
                    old.getExchange().respond(CoAP.ResponseCode.DELETED);
                }
            }
            if (newObservation) {
                this.clientsByToken.put(token, state);
                if (state.getSession() == null) {
                    TransportProtos.SessionInfoProto session = SessionInfoCreator.create((ValidateDeviceCredentialsResponse)state.getCredentials(), (TransportContext)this.transportContext, (UUID)UUID.randomUUID());
                    state.setSession(session);
                    CoapSessionListener listener = new CoapSessionListener(state);
                    state.setListener(listener);
                    this.transportService.registerAsyncSession(session, (SessionMsgListener)state.getListener());
                    this.transportService.process(session, DefaultCoapClientContext.getSessionEventMsg(TransportProtos.SessionEvent.OPEN), null);
                }
                if (FeatureType.ATTRIBUTES.equals((Object)featureType)) {
                    this.transportService.process(state.getSession(), TransportProtos.SubscribeToAttributeUpdatesMsg.getDefaultInstance(), (TransportServiceCallback)new CoapNoOpCallback(exchange));
                    this.transportService.process(state.getSession(), TransportProtos.GetAttributeRequestMsg.newBuilder().setOnlyShared(true).build(), (TransportServiceCallback)new CoapNoOpCallback(exchange));
                } else {
                    Response response = new Response(CoAP.ResponseCode.VALID);
                    if (state.getRpc() == null) {
                        state.setRpc(new TbCoapObservationState(exchange, token));
                    }
                    response.getOptions().setObserve(state.getRpc().getObserveCounter().getAndIncrement());
                    this.transportService.process(state.getSession(), TransportProtos.SubscribeToRPCMsg.getDefaultInstance(), (TransportServiceCallback)new CoapResponseCallback(exchange, response, new Response(CoAP.ResponseCode.INTERNAL_SERVER_ERROR)));
                }
            }
            boolean bl = newObservation;
            return bl;
        }
        finally {
            state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterAttributeObservation(TbCoapClientState state, String token, CoapExchange exchange) {
        state.lock();
        try {
            this.clientsByToken.remove(token);
            if (state.getSession() == null) {
                log.trace("[{}] Failed to delete attribute observation: {}. Session is not present.", (Object)state.getDeviceId(), (Object)token);
                return;
            }
            if (state.getAttrs() == null) {
                log.trace("[{}] Failed to delete attribute observation: {}. It is not registered.", (Object)state.getDeviceId(), (Object)token);
                return;
            }
            if (!state.getAttrs().getToken().equals(token)) {
                log.trace("[{}] Failed to delete attribute observation: {}. Token mismatch.", (Object)state.getDeviceId(), (Object)token);
                return;
            }
            this.cancelAttributeSubscription(state);
        }
        finally {
            state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterRpcObservation(TbCoapClientState state, String token, CoapExchange exchange) {
        state.lock();
        try {
            this.clientsByToken.remove(token);
            if (state.getSession() == null) {
                log.trace("[{}] Failed to delete rpc observation: {}. Session is not present.", (Object)state.getDeviceId(), (Object)token);
                return;
            }
            if (state.getRpc() == null) {
                log.trace("[{}] Failed to delete rpc observation: {}. It is not registered.", (Object)state.getDeviceId(), (Object)token);
                return;
            }
            if (!state.getRpc().getToken().equals(token)) {
                log.trace("[{}] Failed to delete rpc observation: {}. Token mismatch.", (Object)state.getDeviceId(), (Object)token);
                return;
            }
            this.cancelRpcSubscription(state);
        }
        finally {
            state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TbCoapClientState getOrCreateClient(CoapSessionMsgType type, ValidateDeviceCredentialsResponse deviceCredentials, DeviceProfile deviceProfile) throws AdaptorException {
        DeviceId deviceId = deviceCredentials.getDeviceInfo().getDeviceId();
        TbCoapClientState state = this.getClientState(deviceId);
        state.lock();
        try {
            if (state.getConfiguration() == null || state.getAdaptor() == null) {
                this.initStateAdaptor(deviceProfile, state);
            }
            if (state.getCredentials() == null) {
                state.init(deviceCredentials);
            }
        }
        finally {
            state.unlock();
        }
        return state;
    }

    @Override
    public TransportProtos.SessionInfoProto getNewSyncSession(TbCoapClientState state) {
        return SessionInfoCreator.create((ValidateDeviceCredentialsResponse)state.getCredentials(), (TransportContext)this.transportContext, (UUID)UUID.randomUUID());
    }

    private TbCoapClientState getClientState(DeviceId deviceId) {
        return this.clients.computeIfAbsent(deviceId, TbCoapClientState::new);
    }

    private static TransportProtos.SessionEventMsg getSessionEventMsg(TransportProtos.SessionEvent event) {
        return TransportProtos.SessionEventMsg.newBuilder().setSessionType(TransportProtos.SessionType.ASYNC).setEvent(event).build();
    }

    private TransportConfigurationContainer getTransportConfigurationContainer(DeviceProfile deviceProfile) throws AdaptorException {
        DeviceProfileTransportConfiguration transportConfiguration = deviceProfile.getProfileData().getTransportConfiguration();
        if (transportConfiguration instanceof DefaultDeviceProfileTransportConfiguration) {
            return new TransportConfigurationContainer(true);
        }
        if (transportConfiguration instanceof CoapDeviceProfileTransportConfiguration) {
            CoapDeviceProfileTransportConfiguration coapDeviceProfileTransportConfiguration = (CoapDeviceProfileTransportConfiguration)transportConfiguration;
            CoapDeviceTypeConfiguration coapDeviceTypeConfiguration = coapDeviceProfileTransportConfiguration.getCoapDeviceTypeConfiguration();
            if (coapDeviceTypeConfiguration instanceof DefaultCoapDeviceTypeConfiguration) {
                DefaultCoapDeviceTypeConfiguration defaultCoapDeviceTypeConfiguration = (DefaultCoapDeviceTypeConfiguration)coapDeviceTypeConfiguration;
                TransportPayloadTypeConfiguration transportPayloadTypeConfiguration = defaultCoapDeviceTypeConfiguration.getTransportPayloadTypeConfiguration();
                if (transportPayloadTypeConfiguration instanceof JsonTransportPayloadConfiguration) {
                    return new TransportConfigurationContainer(true);
                }
                ProtoTransportPayloadConfiguration protoTransportPayloadConfiguration = (ProtoTransportPayloadConfiguration)transportPayloadTypeConfiguration;
                String deviceTelemetryProtoSchema = protoTransportPayloadConfiguration.getDeviceTelemetryProtoSchema();
                String deviceAttributesProtoSchema = protoTransportPayloadConfiguration.getDeviceAttributesProtoSchema();
                String deviceRpcRequestProtoSchema = protoTransportPayloadConfiguration.getDeviceRpcRequestProtoSchema();
                String deviceRpcResponseProtoSchema = protoTransportPayloadConfiguration.getDeviceRpcResponseProtoSchema();
                return new TransportConfigurationContainer(false, protoTransportPayloadConfiguration.getTelemetryDynamicMessageDescriptor(deviceTelemetryProtoSchema), protoTransportPayloadConfiguration.getAttributesDynamicMessageDescriptor(deviceAttributesProtoSchema), protoTransportPayloadConfiguration.getRpcResponseDynamicMessageDescriptor(deviceRpcResponseProtoSchema), protoTransportPayloadConfiguration.getRpcRequestDynamicMessageBuilder(deviceRpcRequestProtoSchema));
            }
            throw new AdaptorException("Invalid CoapDeviceTypeConfiguration type: " + coapDeviceTypeConfiguration.getClass().getSimpleName() + "!");
        }
        throw new AdaptorException("Invalid DeviceProfileTransportConfiguration type" + transportConfiguration.getClass().getSimpleName() + "!");
    }

    private void initStateAdaptor(DeviceProfile deviceProfile, TbCoapClientState state) throws AdaptorException {
        state.setConfiguration(this.getTransportConfigurationContainer(deviceProfile));
        state.setAdaptor(this.getCoapTransportAdaptor(state.getConfiguration().isJsonPayload()));
        state.setContentFormat(state.getAdaptor().getContentFormat());
    }

    private CoapTransportAdaptor getCoapTransportAdaptor(boolean jsonPayloadType) {
        return jsonPayloadType ? this.transportContext.getJsonCoapAdaptor() : this.transportContext.getProtoCoapAdaptor();
    }

    private boolean asleep(TbCoapClientState client) {
        boolean changed = this.compareAndSetSleepFlag(client, true);
        if (changed) {
            log.debug("[{}] client is sleeping", (Object)client.getDeviceId());
            this.transportService.log(client.getSession(), "Info: Client is sleeping!");
        }
        return changed;
    }

    @Override
    public boolean awake(TbCoapClientState client) {
        return this.awake(client, true, System.currentTimeMillis());
    }

    private boolean awake(TbCoapClientState client, boolean notifyOtherServers, long uplinkTs) {
        this.onUplink(client, notifyOtherServers, uplinkTs);
        boolean changed = this.compareAndSetSleepFlag(client, false);
        if (changed) {
            log.debug("[{}] client is awake", (Object)client.getDeviceId());
            this.transportService.log(client.getSession(), "Info: Client is awake!");
            this.sendMsgsAfterSleeping(client);
        }
        return changed;
    }

    private void sendMsgsAfterSleeping(TbCoapClientState client) {
        if (client.getRpc() != null) {
            TransportProtos.TransportToDeviceActorMsg persistentRpcRequestMsg = TransportProtos.TransportToDeviceActorMsg.newBuilder().setSessionInfo(client.getSession()).setSendPendingRPC(TransportProtos.SendPendingRPCMsg.newBuilder().build()).build();
            this.transportService.process(persistentRpcRequestMsg, TransportServiceCallback.EMPTY);
        }
        if (client.getAttrs() != null && client.getMissedAttributeUpdates() != null) {
            client.getListener().onAttributeUpdate(new UUID(client.getSession().getSessionIdMSB(), client.getSession().getSessionIdLSB()), client.getAndClearMissedUpdates());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareAndSetSleepFlag(TbCoapClientState client, boolean sleeping) {
        if (sleeping == client.isAsleep()) {
            log.trace("[{}] Client is already at sleeping: {}, ignoring event: {}", new Object[]{client.getDeviceId(), client.isAsleep(), sleeping});
            return false;
        }
        client.lock();
        try {
            if (sleeping == client.isAsleep()) {
                log.trace("[{}] Client is already at sleeping: {}, ignoring event: {}", new Object[]{client.getDeviceId(), client.isAsleep(), sleeping});
                boolean bl = false;
                return bl;
            }
            PowerMode powerMode = this.getPowerMode(client);
            if (PowerMode.PSM.equals((Object)powerMode) || PowerMode.E_DRX.equals((Object)powerMode)) {
                log.trace("[{}] Switch sleeping from: {} to: {}", new Object[]{client.getDeviceId(), client.isAsleep(), sleeping});
                client.setAsleep(sleeping);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            client.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDownlinkAllowed(TbCoapClientState client) {
        Optional<CoapDeviceProfileTransportConfiguration> clientProfile;
        PowerMode powerMode = client.getPowerMode();
        PowerSavingConfiguration profileSettings = null;
        if (powerMode == null && client.getProfileId() != null && (clientProfile = this.getProfile(client.getProfileId())).isPresent() && (profileSettings = clientProfile.get().getClientSettings()) != null) {
            powerMode = profileSettings.getPowerMode();
        }
        if (powerMode == null || PowerMode.DRX.equals((Object)powerMode)) {
            return true;
        }
        client.lock();
        long timeSinceLastUplink = System.currentTimeMillis() - client.getLastUplinkTime();
        try {
            boolean allowed;
            if (PowerMode.PSM.equals((Object)powerMode)) {
                Long psmActivityTimer = client.getPsmActivityTimer();
                if (psmActivityTimer == null && profileSettings != null) {
                    psmActivityTimer = profileSettings.getPsmActivityTimer();
                }
                if (psmActivityTimer == null || psmActivityTimer == 0L) {
                    psmActivityTimer = this.transportContext.getPsmActivityTimer();
                }
                boolean bl = timeSinceLastUplink <= psmActivityTimer;
                return bl;
            }
            Long pagingTransmissionWindow = client.getPagingTransmissionWindow();
            if (pagingTransmissionWindow == null && profileSettings != null) {
                pagingTransmissionWindow = profileSettings.getPagingTransmissionWindow();
            }
            if (pagingTransmissionWindow == null || pagingTransmissionWindow == 0L) {
                pagingTransmissionWindow = this.transportContext.getPagingTransmissionWindow();
            }
            boolean bl = allowed = timeSinceLastUplink <= pagingTransmissionWindow;
            if (!allowed) {
                boolean bl2 = client.checkFirstDownlink();
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            client.unlock();
        }
    }

    private PowerMode getPowerMode(TbCoapClientState client) {
        PowerMode powerMode = client.getPowerMode();
        if (powerMode == null) {
            Optional<CoapDeviceProfileTransportConfiguration> deviceProfile;
            powerMode = PowerMode.PSM;
            if (client.getProfileId() != null && (deviceProfile = this.getProfile(client.getProfileId())).isPresent()) {
                powerMode = deviceProfile.get().getClientSettings().getPowerMode();
            }
        }
        return powerMode;
    }

    public Optional<CoapDeviceProfileTransportConfiguration> getProfile(DeviceProfileId profileId) {
        DeviceProfile deviceProfile = this.profileCache.get(profileId);
        if (deviceProfile.getTransportType().equals((Object)DeviceTransportType.COAP)) {
            return Optional.of((CoapDeviceProfileTransportConfiguration)deviceProfile.getProfileData().getTransportConfiguration());
        }
        if (deviceProfile.getTransportType().equals((Object)DeviceTransportType.DEFAULT)) {
            return Optional.empty();
        }
        log.warn("[{}] Invalid device profile type: {}", (Object)profileId, (Object)deviceProfile.getTransportType());
        throw new IllegalArgumentException("Invalid device profile type: " + String.valueOf(deviceProfile.getTransportType()));
    }

    protected int getNextMsgId() {
        return ThreadLocalRandom.current().nextInt(-1, 65536);
    }

    private void cancelRpcSubscription(TbCoapClientState state) {
        if (state.getRpc() != null) {
            this.clientsByToken.remove(state.getRpc().getToken());
            CoapExchange exchange = state.getRpc().getExchange();
            state.setRpc(null);
            this.transportService.process(state.getSession(), TransportProtos.SubscribeToRPCMsg.newBuilder().setUnsubscribe(true).build(), (TransportServiceCallback)new CoapResponseCodeCallback(exchange, CoAP.ResponseCode.DELETED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
            if (state.getAttrs() == null) {
                this.closeAndCleanup(state);
            }
        }
    }

    private void cancelAttributeSubscription(TbCoapClientState state) {
        if (state.getAttrs() != null) {
            this.clientsByToken.remove(state.getAttrs().getToken());
            CoapExchange exchange = state.getAttrs().getExchange();
            state.setAttrs(null);
            this.transportService.process(state.getSession(), TransportProtos.SubscribeToAttributeUpdatesMsg.newBuilder().setUnsubscribe(true).build(), (TransportServiceCallback)new CoapResponseCodeCallback(exchange, CoAP.ResponseCode.DELETED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
            if (state.getRpc() == null) {
                this.closeAndCleanup(state);
            }
        }
    }

    private void closeAndCleanup(TbCoapClientState state) {
        this.transportService.process(state.getSession(), DefaultCoapClientContext.getSessionEventMsg(TransportProtos.SessionEvent.CLOSED), null);
        this.transportService.deregisterSession(state.getSession());
        state.setSession(null);
        state.setConfiguration(null);
        state.setCredentials(null);
        state.setAdaptor(null);
    }

    private void respond(CoapExchange exchange, Response response, int defContentFormat) {
        response.getOptions().setContentFormat(TbCoapContentFormatUtil.getContentFormat(exchange.getRequestOptions().getContentFormat(), defContentFormat));
        exchange.respond(response);
    }

    public class CoapSessionListener
    implements SessionMsgListener {
        private final TbCoapClientState state;

        public void onGetAttributesResponse(TransportProtos.GetAttributeResponseMsg msg) {
            TbCoapObservationState attrs = this.state.getAttrs();
            if (attrs != null) {
                try {
                    Response response = this.state.getAdaptor().convertToPublish(msg);
                    response.getOptions().setObserve(attrs.getObserveCounter().getAndIncrement());
                    DefaultCoapClientContext.this.respond(attrs.getExchange(), response, this.state.getContentFormat());
                }
                catch (AdaptorException e) {
                    log.trace("Failed to reply due to error", (Throwable)e);
                    this.cancelObserveRelation(attrs);
                    DefaultCoapClientContext.this.cancelAttributeSubscription(this.state);
                }
            } else {
                log.debug("[{}] Get Attrs exchange is empty", (Object)this.state.getDeviceId());
            }
        }

        public void onAttributeUpdate(UUID sessionId, TransportProtos.AttributeUpdateNotificationMsg msg) {
            if (!DefaultCoapClientContext.this.isDownlinkAllowed(this.state)) {
                log.trace("[{}] ignore downlink request cause client is sleeping.", (Object)this.state.getDeviceId());
                this.state.lock();
                try {
                    this.state.addQueuedNotification(msg);
                }
                finally {
                    this.state.unlock();
                }
                return;
            }
            log.trace("[{}] Received attributes update notification to device", (Object)sessionId);
            TbCoapObservationState attrs = this.state.getAttrs();
            if (attrs != null) {
                try {
                    boolean conRequest = AbstractSyncSessionCallback.isConRequest(this.state.getAttrs());
                    int requestId = DefaultCoapClientContext.this.getNextMsgId();
                    Response response = this.state.getAdaptor().convertToPublish(msg);
                    response.getOptions().setObserve(attrs.getObserveCounter().getAndIncrement());
                    response.setConfirmable(conRequest);
                    response.setMID(requestId);
                    if (conRequest) {
                        response.addMessageObserver((MessageObserver)new TbCoapMessageObserver(requestId, id -> DefaultCoapClientContext.this.awake(this.state), id -> DefaultCoapClientContext.this.asleep(this.state)));
                    }
                    DefaultCoapClientContext.this.respond(attrs.getExchange(), response, this.state.getContentFormat());
                }
                catch (AdaptorException e) {
                    log.trace("[{}] Failed to reply due to error", (Object)this.state.getDeviceId(), (Object)e);
                    this.cancelObserveRelation(attrs);
                    DefaultCoapClientContext.this.cancelAttributeSubscription(this.state);
                }
            } else {
                log.debug("[{}] Get Attrs exchange is empty", (Object)this.state.getDeviceId());
            }
        }

        public void onDeviceProfileUpdate(TransportProtos.SessionInfoProto newSessionInfo, DeviceProfile deviceProfile) {
            try {
                DefaultCoapClientContext.this.initStateAdaptor(deviceProfile, this.state);
            }
            catch (AdaptorException e) {
                log.warn("[{}] Failed to update device profile: ", (Object)deviceProfile.getId(), (Object)e);
            }
        }

        public void onDeviceUpdate(TransportProtos.SessionInfoProto sessionInfo, Device device, Optional<DeviceProfile> deviceProfileOpt) {
            if (deviceProfileOpt.isPresent()) {
                try {
                    DefaultCoapClientContext.this.initStateAdaptor(deviceProfileOpt.get(), this.state);
                }
                catch (AdaptorException e) {
                    log.warn("[{}] Failed to update device: ", (Object)device.getId(), (Object)e);
                }
            }
            this.state.onDeviceUpdate(device);
        }

        public void onDeviceDeleted(DeviceId deviceId) {
            DefaultCoapClientContext.this.cancelRpcSubscription(this.state);
            DefaultCoapClientContext.this.cancelAttributeSubscription(this.state);
        }

        public void onRemoteSessionCloseCommand(UUID sessionId, TransportProtos.SessionCloseNotificationProto sessionCloseNotification) {
            log.trace("[{}] Received the remote command to close the session: {}", (Object)sessionId, (Object)sessionCloseNotification.getMessage());
            DefaultCoapClientContext.this.cancelRpcSubscription(this.state);
            DefaultCoapClientContext.this.cancelAttributeSubscription(this.state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void onToDeviceRpcRequest(UUID sessionId, TransportProtos.ToDeviceRpcRequestMsg msg) {
            DeviceId deviceId = this.state.getDeviceId();
            log.trace("[{}][{}] Received RPC command to device: {}", new Object[]{deviceId, sessionId, msg});
            if (!DefaultCoapClientContext.this.isDownlinkAllowed(this.state)) {
                log.trace("[{}][{}] ignore downlink request cause client is sleeping.", (Object)deviceId, (Object)sessionId);
                return;
            }
            boolean sent = false;
            Object error = null;
            boolean conRequest = AbstractSyncSessionCallback.isConRequest(this.state.getRpc());
            int requestId = DefaultCoapClientContext.this.getNextMsgId();
            try {
                Response response = this.state.getAdaptor().convertToPublish(msg, this.state.getConfiguration().getRpcRequestDynamicMessageBuilder());
                response.getOptions().setObserve(this.state.getRpc().getObserveCounter().getAndIncrement());
                response.setConfirmable(conRequest);
                response.setMID(requestId);
                if (conRequest) {
                    Optional<CoapDeviceProfileTransportConfiguration> clientProfile;
                    PowerMode powerMode = this.state.getPowerMode();
                    PowerSavingConfiguration profileSettings = null;
                    if (powerMode == null && (clientProfile = DefaultCoapClientContext.this.getProfile(this.state.getProfileId())).isPresent() && (profileSettings = clientProfile.get().getClientSettings()) != null) {
                        powerMode = profileSettings.getPowerMode();
                    }
                    DefaultCoapClientContext.this.transportContext.getRpcAwaitingAck().put(requestId, msg);
                    DefaultCoapClientContext.this.transportContext.getScheduler().schedule(() -> {
                        TransportProtos.ToDeviceRpcRequestMsg rpcRequestMsg = (TransportProtos.ToDeviceRpcRequestMsg)DefaultCoapClientContext.this.transportContext.getRpcAwaitingAck().remove(requestId);
                        if (rpcRequestMsg != null) {
                            log.trace("[{}][{}][{}] Going to send to device actor RPC request TIMEOUT status update due to server timeout ...", new Object[]{deviceId, sessionId, requestId});
                            DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.TIMEOUT, TransportServiceCallback.EMPTY);
                        }
                    }, Math.min(DefaultCoapClientContext.this.getTimeout(this.state, powerMode, profileSettings), msg.getExpirationTime() - System.currentTimeMillis()), TimeUnit.MILLISECONDS);
                    response.addMessageObserver((MessageObserver)new TbCoapMessageObserver(requestId, id -> {
                        TransportProtos.ToDeviceRpcRequestMsg rpcRequestMsg = (TransportProtos.ToDeviceRpcRequestMsg)DefaultCoapClientContext.this.transportContext.getRpcAwaitingAck().remove(id);
                        if (rpcRequestMsg != null) {
                            log.trace("[{}][{}][{}] Going to send to device actor RPC request DELIVERED status update ...", new Object[]{deviceId, sessionId, requestId});
                            DefaultCoapClientContext.this.transportService.process(this.state.getSession(), rpcRequestMsg, RpcStatus.DELIVERED, true, TransportServiceCallback.EMPTY);
                        }
                    }, id -> {
                        TransportProtos.ToDeviceRpcRequestMsg rpcRequestMsg = (TransportProtos.ToDeviceRpcRequestMsg)DefaultCoapClientContext.this.transportContext.getRpcAwaitingAck().remove(id);
                        if (rpcRequestMsg != null) {
                            log.trace("[{}][{}][{}] Going to send to device actor RPC request TIMEOUT status update ...", new Object[]{deviceId, sessionId, requestId});
                            DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.TIMEOUT, TransportServiceCallback.EMPTY);
                        }
                    }));
                }
                if (conRequest) {
                    response.addMessageObserver((MessageObserver)new TbCoapMessageObserver(requestId, id -> DefaultCoapClientContext.this.awake(this.state), id -> DefaultCoapClientContext.this.asleep(this.state)));
                }
                DefaultCoapClientContext.this.respond(this.state.getRpc().getExchange(), response, this.state.getContentFormat());
                sent = true;
            }
            catch (AdaptorException e) {
                log.trace("Failed to reply due to error", (Throwable)e);
                this.cancelObserveRelation(this.state.getRpc());
                DefaultCoapClientContext.this.cancelRpcSubscription(this.state);
                error = "Failed to convert device RPC command to CoAP msg";
                if (StringUtils.isNotEmpty((String)error)) {
                    DefaultCoapClientContext.this.transportService.process(this.state.getSession(), TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(msg.getRequestId()).setError((String)error).build(), TransportServiceCallback.EMPTY);
                } else if (sent) {
                    if (!conRequest) {
                        log.trace("[{}][{}][{}] Going to send to device actor non-confirmable RPC request DELIVERED status update ...", new Object[]{deviceId, sessionId, requestId});
                        DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.DELIVERED, TransportServiceCallback.EMPTY);
                    } else if (msg.getPersisted()) {
                        log.trace("[{}][{}][{}] Going to send to device actor RPC request SENT status update ...", new Object[]{deviceId, sessionId, requestId});
                        DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.SENT, TransportServiceCallback.EMPTY);
                    }
                }
            }
            catch (Exception e2) {
                error = "Internal error: " + e2.getMessage();
                {
                    catch (Throwable throwable) {
                        if (StringUtils.isNotEmpty(error)) {
                            DefaultCoapClientContext.this.transportService.process(this.state.getSession(), TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(msg.getRequestId()).setError((String)error).build(), TransportServiceCallback.EMPTY);
                        } else if (sent) {
                            if (!conRequest) {
                                log.trace("[{}][{}][{}] Going to send to device actor non-confirmable RPC request DELIVERED status update ...", new Object[]{deviceId, sessionId, requestId});
                                DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.DELIVERED, TransportServiceCallback.EMPTY);
                            } else if (msg.getPersisted()) {
                                log.trace("[{}][{}][{}] Going to send to device actor RPC request SENT status update ...", new Object[]{deviceId, sessionId, requestId});
                                DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.SENT, TransportServiceCallback.EMPTY);
                            }
                        }
                        throw throwable;
                    }
                }
                if (StringUtils.isNotEmpty((String)error)) {
                    DefaultCoapClientContext.this.transportService.process(this.state.getSession(), TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(msg.getRequestId()).setError((String)error).build(), TransportServiceCallback.EMPTY);
                } else if (sent) {
                    if (!conRequest) {
                        log.trace("[{}][{}][{}] Going to send to device actor non-confirmable RPC request DELIVERED status update ...", new Object[]{deviceId, sessionId, requestId});
                        DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.DELIVERED, TransportServiceCallback.EMPTY);
                    } else if (msg.getPersisted()) {
                        log.trace("[{}][{}][{}] Going to send to device actor RPC request SENT status update ...", new Object[]{deviceId, sessionId, requestId});
                        DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.SENT, TransportServiceCallback.EMPTY);
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)error)) {
                DefaultCoapClientContext.this.transportService.process(this.state.getSession(), TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(msg.getRequestId()).setError((String)error).build(), TransportServiceCallback.EMPTY);
            } else if (sent) {
                if (!conRequest) {
                    log.trace("[{}][{}][{}] Going to send to device actor non-confirmable RPC request DELIVERED status update ...", new Object[]{deviceId, sessionId, requestId});
                    DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.DELIVERED, TransportServiceCallback.EMPTY);
                } else if (msg.getPersisted()) {
                    log.trace("[{}][{}][{}] Going to send to device actor RPC request SENT status update ...", new Object[]{deviceId, sessionId, requestId});
                    DefaultCoapClientContext.this.transportService.process(this.state.getSession(), msg, RpcStatus.SENT, TransportServiceCallback.EMPTY);
                }
            }
        }

        public void onToServerRpcResponse(TransportProtos.ToServerRpcResponseMsg msg) {
            log.trace("[{}] Received server rpc response in the wrong session.", (Object)this.state.getSession());
        }

        public void onUplinkNotification(TransportProtos.UplinkNotificationMsg notificationMsg) {
            DefaultCoapClientContext.this.awake(this.state, false, notificationMsg.getUplinkTs());
        }

        private void cancelObserveRelation(TbCoapObservationState attrs) {
            if (attrs.getObserveRelation() != null) {
                attrs.getObserveRelation().cancel();
            }
        }

        @ConstructorProperties(value={"state"})
        @Generated
        public CoapSessionListener(TbCoapClientState state) {
            this.state = state;
        }
    }
}

