/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.callback;

import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.thingsboard.server.common.transport.TransportServiceCallback;

public class CoapResponseCallback
implements TransportServiceCallback<Void> {
    protected final CoapExchange exchange;
    protected final Response onSuccessResponse;
    protected final Response onFailureResponse;

    public CoapResponseCallback(CoapExchange exchange, Response onSuccessResponse, Response onFailureResponse) {
        this.exchange = exchange;
        this.onSuccessResponse = onSuccessResponse;
        this.onFailureResponse = onFailureResponse;
    }

    public void onSuccess(Void msg) {
        this.onSuccessResponse.setConfirmable(this.isConRequest());
        this.exchange.respond(this.onSuccessResponse);
    }

    public void onError(Throwable e) {
        this.exchange.respond(this.onFailureResponse);
    }

    protected boolean isConRequest() {
        return this.exchange.advanced().getRequest().isConfirmable();
    }
}

