/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.callback;

import java.util.function.BiConsumer;
import lombok.Generated;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;

public class CoapDeviceAuthCallback
implements TransportServiceCallback<ValidateDeviceCredentialsResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoapDeviceAuthCallback.class);
    private final CoapExchange exchange;
    private final BiConsumer<ValidateDeviceCredentialsResponse, DeviceProfile> onSuccess;

    public CoapDeviceAuthCallback(CoapExchange exchange, BiConsumer<ValidateDeviceCredentialsResponse, DeviceProfile> onSuccess) {
        this.exchange = exchange;
        this.onSuccess = onSuccess;
    }

    public void onSuccess(ValidateDeviceCredentialsResponse msg) {
        DeviceProfile deviceProfile = msg.getDeviceProfile();
        if (msg.hasDeviceInfo() && deviceProfile != null) {
            this.onSuccess.accept(msg, deviceProfile);
        } else {
            this.exchange.respond(CoAP.ResponseCode.UNAUTHORIZED);
        }
    }

    public void onError(Throwable e) {
        log.warn("Failed to process request", e);
        this.exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
    }
}

