/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.common.data.security.DeviceTokenCredentials;
import org.thingsboard.server.common.transport.TransportContext;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.SessionInfoCreator;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.AbstractCoapTransportResource;
import org.thingsboard.server.transport.coap.CoapTransportContext;
import org.thingsboard.server.transport.coap.callback.CoapDeviceAuthCallback;

public class OtaPackageTransportResource
extends AbstractCoapTransportResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OtaPackageTransportResource.class);
    private static final int ACCESS_TOKEN_POSITION = 2;
    private final OtaPackageType otaPackageType;

    public OtaPackageTransportResource(CoapTransportContext ctx, OtaPackageType otaPackageType) {
        super(ctx, otaPackageType.getKeyPrefix());
        this.otaPackageType = otaPackageType;
        this.setObservable(true);
    }

    @Override
    protected void processHandleGet(CoapExchange exchange) {
        log.trace("Processing {}", (Object)exchange.advanced().getRequest());
        exchange.accept();
        Exchange advanced = exchange.advanced();
        Request request = advanced.getRequest();
        this.processAccessTokenRequest(exchange, request);
    }

    @Override
    protected void processHandlePost(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    private void processAccessTokenRequest(CoapExchange exchange, Request request) {
        Optional<DeviceTokenCredentials> credentials = this.decodeCredentials(request);
        if (credentials.isEmpty()) {
            exchange.respond(CoAP.ResponseCode.UNAUTHORIZED);
            return;
        }
        this.transportService.process(DeviceTransportType.COAP, TransportProtos.ValidateDeviceTokenRequestMsg.newBuilder().setToken(credentials.get().getCredentialsId()).build(), (TransportServiceCallback)new CoapDeviceAuthCallback(exchange, (msg, deviceProfile) -> this.getOtaPackageCallback((ValidateDeviceCredentialsResponse)msg, exchange, this.otaPackageType)));
    }

    private void getOtaPackageCallback(ValidateDeviceCredentialsResponse msg, CoapExchange exchange, OtaPackageType firmwareType) {
        TenantId tenantId = msg.getDeviceInfo().getTenantId();
        DeviceId deviceId = msg.getDeviceInfo().getDeviceId();
        TransportProtos.GetOtaPackageRequestMsg requestMsg = TransportProtos.GetOtaPackageRequestMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setDeviceIdMSB(deviceId.getId().getMostSignificantBits()).setDeviceIdLSB(deviceId.getId().getLeastSignificantBits()).setType(firmwareType.name()).build();
        this.transportContext.getTransportService().process(SessionInfoCreator.create((ValidateDeviceCredentialsResponse)msg, (TransportContext)this.transportContext, (UUID)UUID.randomUUID()), requestMsg, (TransportServiceCallback)new OtaPackageCallback(exchange));
    }

    private Optional<DeviceTokenCredentials> decodeCredentials(Request request) {
        List uriPath = request.getOptions().getUriPath();
        if (uriPath.size() == 2) {
            return Optional.of(new DeviceTokenCredentials((String)uriPath.get(1)));
        }
        return Optional.empty();
    }

    public Resource getChild(String name) {
        return this;
    }

    private void respondOtaPackage(CoapExchange exchange, byte[] data) {
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        if (data != null && data.length > 0) {
            response.setPayload(data);
            if (exchange.getRequestOptions().getBlock2() != null) {
                int chunkSize = exchange.getRequestOptions().getBlock2().getSzx();
                int blockNum = exchange.getRequestOptions().getBlock2().getNum();
                boolean lastFlag = data.length <= chunkSize;
                response.getOptions().setBlock2(chunkSize, lastFlag, blockNum);
            }
            this.transportContext.getExecutor().submit(() -> exchange.respond(response));
        }
    }

    private class OtaPackageCallback
    implements TransportServiceCallback<TransportProtos.GetOtaPackageResponseMsg> {
        private final CoapExchange exchange;

        OtaPackageCallback(CoapExchange exchange) {
            this.exchange = exchange;
        }

        public void onSuccess(TransportProtos.GetOtaPackageResponseMsg msg) {
            String title = this.exchange.getQueryParameter("title");
            String version = this.exchange.getQueryParameter("version");
            if (msg.getResponseStatus().equals((Object)TransportProtos.ResponseStatus.SUCCESS)) {
                String firmwareId = new UUID(msg.getOtaPackageIdMSB(), msg.getOtaPackageIdLSB()).toString();
                if ((title == null || msg.getTitle().equals(title)) && (version == null || msg.getVersion().equals(version))) {
                    String strChunkSize = this.exchange.getQueryParameter("size");
                    String strChunk = this.exchange.getQueryParameter("chunk");
                    int chunkSize = StringUtils.isEmpty((String)strChunkSize) ? 0 : Integer.parseInt(strChunkSize);
                    int chunk = StringUtils.isEmpty((String)strChunk) ? 0 : Integer.parseInt(strChunk);
                    OtaPackageTransportResource.this.respondOtaPackage(this.exchange, OtaPackageTransportResource.this.transportContext.getOtaPackageDataCache().get(firmwareId, chunkSize, chunk));
                } else {
                    this.exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
                }
            } else {
                this.exchange.respond(CoAP.ResponseCode.NOT_FOUND);
            }
        }

        public void onError(Throwable e) {
            log.warn("Failed to process request", e);
            this.exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
        }
    }
}

