/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.net.UnknownHostException;
import lombok.Generated;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.server.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.coapserver.CoapServerService;
import org.thingsboard.server.coapserver.TbCoapTransportComponent;
import org.thingsboard.server.common.data.TbTransportService;
import org.thingsboard.server.common.data.ota.OtaPackageType;
import org.thingsboard.server.transport.coap.CoapTransportContext;
import org.thingsboard.server.transport.coap.CoapTransportResource;
import org.thingsboard.server.transport.coap.OtaPackageTransportResource;
import org.thingsboard.server.transport.coap.efento.CoapEfentoTransportResource;

@Service(value="CoapTransportService")
@TbCoapTransportComponent
public class CoapTransportService
implements TbTransportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoapTransportService.class);
    private static final String V1 = "v1";
    private static final String API = "api";
    private static final String EFENTO = "efento";
    public static final String MEASUREMENTS = "m";
    public static final String DEVICE_INFO = "i";
    public static final String CONFIGURATION = "c";
    public static final String CURRENT_TIMESTAMP = "t";
    @Autowired
    private CoapServerService coapServerService;
    @Autowired
    private CoapTransportContext coapTransportContext;
    private CoapServer coapServer;

    @PostConstruct
    public void init() throws UnknownHostException {
        log.info("Starting CoAP transport...");
        this.coapServer = this.coapServerService.getCoapServer();
        CoapResource api = new CoapResource(API);
        api.add((CoapResource)new CoapTransportResource(this.coapTransportContext, this.coapServerService, V1));
        CoapEfentoTransportResource efento = new CoapEfentoTransportResource(this.coapTransportContext, EFENTO);
        efento.add(new CoapResource(MEASUREMENTS));
        efento.add(new CoapResource(DEVICE_INFO));
        efento.add(new CoapResource(CONFIGURATION));
        efento.add(new CoapResource(CURRENT_TIMESTAMP));
        this.coapServer.add(new Resource[]{api});
        this.coapServer.add(new Resource[]{efento});
        this.coapServer.add(new Resource[]{new OtaPackageTransportResource(this.coapTransportContext, OtaPackageType.FIRMWARE)});
        this.coapServer.add(new Resource[]{new OtaPackageTransportResource(this.coapTransportContext, OtaPackageType.SOFTWARE)});
        log.info("CoAP transport started!");
    }

    @PreDestroy
    public void shutdown() {
        log.info("CoAP transport stopped!");
    }

    public String getName() {
        return "COAP";
    }
}

