/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap;

import com.google.gson.JsonParseException;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.core.server.resources.ResourceObserver;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.coapserver.CoapServerService;
import org.thingsboard.server.coapserver.TbCoapDtlsSessionInfo;
import org.thingsboard.server.coapserver.TbCoapDtlsSessionKey;
import org.thingsboard.server.common.adaptor.AdaptorException;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.TransportPayloadType;
import org.thingsboard.server.common.data.security.DeviceTokenCredentials;
import org.thingsboard.server.common.msg.session.FeatureType;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.AbstractCoapTransportResource;
import org.thingsboard.server.transport.coap.CoapSessionMsgType;
import org.thingsboard.server.transport.coap.CoapTransportContext;
import org.thingsboard.server.transport.coap.callback.CoapDeviceAuthCallback;
import org.thingsboard.server.transport.coap.callback.CoapNoOpCallback;
import org.thingsboard.server.transport.coap.callback.CoapResponseCodeCallback;
import org.thingsboard.server.transport.coap.callback.GetAttributesSyncSessionCallback;
import org.thingsboard.server.transport.coap.callback.ToServerRpcSyncSessionCallback;
import org.thingsboard.server.transport.coap.client.CoapClientContext;
import org.thingsboard.server.transport.coap.client.TbCoapClientState;

public class CoapTransportResource
extends AbstractCoapTransportResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoapTransportResource.class);
    private static final int ACCESS_TOKEN_POSITION = 3;
    private static final int FEATURE_TYPE_POSITION = 4;
    private static final int REQUEST_ID_POSITION = 5;
    private static final int FEATURE_TYPE_POSITION_CERTIFICATE_REQUEST = 3;
    private static final int REQUEST_ID_POSITION_CERTIFICATE_REQUEST = 4;
    private final ConcurrentMap<TbCoapDtlsSessionKey, TbCoapDtlsSessionInfo> dtlsSessionsMap;
    private final long timeout;
    private final long piggybackTimeout;
    private final CoapClientContext clients;

    public CoapTransportResource(CoapTransportContext ctx, CoapServerService coapServerService, String name) {
        super(ctx, name);
        this.setObservable(true);
        this.addObserver(new CoapResourceObserver());
        this.dtlsSessionsMap = coapServerService.getDtlsSessionsMap();
        this.timeout = ctx.getTimeout();
        this.piggybackTimeout = ctx.getPiggybackTimeout();
        this.clients = ctx.getClientContext();
        long sessionReportTimeout = ctx.getSessionReportTimeout();
        ctx.getScheduler().scheduleAtFixedRate(this.clients::reportActivity, (long)new Random().nextInt((int)sessionReportTimeout), sessionReportTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void processHandleGet(CoapExchange exchange) {
        Optional<FeatureType> featureType = this.getFeatureType(exchange.advanced().getRequest());
        if (featureType.isEmpty()) {
            log.trace("Missing feature type parameter");
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
        } else if (featureType.get() == FeatureType.TELEMETRY) {
            log.trace("Can't fetch/subscribe to timeseries updates");
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
        } else if (exchange.getRequestOptions().hasObserve()) {
            this.processExchangeGetRequest(exchange, featureType.get());
        } else if (featureType.get() == FeatureType.ATTRIBUTES) {
            this.processRequest(exchange, CoapSessionMsgType.GET_ATTRIBUTES_REQUEST);
        } else {
            log.trace("Invalid feature type parameter");
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
        }
    }

    private void processExchangeGetRequest(CoapExchange exchange, FeatureType featureType) {
        boolean unsubscribe;
        boolean bl = unsubscribe = exchange.getRequestOptions().getObserve() == 1;
        CoapSessionMsgType coapSessionMsgType = featureType == FeatureType.RPC ? (unsubscribe ? CoapSessionMsgType.UNSUBSCRIBE_RPC_COMMANDS_REQUEST : CoapSessionMsgType.SUBSCRIBE_RPC_COMMANDS_REQUEST) : (unsubscribe ? CoapSessionMsgType.UNSUBSCRIBE_ATTRIBUTES_REQUEST : CoapSessionMsgType.SUBSCRIBE_ATTRIBUTES_REQUEST);
        this.processRequest(exchange, coapSessionMsgType);
    }

    @Override
    protected void processHandlePost(CoapExchange exchange) {
        Optional<FeatureType> featureType = this.getFeatureType(exchange.advanced().getRequest());
        if (featureType.isEmpty()) {
            log.trace("Missing feature type parameter");
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
        } else {
            switch (featureType.get()) {
                case ATTRIBUTES: {
                    this.processRequest(exchange, CoapSessionMsgType.POST_ATTRIBUTES_REQUEST);
                    break;
                }
                case TELEMETRY: {
                    this.processRequest(exchange, CoapSessionMsgType.POST_TELEMETRY_REQUEST);
                    break;
                }
                case RPC: {
                    Optional<Integer> requestId = CoapTransportResource.getRequestId(exchange.advanced().getRequest());
                    if (requestId.isPresent()) {
                        this.processRequest(exchange, CoapSessionMsgType.TO_DEVICE_RPC_RESPONSE);
                        break;
                    }
                    this.processRequest(exchange, CoapSessionMsgType.TO_SERVER_RPC_REQUEST);
                    break;
                }
                case CLAIM: {
                    this.processRequest(exchange, CoapSessionMsgType.CLAIM_REQUEST);
                    break;
                }
                case PROVISION: {
                    this.processProvision(exchange);
                }
            }
        }
    }

    private void processProvision(CoapExchange exchange) {
        this.deferAccept(exchange);
        try {
            TransportPayloadType payloadType;
            TransportProtos.ProvisionDeviceRequestMsg provisionRequestMsg;
            UUID sessionId = UUID.randomUUID();
            log.trace("[{}] Processing provision publish msg [{}]!", (Object)sessionId, (Object)exchange.advanced().getRequest());
            try {
                provisionRequestMsg = this.transportContext.getJsonCoapAdaptor().convertToProvisionRequestMsg(sessionId, exchange.advanced().getRequest());
                payloadType = TransportPayloadType.JSON;
            }
            catch (Exception e) {
                if (e instanceof JsonParseException || e.getCause() != null && e.getCause() instanceof JsonParseException) {
                    provisionRequestMsg = this.transportContext.getProtoCoapAdaptor().convertToProvisionRequestMsg(sessionId, exchange.advanced().getRequest());
                    payloadType = TransportPayloadType.PROTOBUF;
                }
                throw new AdaptorException(e);
            }
            this.transportService.process(provisionRequestMsg, (TransportServiceCallback)new DeviceProvisionCallback(exchange, payloadType));
        }
        catch (AdaptorException e) {
            log.trace("Failed to decode message: ", (Throwable)e);
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
        }
    }

    private void processRequest(CoapExchange exchange, CoapSessionMsgType type) {
        log.trace("Processing {}", (Object)exchange.advanced().getRequest());
        this.deferAccept(exchange);
        Exchange advanced = exchange.advanced();
        Request request = advanced.getRequest();
        Bytes dtlsSessionId = (Bytes)request.getSourceContext().get(DtlsEndpointContext.KEY_SESSION_ID);
        if (this.dtlsSessionsMap != null && dtlsSessionId != null && !dtlsSessionId.isEmpty()) {
            TbCoapDtlsSessionInfo tbCoapDtlsSessionInfo = this.getCoapDtlsSessionInfo(request.getSourceContext());
            if (tbCoapDtlsSessionInfo != null) {
                this.processRequest(exchange, type, request, tbCoapDtlsSessionInfo.getMsg(), tbCoapDtlsSessionInfo.getDeviceProfile());
            } else {
                this.processAccessTokenRequest(exchange, type, request);
            }
        } else {
            this.processAccessTokenRequest(exchange, type, request);
        }
    }

    private void processAccessTokenRequest(CoapExchange exchange, CoapSessionMsgType type, Request request) {
        Optional<DeviceTokenCredentials> credentials = this.decodeCredentials(request);
        if (credentials.isEmpty()) {
            exchange.respond(CoAP.ResponseCode.UNAUTHORIZED);
            return;
        }
        this.transportService.process(DeviceTransportType.COAP, TransportProtos.ValidateDeviceTokenRequestMsg.newBuilder().setToken(credentials.get().getCredentialsId()).build(), (TransportServiceCallback)new CoapDeviceAuthCallback(exchange, (deviceCredentials, deviceProfile) -> this.processRequest(exchange, type, request, (ValidateDeviceCredentialsResponse)deviceCredentials, (DeviceProfile)deviceProfile)));
    }

    private void processRequest(CoapExchange exchange, CoapSessionMsgType type, Request request, ValidateDeviceCredentialsResponse deviceCredentials, DeviceProfile deviceProfile) {
        TbCoapClientState clientState = null;
        try {
            clientState = this.clients.getOrCreateClient(type, deviceCredentials, deviceProfile);
            this.clients.awake(clientState);
            switch (type) {
                case POST_ATTRIBUTES_REQUEST: {
                    this.handlePostAttributesRequest(clientState, exchange, request);
                    break;
                }
                case POST_TELEMETRY_REQUEST: {
                    this.handlePostTelemetryRequest(clientState, exchange, request);
                    break;
                }
                case CLAIM_REQUEST: {
                    this.handleClaimRequest(clientState, exchange, request);
                    break;
                }
                case SUBSCRIBE_ATTRIBUTES_REQUEST: {
                    this.handleAttributeSubscribeRequest(clientState, exchange, request);
                    break;
                }
                case UNSUBSCRIBE_ATTRIBUTES_REQUEST: {
                    this.handleAttributeUnsubscribeRequest(clientState, exchange, request);
                    break;
                }
                case SUBSCRIBE_RPC_COMMANDS_REQUEST: {
                    this.handleRpcSubscribeRequest(clientState, exchange, request);
                    break;
                }
                case UNSUBSCRIBE_RPC_COMMANDS_REQUEST: {
                    this.handleRpcUnsubscribeRequest(clientState, exchange, request);
                    break;
                }
                case TO_DEVICE_RPC_RESPONSE: {
                    this.handleToDeviceRpcResponse(clientState, exchange, request);
                    break;
                }
                case TO_SERVER_RPC_REQUEST: {
                    this.handleToServerRpcRequest(clientState, exchange, request);
                    break;
                }
                case GET_ATTRIBUTES_REQUEST: {
                    this.handleGetAttributesRequest(clientState, exchange, request);
                }
            }
        }
        catch (AdaptorException e) {
            if (clientState != null) {
                log.trace("[{}] Failed to decode message: ", (Object)clientState.getDeviceId(), (Object)e);
            }
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
        }
    }

    private void handlePostAttributesRequest(TbCoapClientState clientState, CoapExchange exchange, Request request) throws AdaptorException {
        TransportProtos.SessionInfoProto sessionInfo = this.clients.getNewSyncSession(clientState);
        UUID sessionId = this.toSessionId(sessionInfo);
        this.transportService.process(sessionInfo, clientState.getAdaptor().convertToPostAttributes(sessionId, request, clientState.getConfiguration().getAttributesMsgDescriptor()), (TransportServiceCallback)new CoapResponseCodeCallback(exchange, CoAP.ResponseCode.CREATED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
    }

    private void handlePostTelemetryRequest(TbCoapClientState clientState, CoapExchange exchange, Request request) throws AdaptorException {
        TransportProtos.SessionInfoProto sessionInfo = this.clients.getNewSyncSession(clientState);
        UUID sessionId = this.toSessionId(sessionInfo);
        this.transportService.process(sessionInfo, clientState.getAdaptor().convertToPostTelemetry(sessionId, request, clientState.getConfiguration().getTelemetryMsgDescriptor()), (TransportServiceCallback)new CoapResponseCodeCallback(exchange, CoAP.ResponseCode.CREATED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
    }

    private void handleClaimRequest(TbCoapClientState clientState, CoapExchange exchange, Request request) throws AdaptorException {
        TransportProtos.SessionInfoProto sessionInfo = this.clients.getNewSyncSession(clientState);
        UUID sessionId = this.toSessionId(sessionInfo);
        this.transportService.process(sessionInfo, clientState.getAdaptor().convertToClaimDevice(sessionId, request, sessionInfo), (TransportServiceCallback)new CoapResponseCodeCallback(exchange, CoAP.ResponseCode.CREATED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
    }

    private void handleAttributeSubscribeRequest(TbCoapClientState clientState, CoapExchange exchange, Request request) {
        String attrSubToken = this.getTokenFromRequest(request);
        if (!this.clients.registerAttributeObservation(clientState, attrSubToken, exchange)) {
            log.warn("[{}] Received duplicate attribute subscribe request for token: {}", (Object)clientState.getDeviceId(), (Object)attrSubToken);
        }
    }

    private void handleAttributeUnsubscribeRequest(TbCoapClientState clientState, CoapExchange exchange, Request request) {
        this.clients.deregisterAttributeObservation(clientState, this.getTokenFromRequest(request), exchange);
    }

    private void handleRpcUnsubscribeRequest(TbCoapClientState clientState, CoapExchange exchange, Request request) {
        this.clients.deregisterRpcObservation(clientState, this.getTokenFromRequest(request), exchange);
    }

    private void handleToDeviceRpcResponse(TbCoapClientState clientState, CoapExchange exchange, Request request) throws AdaptorException {
        TransportProtos.SessionInfoProto session = clientState.getSession();
        if (session == null) {
            session = this.clients.getNewSyncSession(clientState);
        }
        UUID sessionId = this.toSessionId(session);
        this.transportService.process(session, clientState.getAdaptor().convertToDeviceRpcResponse(sessionId, request, clientState.getConfiguration().getRpcResponseMsgDescriptor()), (TransportServiceCallback)new CoapResponseCodeCallback(exchange, CoAP.ResponseCode.CREATED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
    }

    private void handleRpcSubscribeRequest(TbCoapClientState clientState, CoapExchange exchange, Request request) {
        String rpcSubToken = this.getTokenFromRequest(request);
        if (!this.clients.registerRpcObservation(clientState, rpcSubToken, exchange)) {
            log.warn("[{}] Received duplicate rpc subscribe request.", (Object)rpcSubToken);
        }
    }

    private void handleGetAttributesRequest(TbCoapClientState clientState, CoapExchange exchange, Request request) throws AdaptorException {
        TransportProtos.SessionInfoProto sessionInfo = this.clients.getNewSyncSession(clientState);
        UUID sessionId = this.toSessionId(sessionInfo);
        this.transportService.registerSyncSession(sessionInfo, (SessionMsgListener)new GetAttributesSyncSessionCallback(clientState, exchange, request), this.timeout);
        this.transportService.process(sessionInfo, clientState.getAdaptor().convertToGetAttributes(sessionId, request), (TransportServiceCallback)new CoapNoOpCallback(exchange));
    }

    private void handleToServerRpcRequest(TbCoapClientState clientState, CoapExchange exchange, Request request) throws AdaptorException {
        TransportProtos.SessionInfoProto sessionInfo = this.clients.getNewSyncSession(clientState);
        UUID sessionId = this.toSessionId(sessionInfo);
        this.transportService.registerSyncSession(sessionInfo, (SessionMsgListener)new ToServerRpcSyncSessionCallback(clientState, exchange, request), this.timeout);
        this.transportService.process(sessionInfo, clientState.getAdaptor().convertToServerRpcRequest(sessionId, request), (TransportServiceCallback)new CoapNoOpCallback(exchange));
    }

    private void deferAccept(CoapExchange exchange) {
        if (this.piggybackTimeout > 0L) {
            this.transportContext.getScheduler().schedule(() -> ((CoapExchange)exchange).accept(), this.piggybackTimeout, TimeUnit.MILLISECONDS);
        } else {
            exchange.accept();
        }
    }

    private UUID toSessionId(TransportProtos.SessionInfoProto sessionInfoProto) {
        return new UUID(sessionInfoProto.getSessionIdMSB(), sessionInfoProto.getSessionIdLSB());
    }

    private String getTokenFromRequest(Request request) {
        return (request.getSourceContext() != null ? request.getSourceContext().getPeerAddress().getAddress().getHostAddress() : "null") + ":" + (request.getSourceContext() != null ? request.getSourceContext().getPeerAddress().getPort() : -1) + ":" + request.getTokenString();
    }

    private Optional<DeviceTokenCredentials> decodeCredentials(Request request) {
        List uriPath = request.getOptions().getUriPath();
        if (uriPath.size() > 3) {
            return Optional.of(new DeviceTokenCredentials((String)uriPath.get(2)));
        }
        return Optional.empty();
    }

    protected Optional<FeatureType> getFeatureType(Request request) {
        List uriPath = request.getOptions().getUriPath();
        try {
            int size = uriPath.size();
            if (size >= 4) {
                if (size == 4 && StringUtils.isNumeric((String)((String)uriPath.get(size - 1)))) {
                    return Optional.of(FeatureType.valueOf((String)((String)uriPath.get(2)).toUpperCase()));
                }
                return Optional.of(FeatureType.valueOf((String)((String)uriPath.get(3)).toUpperCase()));
            }
            if (size == 3) {
                if (uriPath.contains("provision")) {
                    return Optional.of(FeatureType.valueOf((String)"provision".toUpperCase()));
                }
                return Optional.of(FeatureType.valueOf((String)((String)uriPath.get(2)).toUpperCase()));
            }
        }
        catch (RuntimeException e) {
            log.warn("Failed to decode feature type: {}", (Object)uriPath);
        }
        return Optional.empty();
    }

    public static Optional<Integer> getRequestId(Request request) {
        List uriPath = request.getOptions().getUriPath();
        try {
            if (uriPath.size() >= 5) {
                return Optional.of(Integer.valueOf((String)uriPath.get(4)));
            }
            return Optional.of(Integer.valueOf((String)uriPath.get(3)));
        }
        catch (RuntimeException e) {
            log.warn("Failed to decode feature type: {}", (Object)uriPath);
            return Optional.empty();
        }
    }

    public Resource getChild(String name) {
        return this;
    }

    private TbCoapDtlsSessionInfo getCoapDtlsSessionInfo(EndpointContext endpointContext) {
        InetSocketAddress peerAddress = endpointContext.getPeerAddress();
        String certPemStr = this.getCertPem(endpointContext);
        TbCoapDtlsSessionKey tbCoapDtlsSessionKey = StringUtils.isNotBlank((String)certPemStr) ? new TbCoapDtlsSessionKey(peerAddress, certPemStr) : null;
        TbCoapDtlsSessionInfo tbCoapDtlsSessionInfo = tbCoapDtlsSessionKey != null ? this.dtlsSessionsMap.computeIfPresent(tbCoapDtlsSessionKey, (dtlsSessionIdStr, dtlsSessionInfo) -> {
            dtlsSessionInfo.setLastActivityTime(System.currentTimeMillis());
            return dtlsSessionInfo;
        }) : null;
        return tbCoapDtlsSessionInfo;
    }

    private String getCertPem(EndpointContext endpointContext) {
        try {
            X509CertPath certPath = (X509CertPath)endpointContext.getPeerIdentity();
            X509Certificate x509Certificate = (X509Certificate)certPath.getPath().getCertificates().get(0);
            return Base64.getEncoder().encodeToString(x509Certificate.getEncoded());
        }
        catch (Exception e) {
            log.error("Failed to get cert PEM: [{}]", (Object)endpointContext.getPeerAddress(), (Object)e);
            return null;
        }
    }

    public class CoapResourceObserver
    implements ResourceObserver {
        public void changedName(String old) {
        }

        public void changedPath(String old) {
        }

        public void addedChild(Resource child) {
        }

        public void removedChild(Resource child) {
        }

        public void addedObserveRelation(ObserveRelation relation) {
            Request request = relation.getExchange().getRequest();
            String token = CoapTransportResource.this.getTokenFromRequest(request);
            CoapTransportResource.this.clients.registerObserveRelation(token, relation);
            log.trace("Added Observe relation for token: {}", (Object)token);
        }

        public void removedObserveRelation(ObserveRelation relation) {
            Request request = relation.getExchange().getRequest();
            String token = CoapTransportResource.this.getTokenFromRequest(request);
            CoapTransportResource.this.clients.deregisterObserveRelation(token);
            log.trace("Relation removed for token: {}", (Object)token);
        }
    }

    private static class DeviceProvisionCallback
    implements TransportServiceCallback<TransportProtos.ProvisionDeviceResponseMsg> {
        private final CoapExchange exchange;
        private final TransportPayloadType payloadType;

        DeviceProvisionCallback(CoapExchange exchange, TransportPayloadType payloadType) {
            this.exchange = exchange;
            this.payloadType = payloadType;
        }

        public void onSuccess(TransportProtos.ProvisionDeviceResponseMsg msg) {
            CoAP.ResponseCode responseCode = CoAP.ResponseCode.CREATED;
            if (!msg.getStatus().equals((Object)TransportProtos.ResponseStatus.SUCCESS)) {
                responseCode = CoAP.ResponseCode.BAD_REQUEST;
            }
            if (this.payloadType.equals((Object)TransportPayloadType.JSON)) {
                this.exchange.respond(responseCode, JsonConverter.toJson((TransportProtos.ProvisionDeviceResponseMsg)msg).toString());
            } else {
                this.exchange.respond(responseCode, msg.toByteArray());
            }
        }

        public void onError(Throwable e) {
            log.warn("Failed to process request", e);
            this.exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
        }
    }
}

