/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.server.coapserver.TbCoapTransportComponent;
import org.thingsboard.server.common.transport.TransportContext;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.adaptors.JsonCoapAdaptor;
import org.thingsboard.server.transport.coap.adaptors.ProtoCoapAdaptor;
import org.thingsboard.server.transport.coap.client.CoapClientContext;
import org.thingsboard.server.transport.coap.efento.adaptor.EfentoCoapAdaptor;

@TbCoapTransportComponent
@Component
public class CoapTransportContext
extends TransportContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoapTransportContext.class);
    @Value(value="${transport.sessions.report_timeout}")
    private long sessionReportTimeout;
    @Value(value="${transport.coap.timeout}")
    private Long timeout;
    @Value(value="${transport.coap.piggyback_timeout}")
    private Long piggybackTimeout;
    @Value(value="${transport.coap.psm_activity_timer:10000}")
    private long psmActivityTimer;
    @Value(value="${transport.coap.paging_transmission_window:10000}")
    private long pagingTransmissionWindow;
    @Autowired
    private JsonCoapAdaptor jsonCoapAdaptor;
    @Autowired
    private ProtoCoapAdaptor protoCoapAdaptor;
    @Autowired
    private EfentoCoapAdaptor efentoCoapAdaptor;
    @Autowired
    private CoapClientContext clientContext;
    private final ConcurrentMap<Integer, TransportProtos.ToDeviceRpcRequestMsg> rpcAwaitingAck = new ConcurrentHashMap<Integer, TransportProtos.ToDeviceRpcRequestMsg>();

    @Generated
    public long getSessionReportTimeout() {
        return this.sessionReportTimeout;
    }

    @Generated
    public JsonCoapAdaptor getJsonCoapAdaptor() {
        return this.jsonCoapAdaptor;
    }

    @Generated
    public ProtoCoapAdaptor getProtoCoapAdaptor() {
        return this.protoCoapAdaptor;
    }

    @Generated
    public EfentoCoapAdaptor getEfentoCoapAdaptor() {
        return this.efentoCoapAdaptor;
    }

    @Generated
    public CoapClientContext getClientContext() {
        return this.clientContext;
    }

    @Generated
    public ConcurrentMap<Integer, TransportProtos.ToDeviceRpcRequestMsg> getRpcAwaitingAck() {
        return this.rpcAwaitingAck;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public Long getPiggybackTimeout() {
        return this.piggybackTimeout;
    }

    @Generated
    public long getPsmActivityTimer() {
        return this.psmActivityTimer;
    }

    @Generated
    public long getPagingTransmissionWindow() {
        return this.pagingTransmissionWindow;
    }
}

