/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap;

import lombok.Generated;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.transport.TransportService;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.CoapTransportContext;

public abstract class AbstractCoapTransportResource
extends CoapResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCoapTransportResource.class);
    protected final CoapTransportContext transportContext;
    protected final TransportService transportService;

    public AbstractCoapTransportResource(CoapTransportContext context, String name) {
        super(name);
        this.transportContext = context;
        this.transportService = context.getTransportService();
    }

    public void handleGET(CoapExchange exchange) {
        this.processHandleGet(exchange);
    }

    public void handlePOST(CoapExchange exchange) {
        this.processHandlePost(exchange);
    }

    protected abstract void processHandleGet(CoapExchange var1);

    protected abstract void processHandlePost(CoapExchange var1);

    protected void reportSubscriptionInfo(TransportProtos.SessionInfoProto sessionInfo, boolean hasAttributeSubscription, boolean hasRpcSubscription) {
        this.transportContext.getTransportService().process(sessionInfo, TransportProtos.SubscriptionInfoProto.newBuilder().setAttributeSubscription(hasAttributeSubscription).setRpcSubscription(hasRpcSubscription).setLastActivityTime(System.currentTimeMillis()).build(), TransportServiceCallback.EMPTY);
    }
}

