/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.efento.adaptor;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.adaptor.AdaptorException;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.efento.CoapEfentoTransportResource;

@Component
public class EfentoCoapAdaptor {
    private static final Logger log = LoggerFactory.getLogger(EfentoCoapAdaptor.class);
    private static final Gson gson = new Gson();

    public TransportProtos.PostTelemetryMsg convertToPostTelemetry(UUID sessionId, List<CoapEfentoTransportResource.EfentoTelemetry> telemetryList) throws AdaptorException {
        try {
            return JsonConverter.convertToTelemetryProto((JsonElement)gson.toJsonTree(telemetryList));
        }
        catch (Exception ex) {
            log.warn("[{}] Failed to convert EfentoMeasurements to PostTelemetry request!", (Object)sessionId);
            throw new AdaptorException(ex);
        }
    }

    public TransportProtos.PostAttributeMsg convertToPostAttributes(UUID sessionId, JsonElement deviceInfo) throws AdaptorException {
        try {
            return JsonConverter.convertToAttributesProto((JsonElement)deviceInfo);
        }
        catch (Exception ex) {
            log.warn("[{}] Failed to convert JsonObject to PostTelemetry request!", (Object)sessionId);
            throw new AdaptorException(ex);
        }
    }
}

