/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.efento.adaptor;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.transport.adaptor.AdaptorException;
import org.thingsboard.server.common.transport.adaptor.JsonConverter;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.efento.CoapEfentoTransportResource;

@Component
public class EfentoCoapAdaptor {
    private static final Logger log = LoggerFactory.getLogger(EfentoCoapAdaptor.class);
    private static final Gson gson = new Gson();

    public TransportProtos.PostTelemetryMsg convertToPostTelemetry(UUID sessionId, List<CoapEfentoTransportResource.EfentoMeasurements> measurements) throws AdaptorException {
        try {
            return JsonConverter.convertToTelemetryProto((JsonElement)gson.toJsonTree(measurements));
        }
        catch (Exception ex) {
            log.warn("[{}] Failed to convert EfentoMeasurements to PostTelemetry request!", (Object)sessionId);
            throw new AdaptorException(ex);
        }
    }
}

