/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.callback;

import java.beans.ConstructorProperties;
import java.util.UUID;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.transport.SessionMsgListener;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.client.TbCoapClientState;
import org.thingsboard.server.transport.coap.client.TbCoapContentFormatUtil;
import org.thingsboard.server.transport.coap.client.TbCoapObservationState;

public abstract class AbstractSyncSessionCallback
implements SessionMsgListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractSyncSessionCallback.class);
    protected final TbCoapClientState state;
    protected final CoapExchange exchange;
    protected final Request request;

    public void onGetAttributesResponse(TransportProtos.GetAttributeResponseMsg getAttributesResponse) {
        this.logUnsupportedCommandMessage(getAttributesResponse);
    }

    public void onAttributeUpdate(UUID sessionId, TransportProtos.AttributeUpdateNotificationMsg attributeUpdateNotification) {
        this.logUnsupportedCommandMessage(attributeUpdateNotification);
    }

    public void onRemoteSessionCloseCommand(UUID sessionId, TransportProtos.SessionCloseNotificationProto sessionCloseNotification) {
    }

    public void onDeviceDeleted(DeviceId deviceId) {
    }

    public void onToDeviceRpcRequest(UUID sessionId, TransportProtos.ToDeviceRpcRequestMsg toDeviceRequest) {
        this.logUnsupportedCommandMessage(toDeviceRequest);
    }

    public void onToServerRpcResponse(TransportProtos.ToServerRpcResponseMsg toServerResponse) {
        this.logUnsupportedCommandMessage(toServerResponse);
    }

    private void logUnsupportedCommandMessage(Object update) {
        log.trace("[{}] Ignore unsupported update: {}", (Object)this.state.getDeviceId(), update);
    }

    public static boolean isConRequest(TbCoapObservationState state) {
        if (state != null) {
            return state.getExchange().advanced().getRequest().isConfirmable();
        }
        return false;
    }

    protected void respond(Response response) {
        response.getOptions().setContentFormat(TbCoapContentFormatUtil.getContentFormat(this.exchange.getRequestOptions().getContentFormat(), this.state.getContentFormat()));
        this.exchange.respond(response);
    }

    @ConstructorProperties(value={"state", "exchange", "request"})
    public AbstractSyncSessionCallback(TbCoapClientState state, CoapExchange exchange, Request request) {
        this.state = state;
        this.exchange = exchange;
        this.request = request;
    }
}

