/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.adaptors;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.transport.adaptor.AdaptorException;
import org.thingsboard.server.common.transport.adaptor.JsonConverter;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.CoapTransportResource;
import org.thingsboard.server.transport.coap.adaptors.CoapAdaptorUtils;
import org.thingsboard.server.transport.coap.adaptors.CoapTransportAdaptor;

@Component
public class JsonCoapAdaptor
implements CoapTransportAdaptor {
    private static final Logger log = LoggerFactory.getLogger(JsonCoapAdaptor.class);

    @Override
    public TransportProtos.PostTelemetryMsg convertToPostTelemetry(UUID sessionId, Request inbound, Descriptors.Descriptor telemetryMsgDescriptor) throws AdaptorException {
        String payload = this.validatePayload(sessionId, inbound, false);
        try {
            return JsonConverter.convertToTelemetryProto((JsonElement)new JsonParser().parse(payload));
        }
        catch (JsonSyntaxException | IllegalStateException ex) {
            throw new AdaptorException((Exception)ex);
        }
    }

    @Override
    public TransportProtos.PostAttributeMsg convertToPostAttributes(UUID sessionId, Request inbound, Descriptors.Descriptor attributesMsgDescriptor) throws AdaptorException {
        String payload = this.validatePayload(sessionId, inbound, false);
        try {
            return JsonConverter.convertToAttributesProto((JsonElement)new JsonParser().parse(payload));
        }
        catch (JsonSyntaxException | IllegalStateException ex) {
            throw new AdaptorException((Exception)ex);
        }
    }

    @Override
    public TransportProtos.GetAttributeRequestMsg convertToGetAttributes(UUID sessionId, Request inbound) throws AdaptorException {
        return CoapAdaptorUtils.toGetAttributeRequestMsg(inbound);
    }

    @Override
    public TransportProtos.ToDeviceRpcResponseMsg convertToDeviceRpcResponse(UUID sessionId, Request inbound, Descriptors.Descriptor rpcResponseMsgDescriptor) throws AdaptorException {
        Optional<Integer> requestId = CoapTransportResource.getRequestId(inbound);
        String payload = this.validatePayload(sessionId, inbound, false);
        JsonObject response = new JsonParser().parse(payload).getAsJsonObject();
        return TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(requestId.orElseThrow(() -> new AdaptorException("Request id is missing!")).intValue()).setPayload(response.toString()).build();
    }

    @Override
    public TransportProtos.ToServerRpcRequestMsg convertToServerRpcRequest(UUID sessionId, Request inbound) throws AdaptorException {
        String payload = this.validatePayload(sessionId, inbound, false);
        return JsonConverter.convertToServerRpcRequest((JsonElement)new JsonParser().parse(payload), (int)0);
    }

    @Override
    public TransportProtos.ClaimDeviceMsg convertToClaimDevice(UUID sessionId, Request inbound, TransportProtos.SessionInfoProto sessionInfo) throws AdaptorException {
        DeviceId deviceId = new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
        String payload = this.validatePayload(sessionId, inbound, true);
        try {
            return JsonConverter.convertToClaimDeviceProto((DeviceId)deviceId, (String)payload);
        }
        catch (JsonSyntaxException | IllegalStateException ex) {
            throw new AdaptorException((Exception)ex);
        }
    }

    @Override
    public Response convertToPublish(TransportProtos.AttributeUpdateNotificationMsg msg) throws AdaptorException {
        return this.getObserveNotification((JsonElement)JsonConverter.toJson((TransportProtos.AttributeUpdateNotificationMsg)msg));
    }

    @Override
    public Response convertToPublish(TransportProtos.ToDeviceRpcRequestMsg msg, DynamicMessage.Builder rpcRequestDynamicMessageBuilder) throws AdaptorException {
        return this.getObserveNotification(JsonConverter.toJson((TransportProtos.ToDeviceRpcRequestMsg)msg, (boolean)true));
    }

    @Override
    public Response convertToPublish(TransportProtos.ToServerRpcResponseMsg msg) throws AdaptorException {
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        JsonElement result = JsonConverter.toJson((TransportProtos.ToServerRpcResponseMsg)msg);
        response.setPayload(result.toString());
        return response;
    }

    @Override
    public TransportProtos.ProvisionDeviceRequestMsg convertToProvisionRequestMsg(UUID sessionId, Request inbound) throws AdaptorException {
        String payload = this.validatePayload(sessionId, inbound, false);
        try {
            return JsonConverter.convertToProvisionRequestMsg((String)payload);
        }
        catch (JsonSyntaxException | IllegalStateException ex) {
            throw new AdaptorException((Exception)ex);
        }
    }

    @Override
    public Response convertToPublish(TransportProtos.GetAttributeResponseMsg msg) throws AdaptorException {
        if (msg.getSharedStateMsg()) {
            if (StringUtils.isEmpty((Object)msg.getError())) {
                Response response = new Response(CoAP.ResponseCode.CONTENT);
                TransportProtos.AttributeUpdateNotificationMsg notificationMsg = TransportProtos.AttributeUpdateNotificationMsg.newBuilder().addAllSharedUpdated((Iterable)msg.getSharedAttributeListList()).build();
                JsonObject result = JsonConverter.toJson((TransportProtos.AttributeUpdateNotificationMsg)notificationMsg);
                response.setPayload(result.toString());
                return response;
            }
            return new Response(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
        }
        if (msg.getClientAttributeListCount() == 0 && msg.getSharedAttributeListCount() == 0) {
            return new Response(CoAP.ResponseCode.NOT_FOUND);
        }
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        JsonObject result = JsonConverter.toJson((TransportProtos.GetAttributeResponseMsg)msg);
        response.setPayload(result.toString());
        return response;
    }

    private Response getObserveNotification(JsonElement json) {
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        response.setPayload(json.toString());
        return response;
    }

    private String validatePayload(UUID sessionId, Request inbound, boolean isEmptyPayloadAllowed) throws AdaptorException {
        String payload = inbound.getPayloadString();
        if (payload == null) {
            log.warn("[{}] Payload is empty!", (Object)sessionId);
            if (!isEmptyPayloadAllowed) {
                throw new AdaptorException((Exception)new IllegalArgumentException("Payload is empty!"));
            }
        }
        return payload;
    }

    @Override
    public int getContentFormat() {
        return 50;
    }
}

