/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.adaptors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.californium.core.coap.Request;
import org.springframework.util.StringUtils;
import org.thingsboard.server.common.transport.adaptor.AdaptorException;
import org.thingsboard.server.gen.transport.TransportProtos;

public class CoapAdaptorUtils {
    public static TransportProtos.GetAttributeRequestMsg toGetAttributeRequestMsg(Request inbound) throws AdaptorException {
        List queryElements = inbound.getOptions().getUriQuery();
        TransportProtos.GetAttributeRequestMsg.Builder result = TransportProtos.GetAttributeRequestMsg.newBuilder();
        if (queryElements != null && queryElements.size() > 0) {
            Set<String> clientKeys = CoapAdaptorUtils.toKeys(queryElements, "clientKeys");
            Set<String> sharedKeys = CoapAdaptorUtils.toKeys(queryElements, "sharedKeys");
            if (clientKeys != null) {
                result.addAllClientAttributeNames(clientKeys);
            }
            if (sharedKeys != null) {
                result.addAllSharedAttributeNames(sharedKeys);
            }
        }
        result.setOnlyShared(false);
        return result.build();
    }

    private static Set<String> toKeys(List<String> queryElements, String attributeName) throws AdaptorException {
        String keys = null;
        for (String queryElement : queryElements) {
            String[] queryItem = queryElement.split("=");
            if (queryItem.length != 2 || !queryItem[0].equals(attributeName)) continue;
            keys = queryItem[1];
        }
        if (keys != null && !StringUtils.isEmpty(keys)) {
            return new HashSet<String>(Arrays.asList(keys.split(",")));
        }
        return null;
    }
}

