/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.transport.TransportContext;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.adaptors.JsonCoapAdaptor;
import org.thingsboard.server.transport.coap.adaptors.ProtoCoapAdaptor;
import org.thingsboard.server.transport.coap.client.CoapClientContext;
import org.thingsboard.server.transport.coap.efento.adaptor.EfentoCoapAdaptor;

@ConditionalOnExpression(value="'${service.type:null}'=='tb-transport' || ('${service.type:null}'=='monolith' && '${transport.api_enabled:true}'=='true' && '${transport.coap.enabled}'=='true')")
@Component
public class CoapTransportContext
extends TransportContext {
    private static final Logger log = LoggerFactory.getLogger(CoapTransportContext.class);
    @Value(value="${transport.sessions.report_timeout}")
    private long sessionReportTimeout;
    @Autowired
    private JsonCoapAdaptor jsonCoapAdaptor;
    @Autowired
    private ProtoCoapAdaptor protoCoapAdaptor;
    @Autowired
    private EfentoCoapAdaptor efentoCoapAdaptor;
    @Autowired
    private CoapClientContext clientContext;
    private final ConcurrentMap<Integer, TransportProtos.ToDeviceRpcRequestMsg> rpcAwaitingAck = new ConcurrentHashMap<Integer, TransportProtos.ToDeviceRpcRequestMsg>();

    public long getSessionReportTimeout() {
        return this.sessionReportTimeout;
    }

    public JsonCoapAdaptor getJsonCoapAdaptor() {
        return this.jsonCoapAdaptor;
    }

    public ProtoCoapAdaptor getProtoCoapAdaptor() {
        return this.protoCoapAdaptor;
    }

    public EfentoCoapAdaptor getEfentoCoapAdaptor() {
        return this.efentoCoapAdaptor;
    }

    public CoapClientContext getClientContext() {
        return this.clientContext;
    }

    public ConcurrentMap<Integer, TransportProtos.ToDeviceRpcRequestMsg> getRpcAwaitingAck() {
        return this.rpcAwaitingAck;
    }
}

