/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.efento;

import com.google.gson.JsonObject;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.device.profile.CoapDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.DeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.EfentoCoapDeviceTypeConfiguration;
import org.thingsboard.server.common.transport.TransportContext;
import org.thingsboard.server.common.transport.TransportServiceCallback;
import org.thingsboard.server.common.transport.adaptor.AdaptorException;
import org.thingsboard.server.common.transport.auth.SessionInfoCreator;
import org.thingsboard.server.common.transport.auth.ValidateDeviceCredentialsResponse;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.gen.transport.coap.MeasurementTypeProtos;
import org.thingsboard.server.gen.transport.coap.MeasurementsProtos;
import org.thingsboard.server.transport.coap.AbstractCoapTransportResource;
import org.thingsboard.server.transport.coap.CoapTransportContext;
import org.thingsboard.server.transport.coap.callback.CoapDeviceAuthCallback;
import org.thingsboard.server.transport.coap.callback.CoapOkCallback;
import org.thingsboard.server.transport.coap.efento.utils.CoapEfentoUtils;

public class CoapEfentoTransportResource
extends AbstractCoapTransportResource {
    private static final Logger log = LoggerFactory.getLogger(CoapEfentoTransportResource.class);
    private static final int MEASUREMENTS_POSITION = 2;
    private static final String MEASUREMENTS = "m";

    public CoapEfentoTransportResource(CoapTransportContext context, String name) {
        super(context, name);
        this.setObservable(true);
        this.setObserveType(CoAP.Type.CON);
    }

    @Override
    protected void processHandleGet(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    @Override
    protected void processHandlePost(CoapExchange exchange) {
        boolean validPath;
        Exchange advanced = exchange.advanced();
        Request request = advanced.getRequest();
        List uriPath = request.getOptions().getUriPath();
        boolean bl = validPath = uriPath.size() == 2 && ((String)uriPath.get(1)).equals(MEASUREMENTS);
        if (!validPath) {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
            return;
        }
        byte[] bytes = request.getPayload();
        try {
            MeasurementsProtos.ProtoMeasurements protoMeasurements = MeasurementsProtos.ProtoMeasurements.parseFrom(bytes);
            log.trace("Successfully parsed Efento ProtoMeasurements: [{}]", (Object)protoMeasurements.getCloudToken());
            String token = protoMeasurements.getCloudToken();
            this.transportService.process(DeviceTransportType.COAP, TransportProtos.ValidateDeviceTokenRequestMsg.newBuilder().setToken(token).build(), (TransportServiceCallback)new CoapDeviceAuthCallback(exchange, (msg, deviceProfile) -> {
                TransportProtos.SessionInfoProto sessionInfo = SessionInfoCreator.create((ValidateDeviceCredentialsResponse)msg, (TransportContext)this.transportContext, (UUID)UUID.randomUUID());
                UUID sessionId = new UUID(sessionInfo.getSessionIdMSB(), sessionInfo.getSessionIdLSB());
                try {
                    this.validateEfentoTransportConfiguration((DeviceProfile)deviceProfile);
                    List<EfentoMeasurements> efentoMeasurements = this.getEfentoMeasurements(protoMeasurements, sessionId);
                    this.transportService.process(sessionInfo, this.transportContext.getEfentoCoapAdaptor().convertToPostTelemetry(sessionId, efentoMeasurements), (TransportServiceCallback)new CoapOkCallback(exchange, CoAP.ResponseCode.CREATED, CoAP.ResponseCode.INTERNAL_SERVER_ERROR));
                    this.reportSubscriptionInfo(sessionInfo, false, false);
                }
                catch (AdaptorException e) {
                    log.error("[{}] Failed to decode Efento ProtoMeasurements: ", (Object)sessionId, (Object)e);
                    exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
                }
            }));
        }
        catch (Exception e) {
            log.error("Failed to decode Efento ProtoMeasurements: ", (Throwable)e);
            exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
        }
    }

    public Resource getChild(String name) {
        return this;
    }

    private void validateEfentoTransportConfiguration(DeviceProfile deviceProfile) throws AdaptorException {
        DeviceProfileTransportConfiguration transportConfiguration = deviceProfile.getProfileData().getTransportConfiguration();
        if (transportConfiguration instanceof CoapDeviceProfileTransportConfiguration) {
            CoapDeviceProfileTransportConfiguration coapDeviceProfileTransportConfiguration = (CoapDeviceProfileTransportConfiguration)transportConfiguration;
            if (!(coapDeviceProfileTransportConfiguration.getCoapDeviceTypeConfiguration() instanceof EfentoCoapDeviceTypeConfiguration)) {
                throw new AdaptorException("Invalid CoapDeviceTypeConfiguration type: " + coapDeviceProfileTransportConfiguration.getCoapDeviceTypeConfiguration().getClass().getSimpleName() + "!");
            }
        } else {
            throw new AdaptorException("Invalid DeviceProfileTransportConfiguration type" + transportConfiguration.getClass().getSimpleName() + "!");
        }
    }

    private List<EfentoMeasurements> getEfentoMeasurements(MeasurementsProtos.ProtoMeasurements protoMeasurements, UUID sessionId) {
        String serialNumber = CoapEfentoUtils.convertByteArrayToString(protoMeasurements.getSerialNum().toByteArray());
        boolean batteryStatus = protoMeasurements.getBatteryStatus();
        int measurementPeriodBase = protoMeasurements.getMeasurementPeriodBase();
        int measurementPeriodFactor = protoMeasurements.getMeasurementPeriodFactor();
        int signal = protoMeasurements.getSignal();
        List<MeasurementsProtos.ProtoChannel> channelsList = protoMeasurements.getChannelsList();
        TreeMap<Long, JsonObject> valuesMap = new TreeMap<Long, JsonObject>();
        if (!CollectionUtils.isEmpty(channelsList)) {
            int channel = 0;
            for (MeasurementsProtos.ProtoChannel protoChannel : channelsList) {
                ++channel;
                boolean isBinarySensor = false;
                MeasurementTypeProtos.MeasurementType measurementType = protoChannel.getType();
                String measurementTypeName = measurementType.name();
                if (measurementType.equals((Object)MeasurementTypeProtos.MeasurementType.OK_ALARM) || measurementType.equals((Object)MeasurementTypeProtos.MeasurementType.FLOODING)) {
                    isBinarySensor = true;
                }
                measurementPeriodFactor = measurementPeriodFactor == 0 && isBinarySensor ? 14 : 1;
                int measurementPeriod = measurementPeriodBase * measurementPeriodFactor;
                long measurementPeriodMillis = TimeUnit.SECONDS.toMillis(measurementPeriod);
                long nextTransmissionAtMillis = TimeUnit.SECONDS.toMillis(protoMeasurements.getNextTransmissionAt());
                int startPoint = protoChannel.getStartPoint();
                int startTimestamp = protoChannel.getTimestamp();
                long startTimestampMillis = TimeUnit.SECONDS.toMillis(startTimestamp);
                List<Integer> sampleOffsetsList = protoChannel.getSampleOffsetsList();
                if (!CollectionUtils.isEmpty(sampleOffsetsList)) {
                    int sampleOfssetsListSize = sampleOffsetsList.size();
                    block9: for (int i = 0; i < sampleOfssetsListSize; ++i) {
                        Integer previousSampleOffset;
                        int sampleOffset = sampleOffsetsList.get(i);
                        Integer n = previousSampleOffset = isBinarySensor && i > 0 ? sampleOffsetsList.get(i - 1) : null;
                        if (sampleOffset == Short.MIN_VALUE) {
                            log.warn("[{}],[{}] Sensor error value! Ignoring.", (Object)sessionId, (Object)sampleOffset);
                            continue;
                        }
                        switch (measurementType) {
                            case TEMPERATURE: {
                                JsonObject values = valuesMap.computeIfAbsent(startTimestampMillis, k -> CoapEfentoUtils.setDefaultMeasurements(serialNumber, batteryStatus, measurementPeriod, nextTransmissionAtMillis, signal, k));
                                values.addProperty("temperature_" + channel, (Number)((double)(startPoint + sampleOffset) / 10.0));
                                startTimestampMillis += measurementPeriodMillis;
                                continue block9;
                            }
                            case HUMIDITY: {
                                JsonObject values = valuesMap.computeIfAbsent(startTimestampMillis, k -> CoapEfentoUtils.setDefaultMeasurements(serialNumber, batteryStatus, measurementPeriod, nextTransmissionAtMillis, signal, k));
                                values.addProperty("humidity_" + channel, (Number)(startPoint + sampleOffset));
                                startTimestampMillis += measurementPeriodMillis;
                                continue block9;
                            }
                            case ATMOSPHERIC_PRESSURE: {
                                JsonObject values = valuesMap.computeIfAbsent(startTimestampMillis, k -> CoapEfentoUtils.setDefaultMeasurements(serialNumber, batteryStatus, measurementPeriod, nextTransmissionAtMillis, signal, k));
                                values.addProperty("pressure_" + channel, (Number)((double)(startPoint + sampleOffset) / 10.0));
                                startTimestampMillis += measurementPeriodMillis;
                                continue block9;
                            }
                            case DIFFERENTIAL_PRESSURE: {
                                JsonObject values = valuesMap.computeIfAbsent(startTimestampMillis, k -> CoapEfentoUtils.setDefaultMeasurements(serialNumber, batteryStatus, measurementPeriod, nextTransmissionAtMillis, signal, k));
                                values.addProperty("pressure_diff_" + channel, (Number)(startPoint + sampleOffset));
                                startTimestampMillis += measurementPeriodMillis;
                                continue block9;
                            }
                            case OK_ALARM: {
                                boolean currentIsOk;
                                boolean bl = currentIsOk = sampleOffset < 0;
                                if (previousSampleOffset != null) {
                                    boolean isAlarm;
                                    boolean previousIsOk = previousSampleOffset < 0;
                                    boolean isOk = previousIsOk && currentIsOk;
                                    boolean bl2 = isAlarm = !previousIsOk && !currentIsOk;
                                    if (isOk || isAlarm) continue block9;
                                }
                                String data = currentIsOk ? "OK" : "ALARM";
                                long sampleOffsetMillis = TimeUnit.SECONDS.toMillis(sampleOffset);
                                long measurementTimestamp = startTimestampMillis + Math.abs(sampleOffsetMillis);
                                JsonObject values = valuesMap.computeIfAbsent(measurementTimestamp - 1000L, k -> CoapEfentoUtils.setDefaultMeasurements(serialNumber, batteryStatus, measurementPeriod, nextTransmissionAtMillis, signal, k));
                                values.addProperty("ok_alarm_" + channel, data);
                                continue block9;
                            }
                            case NO_SENSOR: 
                            case UNRECOGNIZED: {
                                log.trace("[{}][{}] Sensor error value! Ignoring.", (Object)sessionId, (Object)measurementTypeName);
                                continue block9;
                            }
                            default: {
                                log.trace("[{}],[{}] Unsupported measurementType! Ignoring.", (Object)sessionId, (Object)measurementTypeName);
                            }
                        }
                    }
                    continue;
                }
                log.trace("[{}][{}] sampleOffsetsList list is empty!", (Object)sessionId, (Object)measurementTypeName);
            }
        } else {
            throw new IllegalStateException("[" + sessionId + "]: Failed to get Efento measurements, reason: channels list is empty!");
        }
        if (!CollectionUtils.isEmpty(valuesMap)) {
            ArrayList<EfentoMeasurements> efentoMeasurements = new ArrayList<EfentoMeasurements>();
            for (Long ts : valuesMap.keySet()) {
                EfentoMeasurements measurement = new EfentoMeasurements(ts, (JsonObject)valuesMap.get(ts));
                efentoMeasurements.add(measurement);
            }
            return efentoMeasurements;
        }
        throw new IllegalStateException("[" + sessionId + "]: Failed to collect Efento measurements, reason, values map is empty!");
    }

    public static class EfentoMeasurements {
        private long ts;
        private JsonObject values;

        public long getTs() {
            return this.ts;
        }

        public JsonObject getValues() {
            return this.values;
        }

        public void setTs(long ts) {
            this.ts = ts;
        }

        public void setValues(JsonObject values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EfentoMeasurements)) {
                return false;
            }
            EfentoMeasurements other = (EfentoMeasurements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTs() != other.getTs()) {
                return false;
            }
            JsonObject this$values = this.getValues();
            JsonObject other$values = other.getValues();
            return !(this$values == null ? other$values != null : !this$values.equals(other$values));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EfentoMeasurements;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $ts = this.getTs();
            result = result * 59 + (int)($ts >>> 32 ^ $ts);
            JsonObject $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : $values.hashCode());
            return result;
        }

        public String toString() {
            return "CoapEfentoTransportResource.EfentoMeasurements(ts=" + this.getTs() + ", values=" + this.getValues() + ")";
        }

        @ConstructorProperties(value={"ts", "values"})
        public EfentoMeasurements(long ts, JsonObject values) {
            this.ts = ts;
            this.values = values;
        }
    }
}

