/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.callback;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.transport.adaptor.AdaptorException;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.callback.AbstractSyncSessionCallback;
import org.thingsboard.server.transport.coap.client.TbCoapClientState;

public class ToServerRpcSyncSessionCallback
extends AbstractSyncSessionCallback {
    private static final Logger log = LoggerFactory.getLogger(ToServerRpcSyncSessionCallback.class);

    public ToServerRpcSyncSessionCallback(TbCoapClientState state, CoapExchange exchange, Request request) {
        super(state, exchange, request);
    }

    @Override
    public void onToServerRpcResponse(TransportProtos.ToServerRpcResponseMsg toServerResponse) {
        try {
            this.respond(this.state.getAdaptor().convertToPublish(this.request.isConfirmable(), toServerResponse));
        }
        catch (AdaptorException e) {
            log.trace("Failed to reply due to error", (Throwable)e);
            this.exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
        }
    }
}

