/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.callback;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.thingsboard.server.common.transport.TransportServiceCallback;

public class CoapOkCallback
implements TransportServiceCallback<Void> {
    protected final CoapExchange exchange;
    protected final CoAP.ResponseCode onSuccessResponse;
    protected final CoAP.ResponseCode onFailureResponse;

    public CoapOkCallback(CoapExchange exchange, CoAP.ResponseCode onSuccessResponse, CoAP.ResponseCode onFailureResponse) {
        this.exchange = exchange;
        this.onSuccessResponse = onSuccessResponse;
        this.onFailureResponse = onFailureResponse;
    }

    public void onSuccess(Void msg) {
        Response response = new Response(this.onSuccessResponse);
        response.setConfirmable(this.isConRequest());
        this.exchange.respond(response);
    }

    public void onError(Throwable e) {
        this.exchange.respond(this.onFailureResponse);
    }

    protected boolean isConRequest() {
        return this.exchange.advanced().getRequest().isConfirmable();
    }
}

