/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.transport.coap.adaptors;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.transport.adaptor.AdaptorException;
import org.thingsboard.server.common.transport.adaptor.JsonConverter;
import org.thingsboard.server.common.transport.adaptor.ProtoConverter;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.transport.coap.CoapTransportResource;
import org.thingsboard.server.transport.coap.adaptors.CoapAdaptorUtils;
import org.thingsboard.server.transport.coap.adaptors.CoapTransportAdaptor;

@Component
public class ProtoCoapAdaptor
implements CoapTransportAdaptor {
    private static final Logger log = LoggerFactory.getLogger(ProtoCoapAdaptor.class);

    @Override
    public TransportProtos.PostTelemetryMsg convertToPostTelemetry(UUID sessionId, Request inbound, Descriptors.Descriptor telemetryMsgDescriptor) throws AdaptorException {
        try {
            return JsonConverter.convertToTelemetryProto((JsonElement)new JsonParser().parse(this.dynamicMsgToJson(inbound.getPayload(), telemetryMsgDescriptor)));
        }
        catch (Exception e) {
            throw new AdaptorException(e);
        }
    }

    @Override
    public TransportProtos.PostAttributeMsg convertToPostAttributes(UUID sessionId, Request inbound, Descriptors.Descriptor attributesMsgDescriptor) throws AdaptorException {
        try {
            return JsonConverter.convertToAttributesProto((JsonElement)new JsonParser().parse(this.dynamicMsgToJson(inbound.getPayload(), attributesMsgDescriptor)));
        }
        catch (Exception e) {
            throw new AdaptorException(e);
        }
    }

    @Override
    public TransportProtos.GetAttributeRequestMsg convertToGetAttributes(UUID sessionId, Request inbound) throws AdaptorException {
        return CoapAdaptorUtils.toGetAttributeRequestMsg(inbound);
    }

    @Override
    public TransportProtos.ToDeviceRpcResponseMsg convertToDeviceRpcResponse(UUID sessionId, Request inbound, Descriptors.Descriptor rpcResponseMsgDescriptor) throws AdaptorException {
        Optional<Integer> requestId = CoapTransportResource.getRequestId(inbound);
        if (requestId.isEmpty()) {
            throw new AdaptorException("Request id is missing!");
        }
        try {
            JsonElement response = new JsonParser().parse(this.dynamicMsgToJson(inbound.getPayload(), rpcResponseMsgDescriptor));
            return TransportProtos.ToDeviceRpcResponseMsg.newBuilder().setRequestId(requestId.orElseThrow(() -> new AdaptorException("Request id is missing!")).intValue()).setPayload(response.toString()).build();
        }
        catch (Exception e) {
            throw new AdaptorException(e);
        }
    }

    @Override
    public TransportProtos.ToServerRpcRequestMsg convertToServerRpcRequest(UUID sessionId, Request inbound) throws AdaptorException {
        try {
            return ProtoConverter.convertToServerRpcRequest((byte[])inbound.getPayload(), (int)0);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new AdaptorException((Exception)((Object)ex));
        }
    }

    @Override
    public TransportProtos.ClaimDeviceMsg convertToClaimDevice(UUID sessionId, Request inbound, TransportProtos.SessionInfoProto sessionInfo) throws AdaptorException {
        DeviceId deviceId = new DeviceId(new UUID(sessionInfo.getDeviceIdMSB(), sessionInfo.getDeviceIdLSB()));
        try {
            return ProtoConverter.convertToClaimDeviceProto((DeviceId)deviceId, (byte[])inbound.getPayload());
        }
        catch (InvalidProtocolBufferException ex) {
            throw new AdaptorException((Exception)((Object)ex));
        }
    }

    @Override
    public TransportProtos.ProvisionDeviceRequestMsg convertToProvisionRequestMsg(UUID sessionId, Request inbound) throws AdaptorException {
        try {
            return ProtoConverter.convertToProvisionRequestMsg((byte[])inbound.getPayload());
        }
        catch (InvalidProtocolBufferException ex) {
            throw new AdaptorException((Exception)((Object)ex));
        }
    }

    @Override
    public Response convertToPublish(boolean isConfirmable, TransportProtos.AttributeUpdateNotificationMsg msg) throws AdaptorException {
        return this.getObserveNotification(isConfirmable, msg.toByteArray());
    }

    @Override
    public Response convertToPublish(boolean isConfirmable, TransportProtos.ToDeviceRpcRequestMsg rpcRequest, DynamicMessage.Builder rpcRequestDynamicMessageBuilder) throws AdaptorException {
        return this.getObserveNotification(isConfirmable, ProtoConverter.convertToRpcRequest((TransportProtos.ToDeviceRpcRequestMsg)rpcRequest, (DynamicMessage.Builder)rpcRequestDynamicMessageBuilder));
    }

    @Override
    public Response convertToPublish(boolean isConfirmable, TransportProtos.ToServerRpcResponseMsg msg) throws AdaptorException {
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        response.setConfirmable(isConfirmable);
        response.setPayload(msg.toByteArray());
        return response;
    }

    @Override
    public Response convertToPublish(boolean isConfirmable, TransportProtos.GetAttributeResponseMsg msg) throws AdaptorException {
        if (msg.getSharedStateMsg()) {
            if (StringUtils.isEmpty((Object)msg.getError())) {
                Response response = new Response(CoAP.ResponseCode.CONTENT);
                response.setConfirmable(isConfirmable);
                TransportProtos.AttributeUpdateNotificationMsg notificationMsg = TransportProtos.AttributeUpdateNotificationMsg.newBuilder().addAllSharedUpdated((Iterable)msg.getSharedAttributeListList()).build();
                response.setPayload(notificationMsg.toByteArray());
                return response;
            }
            return new Response(CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
        }
        if (msg.getClientAttributeListCount() == 0 && msg.getSharedAttributeListCount() == 0) {
            return new Response(CoAP.ResponseCode.NOT_FOUND);
        }
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        response.setConfirmable(isConfirmable);
        response.setPayload(msg.toByteArray());
        return response;
    }

    private Response getObserveNotification(boolean confirmable, byte[] notification) {
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        response.setPayload(notification);
        response.setConfirmable(confirmable);
        return response;
    }

    private String dynamicMsgToJson(byte[] bytes, Descriptors.Descriptor descriptor) throws InvalidProtocolBufferException {
        DynamicMessage dynamicMessage = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (byte[])bytes);
        return JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)dynamicMessage);
    }

    @Override
    public int getContentFormat() {
        return 42;
    }
}

