/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.stats;

import io.micrometer.core.instrument.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.FstStatsService;
import org.thingsboard.server.common.stats.StatsCounter;
import org.thingsboard.server.common.stats.StatsFactory;

@Service
public class FstStatsServiceImpl
implements FstStatsService {
    private final ConcurrentHashMap<String, StatsCounter> encodeCounters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, StatsCounter> decodeCounters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Timer> encodeTimers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Timer> decodeTimer = new ConcurrentHashMap();
    @Autowired
    private StatsFactory statsFactory;

    public void incrementEncode(Class<?> clazz) {
        this.encodeCounters.computeIfAbsent(clazz.getSimpleName(), key -> this.statsFactory.createStatsCounter("fst_encode", (String)key, new String[0])).increment();
    }

    public void incrementDecode(Class<?> clazz) {
        this.decodeCounters.computeIfAbsent(clazz.getSimpleName(), key -> this.statsFactory.createStatsCounter("fst_decode", (String)key, new String[0])).increment();
    }

    public void recordEncodeTime(Class<?> clazz, long startTime) {
        this.encodeTimers.computeIfAbsent(clazz.getSimpleName(), key -> this.statsFactory.createTimer("fst_encode_time", "statsName", (String)key)).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
    }

    public void recordDecodeTime(Class<?> clazz, long startTime) {
        this.decodeTimer.computeIfAbsent(clazz.getSimpleName(), key -> this.statsFactory.createTimer("fst_decode_time", "statsName", (String)key)).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
    }
}

