/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.stats;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToDoubleFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.stats.DefaultCounter;
import org.thingsboard.server.common.stats.DefaultMessagesStats;
import org.thingsboard.server.common.stats.MessagesStats;
import org.thingsboard.server.common.stats.StatsCounter;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.common.stats.StatsTimer;

@Service
public class DefaultStatsFactory
implements StatsFactory {
    private static final String TOTAL_MSGS = "totalMsgs";
    private static final String SUCCESSFUL_MSGS = "successfulMsgs";
    private static final String FAILED_MSGS = "failedMsgs";
    private static final String STATS_NAME_TAG = "statsName";
    private static final Counter STUB_COUNTER = new StubCounter();
    @Autowired
    private MeterRegistry meterRegistry;
    @Value(value="${metrics.enabled:false}")
    private Boolean metricsEnabled;
    @Value(value="${metrics.timer.percentiles:0.5}")
    private String timerPercentilesStr;
    private double[] timerPercentiles;

    @PostConstruct
    public void init() {
        if (!StringUtils.isEmpty((String)this.timerPercentilesStr)) {
            String[] split = this.timerPercentilesStr.split(",");
            this.timerPercentiles = new double[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.timerPercentiles[i] = Double.parseDouble(split[i]);
            }
        }
    }

    @Override
    public StatsCounter createStatsCounter(String key, String statsName, String ... otherTags) {
        String[] tags = DefaultStatsFactory.getTags(statsName, otherTags);
        return new StatsCounter(new AtomicInteger(0), this.metricsEnabled != false ? this.meterRegistry.counter(key, tags) : STUB_COUNTER, statsName);
    }

    @Override
    public DefaultCounter createDefaultCounter(String key, String ... tags) {
        return new DefaultCounter(new AtomicInteger(0), this.metricsEnabled != false ? this.meterRegistry.counter(key, tags) : STUB_COUNTER);
    }

    @Override
    public <T extends Number> T createGauge(String key, T number, String ... tags) {
        return (T)(this.metricsEnabled != false ? this.meterRegistry.gauge(key, (Iterable)Tags.of((String[])tags), number) : number);
    }

    @Override
    public <T extends Number> T createGauge(String type, String name, T number, String ... tags) {
        return this.createGauge(type, number, DefaultStatsFactory.getTags(name, tags));
    }

    @Override
    public <S> void createGauge(String type, String name, S stateObject, ToDoubleFunction<S> numberProvider, String ... tags) {
        this.meterRegistry.gauge(type, (Iterable)Tags.of((String[])DefaultStatsFactory.getTags(name, tags)), stateObject, numberProvider);
    }

    @Override
    public MessagesStats createMessagesStats(String key) {
        StatsCounter totalCounter = this.createStatsCounter(key, TOTAL_MSGS, new String[0]);
        StatsCounter successfulCounter = this.createStatsCounter(key, SUCCESSFUL_MSGS, new String[0]);
        StatsCounter failedCounter = this.createStatsCounter(key, FAILED_MSGS, new String[0]);
        return new DefaultMessagesStats(totalCounter, successfulCounter, failedCounter);
    }

    @Override
    public Timer createTimer(String key, String ... tags) {
        Timer.Builder timerBuilder = Timer.builder((String)key).tags(tags).publishPercentiles(new double[0]);
        if (this.timerPercentiles != null && this.timerPercentiles.length > 0) {
            timerBuilder.publishPercentiles(this.timerPercentiles);
        }
        return timerBuilder.register(this.meterRegistry);
    }

    @Override
    public StatsTimer createStatsTimer(String type, String name, String ... tags) {
        return new StatsTimer(name, Timer.builder((String)type).tags(DefaultStatsFactory.getTags(name, tags)).register(this.meterRegistry));
    }

    private static String[] getTags(String statsName, String[] otherTags) {
        Object[] tags = new String[]{STATS_NAME_TAG, statsName};
        if (otherTags.length > 0) {
            if (otherTags.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid tags array size");
            }
            tags = (String[])ArrayUtils.addAll((Object[])tags, (Object[])otherTags);
        }
        return tags;
    }

    @Override
    public Meter remove(Counter counter) {
        return this.meterRegistry.remove(counter.getId());
    }

    private static class StubCounter
    implements Counter {
        private StubCounter() {
        }

        public void increment(double amount) {
        }

        public double count() {
            return 0.0;
        }

        public Meter.Id getId() {
            return null;
        }
    }
}

