/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.stats;

import io.micrometer.core.instrument.Counter;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultCounter {
    private final AtomicInteger aiCounter;
    private final Counter micrometerCounter;

    public DefaultCounter(AtomicInteger aiCounter, Counter micrometerCounter) {
        this.aiCounter = aiCounter;
        this.micrometerCounter = micrometerCounter;
    }

    public void increment() {
        this.aiCounter.incrementAndGet();
        this.micrometerCounter.increment();
    }

    public void clear() {
        this.aiCounter.set(0);
    }

    public int get() {
        return this.aiCounter.get();
    }

    public int getAndClear() {
        return this.aiCounter.getAndSet(0);
    }

    public void add(int delta) {
        this.aiCounter.addAndGet(delta);
        this.micrometerCounter.increment((double)delta);
    }

    public Counter getMicrometerCounter() {
        return this.micrometerCounter;
    }
}

