/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.stats;

import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class StatsTimer {
    private final String name;
    private final Timer timer;
    private int count;
    private long totalTime;

    public StatsTimer(String name, Timer micrometerTimer) {
        this.name = name;
        this.timer = micrometerTimer;
    }

    public void record(long timeMs) {
        this.record(timeMs, TimeUnit.MILLISECONDS);
    }

    public void record(long timing, TimeUnit timeUnit) {
        ++this.count;
        this.totalTime += timeUnit.toMillis(timing);
        this.timer.record(timing, timeUnit);
    }

    public double getAvg() {
        if (this.count == 0) {
            return 0.0;
        }
        return (double)this.totalTime / (double)this.count;
    }

    public void reset() {
        this.count = 0;
        this.totalTime = 0L;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

