/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.stats;

import org.thingsboard.server.common.stats.MessagesStats;
import org.thingsboard.server.common.stats.StatsCounter;

public class DefaultMessagesStats
implements MessagesStats {
    private final StatsCounter totalCounter;
    private final StatsCounter successfulCounter;
    private final StatsCounter failedCounter;

    public DefaultMessagesStats(StatsCounter totalCounter, StatsCounter successfulCounter, StatsCounter failedCounter) {
        this.totalCounter = totalCounter;
        this.successfulCounter = successfulCounter;
        this.failedCounter = failedCounter;
    }

    @Override
    public void incrementTotal(int amount) {
        this.totalCounter.add(amount);
    }

    @Override
    public void incrementSuccessful(int amount) {
        this.successfulCounter.add(amount);
    }

    @Override
    public void incrementFailed(int amount) {
        this.failedCounter.add(amount);
    }

    @Override
    public int getTotal() {
        return this.totalCounter.get();
    }

    @Override
    public int getSuccessful() {
        return this.successfulCounter.get();
    }

    @Override
    public int getFailed() {
        return this.failedCounter.get();
    }

    @Override
    public void reset() {
        this.totalCounter.clear();
        this.successfulCounter.clear();
        this.failedCounter.clear();
    }
}

