/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.stats;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.thingsboard.server.common.stats.DefaultCounter;
import org.thingsboard.server.common.stats.DefaultMessagesStats;
import org.thingsboard.server.common.stats.MessagesStats;
import org.thingsboard.server.common.stats.StatsCounter;
import org.thingsboard.server.common.stats.StatsFactory;

@Service
public class DefaultStatsFactory
implements StatsFactory {
    private static final String TOTAL_MSGS = "totalMsgs";
    private static final String SUCCESSFUL_MSGS = "successfulMsgs";
    private static final String FAILED_MSGS = "failedMsgs";
    private static final String STATS_NAME_TAG = "statsName";
    private static final Counter STUB_COUNTER = new StubCounter();
    @Autowired
    private MeterRegistry meterRegistry;
    @Value(value="${metrics.enabled:false}")
    private Boolean metricsEnabled;
    @Value(value="${metrics.timer.percentiles:0.5}")
    private String timerPercentilesStr;
    private double[] timerPercentiles;

    @PostConstruct
    public void init() {
        if (!StringUtils.isEmpty((Object)this.timerPercentilesStr)) {
            String[] split = this.timerPercentilesStr.split(",");
            this.timerPercentiles = new double[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.timerPercentiles[i] = Double.parseDouble(split[i]);
            }
        }
    }

    @Override
    public StatsCounter createStatsCounter(String key, String statsName) {
        return new StatsCounter(new AtomicInteger(0), this.metricsEnabled != false ? this.meterRegistry.counter(key, new String[]{STATS_NAME_TAG, statsName}) : STUB_COUNTER, statsName);
    }

    @Override
    public DefaultCounter createDefaultCounter(String key, String ... tags) {
        return new DefaultCounter(new AtomicInteger(0), this.metricsEnabled != false ? this.meterRegistry.counter(key, tags) : STUB_COUNTER);
    }

    @Override
    public <T extends Number> T createGauge(String key, T number, String ... tags) {
        return (T)this.meterRegistry.gauge(key, (Iterable)Tags.of((String[])tags), number);
    }

    @Override
    public MessagesStats createMessagesStats(String key) {
        StatsCounter totalCounter = this.createStatsCounter(key, TOTAL_MSGS);
        StatsCounter successfulCounter = this.createStatsCounter(key, SUCCESSFUL_MSGS);
        StatsCounter failedCounter = this.createStatsCounter(key, FAILED_MSGS);
        return new DefaultMessagesStats(totalCounter, successfulCounter, failedCounter);
    }

    @Override
    public Timer createTimer(String key, String ... tags) {
        Timer.Builder timerBuilder = Timer.builder((String)key).tags(tags).publishPercentiles(new double[0]);
        if (this.timerPercentiles != null && this.timerPercentiles.length > 0) {
            timerBuilder.publishPercentiles(this.timerPercentiles);
        }
        return timerBuilder.register(this.meterRegistry);
    }

    private static class StubCounter
    implements Counter {
        private StubCounter() {
        }

        public void increment(double amount) {
        }

        public double count() {
            return 0.0;
        }

        public Meter.Id getId() {
            return null;
        }
    }
}

