/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api.tbel;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TbelScript {
    private final String scriptBody;
    private final String[] argNames;

    public Map createVars(Object[] args) {
        if (args == null || args.length != this.argNames.length) {
            throw new IllegalArgumentException("Invalid number of argument values");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < this.argNames.length; ++i) {
            result.put(this.argNames[i], args[i]);
        }
        return result;
    }

    @ConstructorProperties(value={"scriptBody", "argNames"})
    public TbelScript(String scriptBody, String[] argNames) {
        this.scriptBody = scriptBody;
        this.argNames = argNames;
    }

    public String getScriptBody() {
        return this.scriptBody;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbelScript)) {
            return false;
        }
        TbelScript other = (TbelScript)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scriptBody = this.getScriptBody();
        String other$scriptBody = other.getScriptBody();
        if (this$scriptBody == null ? other$scriptBody != null : !this$scriptBody.equals(other$scriptBody)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgNames(), other.getArgNames());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbelScript;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scriptBody = this.getScriptBody();
        result = result * 59 + ($scriptBody == null ? 43 : $scriptBody.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgNames());
        return result;
    }

    public String toString() {
        return "TbelScript(scriptBody=" + this.getScriptBody() + ", argNames=" + Arrays.deepToString(this.getArgNames()) + ")";
    }
}

