/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api.tbel;

import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang3.ArrayUtils;
import org.mvel2.ExecutionContext;
import org.mvel2.ParserConfiguration;
import org.mvel2.execution.ExecutionArrayList;
import org.mvel2.execution.ExecutionHashMap;
import org.mvel2.util.MethodStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.script.api.tbel.TbJson;
import org.thingsboard.server.common.data.StringUtils;

public class TbUtils {
    private static final Logger log = LoggerFactory.getLogger(TbUtils.class);
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
    private static final int ZERO_RADIX = 0;
    private static final int OCTAL_RADIX = 8;
    private static final int DEC_RADIX = 10;
    private static final int HEX_RADIX = 16;
    private static final int HEX_LEN_MIN = -1;
    private static final int HEX_LEN_INT_MAX = 8;
    private static final int HEX_LEN_LONG_MAX = 16;
    private static final int BYTES_LEN_INT_MAX = 4;
    private static final int BYTES_LEN_LONG_MAX = 8;
    private static final int BIN_LEN_MAX = 8;
    private static final LinkedHashMap<String, String> mdnEncodingReplacements = new LinkedHashMap();

    public static void register(ParserConfiguration parserConfig) throws Exception {
        parserConfig.addImport("btoa", new MethodStub(TbUtils.class.getMethod("btoa", String.class)));
        parserConfig.addImport("atob", new MethodStub(TbUtils.class.getMethod("atob", String.class)));
        parserConfig.addImport("bytesToString", new MethodStub(TbUtils.class.getMethod("bytesToString", List.class)));
        parserConfig.addImport("bytesToString", new MethodStub(TbUtils.class.getMethod("bytesToString", List.class, String.class)));
        parserConfig.addImport("decodeToString", new MethodStub(TbUtils.class.getMethod("bytesToString", List.class)));
        parserConfig.addImport("decodeToJson", new MethodStub(TbUtils.class.getMethod("decodeToJson", ExecutionContext.class, List.class)));
        parserConfig.addImport("decodeToJson", new MethodStub(TbUtils.class.getMethod("decodeToJson", ExecutionContext.class, String.class)));
        parserConfig.addImport("stringToBytes", new MethodStub(TbUtils.class.getMethod("stringToBytes", ExecutionContext.class, Object.class)));
        parserConfig.addImport("stringToBytes", new MethodStub(TbUtils.class.getMethod("stringToBytes", ExecutionContext.class, Object.class, String.class)));
        parserConfig.registerNonConvertableMethods(TbUtils.class, Collections.singleton("stringToBytes"));
        parserConfig.addImport("parseInt", new MethodStub(TbUtils.class.getMethod("parseInt", String.class)));
        parserConfig.addImport("parseInt", new MethodStub(TbUtils.class.getMethod("parseInt", String.class, Integer.TYPE)));
        parserConfig.addImport("parseLong", new MethodStub(TbUtils.class.getMethod("parseLong", String.class)));
        parserConfig.addImport("parseLong", new MethodStub(TbUtils.class.getMethod("parseLong", String.class, Integer.TYPE)));
        parserConfig.addImport("parseFloat", new MethodStub(TbUtils.class.getMethod("parseFloat", String.class)));
        parserConfig.addImport("parseFloat", new MethodStub(TbUtils.class.getMethod("parseFloat", String.class, Integer.TYPE)));
        parserConfig.addImport("parseHexIntLongToFloat", new MethodStub(TbUtils.class.getMethod("parseHexIntLongToFloat", String.class, Boolean.TYPE)));
        parserConfig.addImport("parseDouble", new MethodStub(TbUtils.class.getMethod("parseDouble", String.class)));
        parserConfig.addImport("parseLittleEndianHexToInt", new MethodStub(TbUtils.class.getMethod("parseLittleEndianHexToInt", String.class)));
        parserConfig.addImport("parseBigEndianHexToInt", new MethodStub(TbUtils.class.getMethod("parseBigEndianHexToInt", String.class)));
        parserConfig.addImport("parseHexToInt", new MethodStub(TbUtils.class.getMethod("parseHexToInt", String.class)));
        parserConfig.addImport("parseHexToInt", new MethodStub(TbUtils.class.getMethod("parseHexToInt", String.class, Boolean.TYPE)));
        parserConfig.addImport("parseBytesToInt", new MethodStub(TbUtils.class.getMethod("parseBytesToInt", List.class)));
        parserConfig.addImport("parseBytesToInt", new MethodStub(TbUtils.class.getMethod("parseBytesToInt", List.class, Integer.TYPE)));
        parserConfig.addImport("parseBytesToInt", new MethodStub(TbUtils.class.getMethod("parseBytesToInt", List.class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesToInt", new MethodStub(TbUtils.class.getMethod("parseBytesToInt", List.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseBytesToInt", new MethodStub(TbUtils.class.getMethod("parseBytesToInt", byte[].class)));
        parserConfig.addImport("parseBytesToInt", new MethodStub(TbUtils.class.getMethod("parseBytesToInt", byte[].class, Integer.TYPE)));
        parserConfig.addImport("parseBytesToInt", new MethodStub(TbUtils.class.getMethod("parseBytesToInt", byte[].class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesToInt", new MethodStub(TbUtils.class.getMethod("parseBytesToInt", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseLittleEndianHexToLong", new MethodStub(TbUtils.class.getMethod("parseLittleEndianHexToLong", String.class)));
        parserConfig.addImport("parseBigEndianHexToLong", new MethodStub(TbUtils.class.getMethod("parseBigEndianHexToLong", String.class)));
        parserConfig.addImport("parseHexToLong", new MethodStub(TbUtils.class.getMethod("parseHexToLong", String.class)));
        parserConfig.addImport("parseHexToLong", new MethodStub(TbUtils.class.getMethod("parseHexToLong", String.class, Boolean.TYPE)));
        parserConfig.addImport("parseBytesToLong", new MethodStub(TbUtils.class.getMethod("parseBytesToLong", List.class)));
        parserConfig.addImport("parseBytesToLong", new MethodStub(TbUtils.class.getMethod("parseBytesToLong", List.class, Integer.TYPE)));
        parserConfig.addImport("parseBytesToLong", new MethodStub(TbUtils.class.getMethod("parseBytesToLong", List.class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesToLong", new MethodStub(TbUtils.class.getMethod("parseBytesToLong", List.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseBytesToLong", new MethodStub(TbUtils.class.getMethod("parseBytesToLong", byte[].class)));
        parserConfig.addImport("parseBytesToLong", new MethodStub(TbUtils.class.getMethod("parseBytesToLong", byte[].class, Integer.TYPE)));
        parserConfig.addImport("parseBytesToLong", new MethodStub(TbUtils.class.getMethod("parseBytesToLong", byte[].class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesToLong", new MethodStub(TbUtils.class.getMethod("parseBytesToLong", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseLittleEndianHexToFloat", new MethodStub(TbUtils.class.getMethod("parseLittleEndianHexToFloat", String.class)));
        parserConfig.addImport("parseBigEndianHexToFloat", new MethodStub(TbUtils.class.getMethod("parseBigEndianHexToFloat", String.class)));
        parserConfig.addImport("parseHexToFloat", new MethodStub(TbUtils.class.getMethod("parseHexToFloat", String.class)));
        parserConfig.addImport("parseHexToFloat", new MethodStub(TbUtils.class.getMethod("parseHexToFloat", String.class, Boolean.TYPE)));
        parserConfig.addImport("parseBytesToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesToFloat", List.class)));
        parserConfig.addImport("parseBytesToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesToFloat", List.class, Integer.TYPE)));
        parserConfig.addImport("parseBytesToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesToFloat", List.class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesToFloat", List.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseBytesToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesToFloat", byte[].class)));
        parserConfig.addImport("parseBytesToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesToFloat", byte[].class, Integer.TYPE)));
        parserConfig.addImport("parseBytesToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesToFloat", byte[].class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesToFloat", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseBytesIntToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesIntToFloat", List.class)));
        parserConfig.addImport("parseBytesIntToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesIntToFloat", List.class, Integer.TYPE)));
        parserConfig.addImport("parseBytesIntToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesIntToFloat", List.class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesIntToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesIntToFloat", List.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseBytesIntToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesIntToFloat", byte[].class)));
        parserConfig.addImport("parseBytesIntToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesIntToFloat", byte[].class, Integer.TYPE)));
        parserConfig.addImport("parseBytesIntToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesIntToFloat", byte[].class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesIntToFloat", new MethodStub(TbUtils.class.getMethod("parseBytesIntToFloat", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseLittleEndianHexToDouble", new MethodStub(TbUtils.class.getMethod("parseLittleEndianHexToDouble", String.class)));
        parserConfig.addImport("parseBigEndianHexToDouble", new MethodStub(TbUtils.class.getMethod("parseBigEndianHexToDouble", String.class)));
        parserConfig.addImport("parseHexToDouble", new MethodStub(TbUtils.class.getMethod("parseHexToDouble", String.class)));
        parserConfig.addImport("parseHexToDouble", new MethodStub(TbUtils.class.getMethod("parseHexToDouble", String.class, Boolean.TYPE)));
        parserConfig.addImport("parseBytesToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesToDouble", List.class)));
        parserConfig.addImport("parseBytesToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesToDouble", List.class, Integer.TYPE)));
        parserConfig.addImport("parseBytesToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesToDouble", List.class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesToDouble", List.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseBytesToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesToDouble", byte[].class)));
        parserConfig.addImport("parseBytesToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesToDouble", byte[].class, Integer.TYPE)));
        parserConfig.addImport("parseBytesToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesToDouble", byte[].class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesToDouble", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseBytesLongToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesLongToDouble", List.class)));
        parserConfig.addImport("parseBytesLongToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesLongToDouble", List.class, Integer.TYPE)));
        parserConfig.addImport("parseBytesLongToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesLongToDouble", List.class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesLongToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesLongToDouble", List.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseBytesLongToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesLongToDouble", byte[].class)));
        parserConfig.addImport("parseBytesLongToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesLongToDouble", byte[].class, Integer.TYPE)));
        parserConfig.addImport("parseBytesLongToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesLongToDouble", byte[].class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBytesLongToDouble", new MethodStub(TbUtils.class.getMethod("parseBytesLongToDouble", byte[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("toFixed", new MethodStub(TbUtils.class.getMethod("toFixed", Double.TYPE, Integer.TYPE)));
        parserConfig.addImport("toFixed", new MethodStub(TbUtils.class.getMethod("toFixed", Float.TYPE, Integer.TYPE)));
        parserConfig.addImport("hexToBytes", new MethodStub(TbUtils.class.getMethod("hexToBytes", ExecutionContext.class, String.class)));
        parserConfig.addImport("intToHex", new MethodStub(TbUtils.class.getMethod("intToHex", Integer.class)));
        parserConfig.addImport("intToHex", new MethodStub(TbUtils.class.getMethod("intToHex", Integer.class, Boolean.TYPE)));
        parserConfig.addImport("intToHex", new MethodStub(TbUtils.class.getMethod("intToHex", Integer.class, Boolean.TYPE, Boolean.TYPE)));
        parserConfig.addImport("intToHex", new MethodStub(TbUtils.class.getMethod("intToHex", Integer.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE)));
        parserConfig.addImport("longToHex", new MethodStub(TbUtils.class.getMethod("longToHex", Long.class)));
        parserConfig.addImport("longToHex", new MethodStub(TbUtils.class.getMethod("longToHex", Long.class, Boolean.TYPE)));
        parserConfig.addImport("longToHex", new MethodStub(TbUtils.class.getMethod("longToHex", Long.class, Boolean.TYPE, Boolean.TYPE)));
        parserConfig.addImport("longToHex", new MethodStub(TbUtils.class.getMethod("longToHex", Long.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE)));
        parserConfig.addImport("intLongToRadixString", new MethodStub(TbUtils.class.getMethod("intLongToRadixString", Long.class)));
        parserConfig.addImport("intLongToRadixString", new MethodStub(TbUtils.class.getMethod("intLongToRadixString", Long.class, Integer.TYPE)));
        parserConfig.addImport("intLongToRadixString", new MethodStub(TbUtils.class.getMethod("intLongToRadixString", Long.class, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("intLongToRadixString", new MethodStub(TbUtils.class.getMethod("intLongToRadixString", Long.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE)));
        parserConfig.addImport("floatToHex", new MethodStub(TbUtils.class.getMethod("floatToHex", Float.class)));
        parserConfig.addImport("floatToHex", new MethodStub(TbUtils.class.getMethod("floatToHex", Float.class, Boolean.TYPE)));
        parserConfig.addImport("doubleToHex", new MethodStub(TbUtils.class.getMethod("doubleToHex", Double.class)));
        parserConfig.addImport("doubleToHex", new MethodStub(TbUtils.class.getMethod("doubleToHex", Double.class, Boolean.TYPE)));
        parserConfig.addImport("printUnsignedBytes", new MethodStub(TbUtils.class.getMethod("printUnsignedBytes", ExecutionContext.class, List.class)));
        parserConfig.addImport("base64ToHex", new MethodStub(TbUtils.class.getMethod("base64ToHex", String.class)));
        parserConfig.addImport("hexToBase64", new MethodStub(TbUtils.class.getMethod("hexToBase64", String.class)));
        parserConfig.addImport("base64ToBytes", new MethodStub(TbUtils.class.getMethod("base64ToBytes", String.class)));
        parserConfig.addImport("bytesToBase64", new MethodStub(TbUtils.class.getMethod("bytesToBase64", byte[].class)));
        parserConfig.addImport("bytesToHex", new MethodStub(TbUtils.class.getMethod("bytesToHex", byte[].class)));
        parserConfig.addImport("bytesToHex", new MethodStub(TbUtils.class.getMethod("bytesToHex", ExecutionArrayList.class)));
        parserConfig.addImport("toFlatMap", new MethodStub(TbUtils.class.getMethod("toFlatMap", ExecutionContext.class, Map.class)));
        parserConfig.addImport("toFlatMap", new MethodStub(TbUtils.class.getMethod("toFlatMap", ExecutionContext.class, Map.class, Boolean.TYPE)));
        parserConfig.addImport("toFlatMap", new MethodStub(TbUtils.class.getMethod("toFlatMap", ExecutionContext.class, Map.class, List.class)));
        parserConfig.addImport("toFlatMap", new MethodStub(TbUtils.class.getMethod("toFlatMap", ExecutionContext.class, Map.class, List.class, Boolean.TYPE)));
        parserConfig.addImport("encodeURI", new MethodStub(TbUtils.class.getMethod("encodeURI", String.class)));
        parserConfig.addImport("decodeURI", new MethodStub(TbUtils.class.getMethod("decodeURI", String.class)));
        parserConfig.addImport("raiseError", new MethodStub(TbUtils.class.getMethod("raiseError", String.class)));
        parserConfig.addImport("isBinary", new MethodStub(TbUtils.class.getMethod("isBinary", String.class)));
        parserConfig.addImport("isOctal", new MethodStub(TbUtils.class.getMethod("isOctal", String.class)));
        parserConfig.addImport("isDecimal", new MethodStub(TbUtils.class.getMethod("isDecimal", String.class)));
        parserConfig.addImport("isHexadecimal", new MethodStub(TbUtils.class.getMethod("isHexadecimal", String.class)));
        parserConfig.addImport("bytesToExecutionArrayList", new MethodStub(TbUtils.class.getMethod("bytesToExecutionArrayList", ExecutionContext.class, byte[].class)));
        parserConfig.addImport("padStart", new MethodStub(TbUtils.class.getMethod("padStart", String.class, Integer.TYPE, Character.TYPE)));
        parserConfig.addImport("padEnd", new MethodStub(TbUtils.class.getMethod("padEnd", String.class, Integer.TYPE, Character.TYPE)));
        parserConfig.addImport("parseByteToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseByteToBinaryArray", Byte.TYPE)));
        parserConfig.addImport("parseByteToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseByteToBinaryArray", Byte.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseByteToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseByteToBinaryArray", Byte.TYPE, Integer.TYPE, Boolean.TYPE)));
        parserConfig.addImport("parseBytesToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseBytesToBinaryArray", List.class)));
        parserConfig.addImport("parseBytesToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseBytesToBinaryArray", List.class, Integer.TYPE)));
        parserConfig.addImport("parseBytesToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseBytesToBinaryArray", byte[].class)));
        parserConfig.addImport("parseBytesToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseBytesToBinaryArray", byte[].class)));
        parserConfig.addImport("parseBytesToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseBytesToBinaryArray", byte[].class, Integer.TYPE)));
        parserConfig.addImport("parseLongToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseLongToBinaryArray", Long.TYPE)));
        parserConfig.addImport("parseLongToBinaryArray", new MethodStub(TbUtils.class.getMethod("parseLongToBinaryArray", Long.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBinaryArrayToInt", new MethodStub(TbUtils.class.getMethod("parseBinaryArrayToInt", List.class)));
        parserConfig.addImport("parseBinaryArrayToInt", new MethodStub(TbUtils.class.getMethod("parseBinaryArrayToInt", List.class, Integer.TYPE)));
        parserConfig.addImport("parseBinaryArrayToInt", new MethodStub(TbUtils.class.getMethod("parseBinaryArrayToInt", List.class, Integer.TYPE, Integer.TYPE)));
        parserConfig.addImport("parseBinaryArrayToInt", new MethodStub(TbUtils.class.getMethod("parseBinaryArrayToInt", byte[].class)));
        parserConfig.addImport("parseBinaryArrayToInt", new MethodStub(TbUtils.class.getMethod("parseBinaryArrayToInt", byte[].class, Integer.TYPE)));
        parserConfig.addImport("parseBinaryArrayToInt", new MethodStub(TbUtils.class.getMethod("parseBinaryArrayToInt", byte[].class, Integer.TYPE, Integer.TYPE)));
    }

    public static String btoa(String input) {
        return new String(Base64.getEncoder().encode(input.getBytes()));
    }

    public static String atob(String encoded) {
        return new String(Base64.getDecoder().decode(encoded));
    }

    public static Object decodeToJson(ExecutionContext ctx, List<Byte> bytesList) throws IOException {
        return TbJson.parse(ctx, TbUtils.bytesToString(bytesList));
    }

    public static Object decodeToJson(ExecutionContext ctx, String jsonStr) throws IOException {
        return TbJson.parse(ctx, jsonStr);
    }

    public static String bytesToString(List<?> bytesList) {
        byte[] bytes = TbUtils.bytesFromList(bytesList);
        return new String(bytes);
    }

    public static String bytesToString(List<?> bytesList, String charsetName) throws UnsupportedEncodingException {
        byte[] bytes = TbUtils.bytesFromList(bytesList);
        return new String(bytes, charsetName);
    }

    public static List<Byte> stringToBytes(ExecutionContext ctx, Object str) throws IllegalAccessException {
        if (str instanceof String) {
            byte[] bytes = str.toString().getBytes();
            return TbUtils.bytesToList(ctx, bytes);
        }
        throw new IllegalAccessException("Invalid type parameter [" + str.getClass().getSimpleName() + "]. Expected 'String'");
    }

    public static List<Byte> stringToBytes(ExecutionContext ctx, Object str, String charsetName) throws UnsupportedEncodingException, IllegalAccessException {
        if (str instanceof String) {
            byte[] bytes = str.toString().getBytes(charsetName);
            return TbUtils.bytesToList(ctx, bytes);
        }
        throw new IllegalAccessException("Invalid type parameter [" + str.getClass().getSimpleName() + "]. Expected 'String'");
    }

    private static byte[] bytesFromList(List<?> bytesList) {
        byte[] bytes = new byte[bytesList.size()];
        for (int i = 0; i < bytesList.size(); ++i) {
            Object objectVal = bytesList.get(i);
            if (objectVal instanceof Integer) {
                bytes[i] = TbUtils.isValidIntegerToByte((Integer)objectVal);
                continue;
            }
            if (objectVal instanceof String) {
                bytes[i] = TbUtils.isValidIntegerToByte(TbUtils.parseInt((String)objectVal));
                continue;
            }
            if (objectVal instanceof Byte) {
                bytes[i] = (Byte)objectVal;
                continue;
            }
            throw new NumberFormatException("The value '" + objectVal + "' could not be correctly converted to a byte. Must be a HexDecimal/String/Integer/Byte format !");
        }
        return bytes;
    }

    private static List<Byte> bytesToList(ExecutionContext ctx, byte[] bytes) {
        ExecutionArrayList list = new ExecutionArrayList(ctx);
        for (byte aByte : bytes) {
            list.add(aByte);
        }
        return list;
    }

    public static Integer parseInt(String value) {
        return TbUtils.parseInt(value, 0);
    }

    public static Integer parseInt(String value, int radix) {
        return TbUtils.parseInt(value, radix, true);
    }

    private static Integer parseInt(String value, int radix, boolean bigEndian) {
        String valueP = TbUtils.prepareNumberString(value, bigEndian);
        if (valueP != null) {
            int radixValue = TbUtils.isValidStringAndRadix(valueP, radix, value);
            if (radixValue >= 25 && radixValue <= 36) {
                return (Integer)TbUtils.compareIntLongValueMinMax(valueP, radixValue, Integer.MAX_VALUE, Integer.MIN_VALUE);
            }
            return switch (radixValue) {
                case 2 -> TbUtils.parseBinaryStringAsSignedInteger(valueP);
                case 8, 10, 16 -> Integer.parseInt(valueP, radixValue);
                default -> throw new IllegalArgumentException("Invalid radix: [" + radix + "]");
            };
        }
        return null;
    }

    public static Long parseLong(String value) {
        return TbUtils.parseLong(value, 0);
    }

    public static Long parseLong(String value, int radix) {
        return TbUtils.parseLong(value, radix, true);
    }

    private static Long parseLong(String value, int radix, boolean bigEndian) {
        String valueP = TbUtils.prepareNumberString(value, bigEndian);
        if (valueP != null) {
            int radixValue = TbUtils.isValidStringAndRadix(valueP, radix, value);
            if (radixValue >= 25 && radixValue <= 36) {
                return (Long)TbUtils.compareIntLongValueMinMax(valueP, radixValue, Long.MAX_VALUE, Long.MIN_VALUE);
            }
            return switch (radixValue) {
                case 2 -> TbUtils.parseBinaryStringAsSignedLong(valueP);
                case 8, 10, 16 -> Long.parseLong(valueP, radixValue);
                default -> throw new IllegalArgumentException("Invalid radix: [" + radix + "]");
            };
        }
        return null;
    }

    private static int parseBinaryStringAsSignedInteger(String binaryString) {
        if (binaryString.length() != 32) {
            binaryString = String.format("%32s", binaryString).replace(' ', '0');
        }
        if (binaryString.charAt(0) == '1') {
            String invertedBinaryString = TbUtils.invertBinaryString(binaryString);
            int positiveValue = Integer.parseInt(invertedBinaryString, 2) + 1;
            return -positiveValue;
        }
        return Integer.parseInt(binaryString, 2);
    }

    private static long parseBinaryStringAsSignedLong(String binaryString) {
        if (binaryString.length() != 64) {
            binaryString = String.format("%64s", binaryString).replace(' ', '0');
        }
        if (binaryString.charAt(0) == '1') {
            String invertedBinaryString = TbUtils.invertBinaryString(binaryString);
            long positiveValue = Long.parseLong(invertedBinaryString, 2) + 1L;
            return -positiveValue;
        }
        return Long.parseLong(binaryString, 2);
    }

    private static String invertBinaryString(String binaryString) {
        StringBuilder invertedString = new StringBuilder();
        for (char bit : binaryString.toCharArray()) {
            invertedString.append(bit == '0' ? (char)'1' : '0');
        }
        return invertedString.toString();
    }

    private static int getRadix10_16(String value) {
        int radix;
        int n = radix = TbUtils.isDecimal(value) > 0 ? 10 : TbUtils.isHexadecimal(value);
        if (radix > 0) {
            return radix;
        }
        throw new NumberFormatException("Value: \"" + value + "\" is not numeric or hexDecimal format!");
    }

    public static Float parseFloat(String value) {
        return TbUtils.parseFloat(value, 0);
    }

    public static Float parseFloat(String value, int radix) {
        String valueP = TbUtils.prepareNumberString(value, true);
        if (valueP != null) {
            return TbUtils.parseFloatFromString(value, valueP, radix);
        }
        return null;
    }

    private static Float parseFloatFromString(String value, String valueP, int radix) {
        int radixValue = TbUtils.isValidStringAndRadix(valueP, radix, value);
        if (radixValue == 16) {
            int bits = (int)Long.parseLong(valueP, 16);
            return Float.valueOf(Float.intBitsToFloat(bits));
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    public static Float parseHexIntLongToFloat(String value, boolean bigEndian) {
        int radixValue;
        String valueP = TbUtils.prepareNumberString(value, bigEndian);
        if (valueP != null && (radixValue = TbUtils.isValidStringAndRadix(valueP, 16, value)) == 16) {
            int bits = (int)Long.parseLong(valueP, 16);
            float floatValue = bits;
            return Float.valueOf(floatValue);
        }
        return null;
    }

    public static Double parseDouble(String value) {
        int radix = TbUtils.getRadix10_16(value);
        return TbUtils.parseDouble(value, radix);
    }

    public static Double parseDouble(String value, int radix) {
        return TbUtils.parseDouble(value, radix, true);
    }

    private static Double parseDouble(String value, int radix, boolean bigEndian) {
        String valueP = TbUtils.prepareNumberString(value, bigEndian);
        if (valueP != null) {
            int radixValue = TbUtils.isValidStringAndRadix(valueP, radix, value);
            if (radixValue == 10) {
                return Double.parseDouble(valueP);
            }
            long bits = Long.parseUnsignedLong(valueP, 16);
            return Double.longBitsToDouble(bits);
        }
        return null;
    }

    public static int parseLittleEndianHexToInt(String hex) {
        return TbUtils.parseHexToInt(hex, false);
    }

    public static int parseBigEndianHexToInt(String hex) {
        return TbUtils.parseHexToInt(hex, true);
    }

    public static int parseHexToInt(String hex) {
        return TbUtils.parseHexToInt(hex, true);
    }

    public static Integer parseHexToInt(String value, boolean bigEndian) {
        return TbUtils.parseInt(value, 16, bigEndian);
    }

    public static long parseLittleEndianHexToLong(String hex) {
        return TbUtils.parseHexToLong(hex, false);
    }

    public static long parseBigEndianHexToLong(String hex) {
        return TbUtils.parseHexToLong(hex, true);
    }

    public static long parseHexToLong(String hex) {
        return TbUtils.parseHexToLong(hex, true);
    }

    public static Long parseHexToLong(String value, boolean bigEndian) {
        return TbUtils.parseLong(value, 16, bigEndian);
    }

    public static float parseLittleEndianHexToFloat(String hex) {
        return TbUtils.parseHexToFloat(hex, false).floatValue();
    }

    public static float parseBigEndianHexToFloat(String hex) {
        return TbUtils.parseHexToFloat(hex, true).floatValue();
    }

    public static float parseHexToFloat(String hex) {
        return TbUtils.parseHexToFloat(hex, true).floatValue();
    }

    public static Float parseHexToFloat(String value, boolean bigEndian) {
        String valueP = TbUtils.prepareNumberString(value, bigEndian);
        if (valueP != null) {
            return TbUtils.parseFloatFromString(value, valueP, 16);
        }
        return null;
    }

    public static double parseLittleEndianHexToDouble(String hex) {
        return TbUtils.parseHexToDouble(hex, false);
    }

    public static double parseBigEndianHexToDouble(String hex) {
        return TbUtils.parseHexToDouble(hex, true);
    }

    public static double parseHexToDouble(String hex) {
        return TbUtils.parseHexToDouble(hex, true);
    }

    public static double parseHexToDouble(String value, boolean bigEndian) {
        return TbUtils.parseDouble(value, 16, bigEndian);
    }

    public static ExecutionArrayList<Byte> hexToBytes(ExecutionContext ctx, String value) {
        String hex = TbUtils.prepareNumberString(value, true);
        if (hex == null) {
            throw new IllegalArgumentException("Hex string must be not empty!");
        }
        int len = hex.length();
        if (len % 2 > 0) {
            throw new IllegalArgumentException("Hex string must be even-length.");
        }
        int radix = TbUtils.isHexadecimal(value);
        if (radix != 16) {
            throw new NumberFormatException("Value: \"" + value + "\" is not numeric or hexDecimal format!");
        }
        byte[] data = TbUtils.hexToBytes(hex);
        return TbUtils.bytesToExecutionArrayList(ctx, data);
    }

    public static List<Integer> printUnsignedBytes(ExecutionContext ctx, List<Byte> byteArray) {
        ExecutionArrayList data = new ExecutionArrayList(ctx);
        for (Byte b : byteArray) {
            int unsignedByte = Byte.toUnsignedInt(b);
            data.add((Object)unsignedByte);
        }
        return data;
    }

    public static String intToHex(Integer i) {
        return TbUtils.prepareNumberHexString(i.longValue(), true, false, -1, 8);
    }

    public static String intToHex(Integer i, boolean bigEndian) {
        return TbUtils.prepareNumberHexString(i.longValue(), bigEndian, false, -1, 8);
    }

    public static String intToHex(Integer i, boolean bigEndian, boolean pref) {
        return TbUtils.prepareNumberHexString(i.longValue(), bigEndian, pref, -1, 8);
    }

    public static String intToHex(Integer i, boolean bigEndian, boolean pref, int len) {
        return TbUtils.prepareNumberHexString(i.longValue(), bigEndian, pref, len, 8);
    }

    public static String longToHex(Long l) {
        return TbUtils.prepareNumberHexString(l, true, false, -1, 16);
    }

    public static String longToHex(Long l, boolean bigEndian) {
        return TbUtils.prepareNumberHexString(l, bigEndian, false, -1, 16);
    }

    public static String longToHex(Long l, boolean bigEndian, boolean pref) {
        return TbUtils.prepareNumberHexString(l, bigEndian, pref, -1, 16);
    }

    public static String longToHex(Long l, boolean bigEndian, boolean pref, int len) {
        return TbUtils.prepareNumberHexString(l, bigEndian, pref, len, 16);
    }

    public static String intLongToRadixString(Long number) {
        return TbUtils.intLongToRadixString(number, 10);
    }

    public static String intLongToRadixString(Long number, int radix) {
        return TbUtils.intLongToRadixString(number, radix, true);
    }

    public static String intLongToRadixString(Long number, int radix, boolean bigEndian) {
        return TbUtils.intLongToRadixString(number, radix, bigEndian, false);
    }

    public static String intLongToRadixString(Long number, int radix, boolean bigEndian, boolean pref) {
        if (radix >= 25 && radix <= 36) {
            return Long.toString(number, radix);
        }
        return switch (radix) {
            case 2 -> TbUtils.formatBinary(Long.toBinaryString(number));
            case 8 -> Long.toOctalString(number);
            case 10 -> Long.toString(number);
            case 16 -> TbUtils.prepareNumberHexString(number, bigEndian, pref, -1, -1);
            default -> throw new IllegalArgumentException("Invalid radix: [" + radix + "]");
        };
    }

    private static Number compareIntLongValueMinMax(String valueP, int radix, Number maxValue, Number minValue) {
        boolean isInteger = maxValue.getClass().getSimpleName().equals("Integer");
        try {
            if (isInteger) {
                return Integer.parseInt(valueP, radix);
            }
            return Long.parseLong(valueP, radix);
        }
        catch (NumberFormatException e) {
            long minValueL;
            long maxValueL;
            BigInteger bi = new BigInteger(valueP, radix);
            long l = maxValueL = isInteger ? maxValue.longValue() : ((Long)maxValue).longValue();
            if (bi.compareTo(BigInteger.valueOf(maxValueL)) > 0) {
                throw new NumberFormatException("Value \"" + valueP + "\"is greater than the maximum " + maxValue.getClass().getSimpleName() + " value " + maxValue + " !");
            }
            long l2 = minValueL = isInteger ? minValue.longValue() : ((Long)minValue).longValue();
            if (bi.compareTo(BigInteger.valueOf(minValueL)) < 0) {
                throw new NumberFormatException("Value \"" + valueP + "\" is  less than the minimum " + minValue.getClass().getSimpleName() + " value " + minValue + " !");
            }
            throw new NumberFormatException(e.getMessage());
        }
    }

    private static String prepareNumberHexString(Long number, boolean bigEndian, boolean pref, int len, int hexLenMax) {
        String hex = Long.toHexString(number).toUpperCase();
        hexLenMax = hexLenMax < 0 ? hex.length() : hexLenMax;
        String hexWithoutZeroFF = TbUtils.removeLeadingZero_FF(hex, number, hexLenMax);
        hexWithoutZeroFF = bigEndian ? hexWithoutZeroFF : TbUtils.reverseHexStringByOrder(hexWithoutZeroFF);
        len = len == -1 ? hexWithoutZeroFF.length() : len;
        String result = hexWithoutZeroFF.substring(hexWithoutZeroFF.length() - len);
        return pref ? "0x" + result : result;
    }

    private static String removeLeadingZero_FF(String hex, Long number, int hexLenMax) {
        Object hexWithoutZero = hex.replaceFirst("^0+(?!$)", "");
        Object object = hexWithoutZero = ((String)hexWithoutZero).length() % 2 > 0 ? "0" + (String)hexWithoutZero : hexWithoutZero;
        if (number >= 0L) {
            return hexWithoutZero;
        }
        Object hexWithoutZeroFF = ((String)hexWithoutZero).replaceFirst("^F+(?!$)", "");
        Object object2 = hexWithoutZeroFF = ((String)hexWithoutZeroFF).length() % 2 > 0 ? "F" + (String)hexWithoutZeroFF : hexWithoutZeroFF;
        if (((String)hexWithoutZeroFF).length() > hexLenMax) {
            return ((String)hexWithoutZeroFF).substring(((String)hexWithoutZeroFF).length() - hexLenMax);
        }
        if (((String)hexWithoutZeroFF).length() == hexLenMax) {
            return hexWithoutZeroFF;
        }
        return "FF" + (String)hexWithoutZeroFF;
    }

    public static String floatToHex(Float f) {
        return TbUtils.floatToHex(f, true);
    }

    public static String floatToHex(Float f, boolean bigEndian) {
        int bits = Float.floatToIntBits(f.floatValue());
        String result = String.format("0x%08X", bits);
        return bigEndian ? result : TbUtils.reverseHexStringByOrder(result);
    }

    public static String doubleToHex(Double d) {
        return TbUtils.doubleToHex(d, true);
    }

    public static String doubleToHex(Double d, boolean bigEndian) {
        long bits = Double.doubleToRawLongBits(d);
        String result = String.format("0x%016X", bits);
        return bigEndian ? result : TbUtils.reverseHexStringByOrder(result);
    }

    public static String base64ToHex(String base64) {
        return TbUtils.bytesToHex(Base64.getDecoder().decode(base64));
    }

    public static String hexToBase64(String hex) {
        return TbUtils.bytesToBase64(TbUtils.hexToBytes(hex));
    }

    public static String bytesToBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] base64ToBytes(String input) {
        return Base64.getDecoder().decode(input);
    }

    public static int parseBytesToInt(List<Byte> data) {
        return TbUtils.parseBytesToInt(data, 0);
    }

    public static int parseBytesToInt(List<Byte> data, int offset) {
        return TbUtils.parseBytesToInt(data, offset, TbUtils.validateLength(data.size(), offset, 4));
    }

    public static int parseBytesToInt(List<Byte> data, int offset, int length) {
        return TbUtils.parseBytesToInt(data, offset, length, true);
    }

    public static int parseBytesToInt(List<Byte> data, int offset, int length, boolean bigEndian) {
        return TbUtils.parseBytesToInt(Bytes.toArray(data), offset, length, bigEndian);
    }

    public static int parseBytesToInt(byte[] data) {
        return TbUtils.parseBytesToInt(data, 0);
    }

    public static int parseBytesToInt(byte[] data, int offset) {
        return TbUtils.parseBytesToInt(data, offset, TbUtils.validateLength(data.length, offset, 4));
    }

    public static int parseBytesToInt(byte[] data, int offset, int length) {
        return TbUtils.parseBytesToInt(data, offset, length, true);
    }

    public static int parseBytesToInt(byte[] data, int offset, int length, boolean bigEndian) {
        TbUtils.validationNumberByLength(data, offset, length, 4);
        ByteBuffer bb = ByteBuffer.allocate(4);
        if (!bigEndian) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        bb.position(bigEndian ? 4 - length : 0);
        bb.put(data, offset, length);
        bb.position(0);
        return bb.getInt();
    }

    public static long parseBytesToLong(List<Byte> data) {
        return TbUtils.parseBytesToLong(data, 0);
    }

    public static long parseBytesToLong(List<Byte> data, int offset) {
        return TbUtils.parseBytesToLong(data, offset, TbUtils.validateLength(data.size(), offset, 8));
    }

    public static long parseBytesToLong(List<Byte> data, int offset, int length) {
        return TbUtils.parseBytesToLong(data, offset, length, true);
    }

    public static long parseBytesToLong(List<Byte> data, int offset, int length, boolean bigEndian) {
        return TbUtils.parseBytesToLong(Bytes.toArray(data), offset, length, bigEndian);
    }

    public static long parseBytesToLong(byte[] data) {
        return TbUtils.parseBytesToLong(data, 0);
    }

    public static long parseBytesToLong(byte[] data, int offset) {
        return TbUtils.parseBytesToLong(data, offset, TbUtils.validateLength(data.length, offset, 8));
    }

    public static long parseBytesToLong(byte[] data, int offset, int length) {
        return TbUtils.parseBytesToLong(data, offset, length, true);
    }

    public static long parseBytesToLong(byte[] data, int offset, int length, boolean bigEndian) {
        TbUtils.validationNumberByLength(data, offset, length, 8);
        ByteBuffer bb = ByteBuffer.allocate(8);
        if (!bigEndian) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        bb.position(bigEndian ? 8 - length : 0);
        bb.put(data, offset, length);
        bb.position(0);
        return bb.getLong();
    }

    public static float parseBytesToFloat(List data) {
        return TbUtils.parseBytesToFloat(data, 0);
    }

    public static float parseBytesToFloat(List data, int offset) {
        return TbUtils.parseBytesToFloat(data, offset, TbUtils.validateLength(data.size(), offset, 4));
    }

    public static float parseBytesToFloat(List data, int offset, int length) {
        return TbUtils.parseBytesToFloat(data, offset, length, true);
    }

    public static float parseBytesToFloat(List data, int offset, int length, boolean bigEndian) {
        return TbUtils.parseBytesToFloat(Bytes.toArray((Collection)data), offset, length, bigEndian);
    }

    public static float parseBytesToFloat(byte[] data) {
        return TbUtils.parseBytesToFloat(data, 0);
    }

    public static float parseBytesToFloat(byte[] data, int offset) {
        return TbUtils.parseBytesToFloat(data, offset, TbUtils.validateLength(data.length, offset, 4));
    }

    public static float parseBytesToFloat(byte[] data, int offset, int length) {
        return TbUtils.parseBytesToFloat(data, offset, length, true);
    }

    public static float parseBytesToFloat(byte[] data, int offset, int length, boolean bigEndian) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        if (!bigEndian) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        bb.position(bigEndian ? 4 - length : 0);
        bb.put(data, offset, length);
        bb.position(0);
        float floatValue = bb.getFloat();
        if (Float.isNaN(floatValue)) {
            throw new NumberFormatException("byte[] 0x" + TbUtils.bytesToHex(data) + " is a Not-a-Number (NaN) value");
        }
        return floatValue;
    }

    public static float parseBytesIntToFloat(List data) {
        return TbUtils.parseBytesIntToFloat(data, 0);
    }

    public static float parseBytesIntToFloat(List data, int offset) {
        return TbUtils.parseBytesIntToFloat(data, offset, TbUtils.validateLength(data.size(), offset, 4));
    }

    public static float parseBytesIntToFloat(List data, int offset, int length) {
        return TbUtils.parseBytesIntToFloat(data, offset, length, true);
    }

    public static float parseBytesIntToFloat(List data, int offset, int length, boolean bigEndian) {
        return TbUtils.parseBytesIntToFloat(Bytes.toArray((Collection)data), offset, length, bigEndian);
    }

    public static float parseBytesIntToFloat(byte[] data) {
        return TbUtils.parseBytesIntToFloat(data, 0);
    }

    public static float parseBytesIntToFloat(byte[] data, int offset) {
        return TbUtils.parseBytesIntToFloat(data, offset, TbUtils.validateLength(data.length, offset, 4));
    }

    public static float parseBytesIntToFloat(byte[] data, int offset, int length) {
        return TbUtils.parseBytesIntToFloat(data, offset, length, true);
    }

    public static float parseBytesIntToFloat(byte[] data, int offset, int length, boolean bigEndian) {
        byte[] bytesToNumber = TbUtils.prepareBytesToNumber(data, offset, length, bigEndian, 4);
        long longValue = TbUtils.parseBytesToLong(bytesToNumber, 0, length);
        BigDecimal bigDecimalValue = new BigDecimal(longValue);
        return bigDecimalValue.floatValue();
    }

    public static double parseBytesToDouble(List data) {
        return TbUtils.parseBytesToDouble(data, 0);
    }

    public static double parseBytesToDouble(List data, int offset) {
        return TbUtils.parseBytesToDouble(data, offset, TbUtils.validateLength(data.size(), offset, 8));
    }

    public static double parseBytesToDouble(List data, int offset, int length) {
        return TbUtils.parseBytesToDouble(data, offset, length, true);
    }

    public static double parseBytesToDouble(List data, int offset, int length, boolean bigEndian) {
        return TbUtils.parseBytesToDouble(Bytes.toArray((Collection)data), offset, length, bigEndian);
    }

    public static double parseBytesToDouble(byte[] data) {
        return TbUtils.parseBytesToDouble(data, 0);
    }

    public static double parseBytesToDouble(byte[] data, int offset) {
        return TbUtils.parseBytesToDouble(data, offset, TbUtils.validateLength(data.length, offset, 8));
    }

    public static double parseBytesToDouble(byte[] data, int offset, int length) {
        return TbUtils.parseBytesToDouble(data, offset, length, true);
    }

    public static double parseBytesToDouble(byte[] data, int offset, int length, boolean bigEndian) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        if (!bigEndian) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        bb.position(bigEndian ? 8 - length : 0);
        bb.put(data, offset, length);
        bb.position(0);
        double doubleValue = bb.getDouble();
        if (Double.isNaN(doubleValue)) {
            throw new NumberFormatException("byte[] 0x" + TbUtils.bytesToHex(data) + " is a Not-a-Number (NaN) value");
        }
        return doubleValue;
    }

    public static double parseBytesLongToDouble(List data) {
        return TbUtils.parseBytesLongToDouble(data, 0);
    }

    public static double parseBytesLongToDouble(List data, int offset) {
        return TbUtils.parseBytesLongToDouble(data, offset, TbUtils.validateLength(data.size(), offset, 8));
    }

    public static double parseBytesLongToDouble(List data, int offset, int length) {
        return TbUtils.parseBytesLongToDouble(data, offset, length, true);
    }

    public static double parseBytesLongToDouble(List data, int offset, int length, boolean bigEndian) {
        return TbUtils.parseBytesLongToDouble(Bytes.toArray((Collection)data), offset, length, bigEndian);
    }

    public static double parseBytesLongToDouble(byte[] data) {
        return TbUtils.parseBytesLongToDouble(data, 0);
    }

    public static double parseBytesLongToDouble(byte[] data, int offset) {
        return TbUtils.parseBytesLongToDouble(data, offset, TbUtils.validateLength(data.length, offset, 8));
    }

    public static double parseBytesLongToDouble(byte[] data, int offset, int length) {
        return TbUtils.parseBytesLongToDouble(data, offset, length, true);
    }

    public static double parseBytesLongToDouble(byte[] data, int offset, int length, boolean bigEndian) {
        byte[] bytesToNumber = TbUtils.prepareBytesToNumber(data, offset, length, bigEndian, 8);
        BigInteger bigInt = new BigInteger(1, bytesToNumber);
        BigDecimal bigDecimalValue = new BigDecimal(bigInt);
        return bigDecimalValue.doubleValue();
    }

    private static byte[] prepareBytesToNumber(byte[] data, int offset, int length, boolean bigEndian, int bytesLenMax) {
        TbUtils.validationNumberByLength(data, offset, length, bytesLenMax);
        byte[] dataBytesArray = Arrays.copyOfRange(data, offset, offset + length);
        if (!bigEndian) {
            ArrayUtils.reverse((byte[])dataBytesArray);
        }
        return dataBytesArray;
    }

    public static String bytesToHex(ExecutionArrayList<?> bytesList) {
        byte[] bytes = new byte[bytesList.size()];
        for (int i = 0; i < bytesList.size(); ++i) {
            bytes[i] = Byte.parseByte(bytesList.get(i).toString());
        }
        return TbUtils.bytesToHex(bytes);
    }

    public static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static double toFixed(double value, int precision) {
        return BigDecimal.valueOf(value).setScale(precision, RoundingMode.HALF_UP).doubleValue();
    }

    public static float toFixed(float value, int precision) {
        return BigDecimal.valueOf(value).setScale(precision, RoundingMode.HALF_UP).floatValue();
    }

    public static ExecutionHashMap<String, Object> toFlatMap(ExecutionContext ctx, Map<String, Object> json) {
        return TbUtils.toFlatMap(ctx, json, new ArrayList<String>(), true);
    }

    public static ExecutionHashMap<String, Object> toFlatMap(ExecutionContext ctx, Map<String, Object> json, boolean pathInKey) {
        return TbUtils.toFlatMap(ctx, json, new ArrayList<String>(), pathInKey);
    }

    public static ExecutionHashMap<String, Object> toFlatMap(ExecutionContext ctx, Map<String, Object> json, List<String> excludeList) {
        return TbUtils.toFlatMap(ctx, json, excludeList, true);
    }

    public static ExecutionHashMap<String, Object> toFlatMap(ExecutionContext ctx, Map<String, Object> json, List<String> excludeList, boolean pathInKey) {
        ExecutionHashMap map = new ExecutionHashMap(16, ctx);
        TbUtils.parseRecursive(json, (Map<String, Object>)map, excludeList, "", pathInKey);
        return map;
    }

    public static String encodeURI(String uri) {
        String encoded = URLEncoder.encode(uri, StandardCharsets.UTF_8);
        for (Map.Entry<String, String> entry : mdnEncodingReplacements.entrySet()) {
            encoded = encoded.replaceAll(entry.getKey(), entry.getValue());
        }
        return encoded;
    }

    public static String decodeURI(String uri) {
        ArrayList<String> allKeys = new ArrayList<String>(mdnEncodingReplacements.keySet());
        Collections.reverse(allKeys);
        for (String strKey : allKeys) {
            uri = uri.replaceAll(mdnEncodingReplacements.get(strKey), strKey);
        }
        return URLDecoder.decode(uri, StandardCharsets.UTF_8);
    }

    public static void raiseError(String message) {
        throw new RuntimeException(message);
    }

    private static void parseRecursive(Object json, Map<String, Object> map, List<String> excludeList, String path, boolean pathInKey) {
        if (json instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)json;
            if (StringUtils.isNotBlank((String)path)) {
                path = (String)path + ".";
            }
            if (excludeList.contains(entry.getKey())) {
                return;
            }
            path = (String)path + entry.getKey();
            json = entry.getValue();
        }
        if (json instanceof Set || json instanceof List) {
            String arrayPath = (String)path + ".";
            Object[] collection = ((Collection)json).toArray();
            for (int index = 0; index < collection.length; ++index) {
                TbUtils.parseRecursive(collection[index], map, excludeList, arrayPath + index, pathInKey);
            }
        } else if (json instanceof Map) {
            Map node = (Map)json;
            for (Map.Entry entry : node.entrySet()) {
                TbUtils.parseRecursive(entry, map, excludeList, (String)path, pathInKey);
            }
        } else if (pathInKey) {
            map.put((String)path, json);
        } else {
            String key = ((String)path).substring(((String)path).lastIndexOf(46) + 1);
            if (StringUtils.isNumeric((String)key)) {
                int pos = ((String)path).length();
                for (int i = 0; i < 2; ++i) {
                    pos = ((String)path).lastIndexOf(46, pos - 1);
                }
                key = ((String)path).substring(pos + 1);
            }
            map.put(key, json);
        }
    }

    private static String prepareNumberString(String value, boolean bigEndian) {
        if (StringUtils.isNotBlank((String)value)) {
            value = value.trim();
            value = value.replace("0x", "");
            value = value.replace("0X", "");
            value = value.replace(",", ".");
            return bigEndian ? value : TbUtils.reverseHexStringByOrder(value);
        }
        return null;
    }

    private static int isValidStringAndRadix(String valueP, int radix, String value) {
        int radixValue;
        if (radix == 0) {
            radixValue = TbUtils.getRadix10_16(valueP);
        } else {
            if (radix >= 25 && radix <= 36) {
                return radix;
            }
            radixValue = switch (radix) {
                case 2 -> TbUtils.isBinary(valueP);
                case 8 -> TbUtils.isOctal(valueP);
                case 10 -> TbUtils.isDecimal(valueP);
                case 16 -> TbUtils.isHexadecimal(valueP);
                default -> throw new IllegalArgumentException("Invalid radix: [" + radix + "]");
            };
        }
        if (radixValue > 0) {
            if (value.startsWith("0x")) {
                radixValue = 16;
            }
            if (radixValue == 16) {
                String string = valueP = value.startsWith("-") ? value.substring(1) : value;
                if (valueP.length() % 2 > 0) {
                    throw new NumberFormatException("The hexadecimal value: \"" + value + "\" must be of even length, or if the decimal value must be a number!");
                }
            }
            return radixValue;
        }
        if (radix > 0) {
            throw new NumberFormatException("Failed radix [" + radix + "] for value: \"" + value + "\", must be [" + radixValue + "] !");
        }
        throw new NumberFormatException("Invalid \"" + value + "\". It is not numeric or hexadecimal format!");
    }

    public static int isBinary(String str) {
        if (str == null || str.isEmpty()) {
            return -1;
        }
        return str.matches("[01]+") ? 2 : -1;
    }

    public static int isOctal(String str) {
        if (str == null || str.isEmpty()) {
            return -1;
        }
        return str.matches("[0-7]+") ? 8 : -1;
    }

    public static int isDecimal(String str) {
        if (str == null || str.isEmpty()) {
            return -1;
        }
        return str.matches("[+-]?\\d+(\\.\\d+)?") ? 10 : -1;
    }

    public static int isHexadecimal(String str) {
        if (str == null || str.isEmpty()) {
            return -1;
        }
        return str.matches("^-?(0[xX])?[0-9a-fA-F]+$") ? 16 : -1;
    }

    public static ExecutionArrayList<Byte> bytesToExecutionArrayList(ExecutionContext ctx, byte[] byteArray) {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        for (byte b : byteArray) {
            byteList.add(b);
        }
        ExecutionArrayList list = new ExecutionArrayList(byteList, ctx);
        return list;
    }

    public static String padStart(String str, int targetLength, char padString) {
        while (((String)str).length() < targetLength) {
            str = padString + (String)str;
        }
        return str;
    }

    public static String padEnd(String str, int targetLength, char padString) {
        while (((String)str).length() < targetLength) {
            str = (String)str + padString;
        }
        return str;
    }

    public static byte[] parseByteToBinaryArray(byte byteValue) {
        return TbUtils.parseByteToBinaryArray(byteValue, 8);
    }

    public static byte[] parseByteToBinaryArray(byte byteValue, int binLength) {
        return TbUtils.parseByteToBinaryArray(byteValue, binLength, true);
    }

    public static byte[] parseByteToBinaryArray(byte byteValue, int binLength, boolean bigEndian) {
        byte[] bins = new byte[binLength];
        for (int i = 0; i < binLength; ++i) {
            if (bigEndian) {
                bins[binLength - 1 - i] = (byte)(byteValue >> i & 1);
                continue;
            }
            bins[i] = (byte)(byteValue >> i & 1);
        }
        return bins;
    }

    public static byte[] parseBytesToBinaryArray(List listValue) {
        return TbUtils.parseBytesToBinaryArray(listValue, listValue.size() * 8);
    }

    public static byte[] parseBytesToBinaryArray(List listValue, int binLength) {
        return TbUtils.parseBytesToBinaryArray(Bytes.toArray((Collection)listValue), binLength);
    }

    public static byte[] parseBytesToBinaryArray(byte[] bytesValue) {
        return TbUtils.parseLongToBinaryArray(TbUtils.parseBytesToLong(bytesValue), bytesValue.length * 8);
    }

    public static byte[] parseBytesToBinaryArray(byte[] bytesValue, int binLength) {
        return TbUtils.parseLongToBinaryArray(TbUtils.parseBytesToLong(bytesValue), binLength);
    }

    public static byte[] parseLongToBinaryArray(long longValue) {
        return TbUtils.parseLongToBinaryArray(longValue, 64);
    }

    public static byte[] parseLongToBinaryArray(long longValue, int binLength) {
        int len = Math.min(binLength, 64);
        byte[] bins = new byte[len];
        for (int i = 0; i < len; ++i) {
            bins[len - 1 - i] = (byte)(longValue >> i & 1L);
        }
        return bins;
    }

    public static int parseBinaryArrayToInt(List listValue) {
        return TbUtils.parseBinaryArrayToInt(listValue, 0);
    }

    public static int parseBinaryArrayToInt(List listValue, int offset) {
        return TbUtils.parseBinaryArrayToInt(listValue, offset, listValue.size());
    }

    public static int parseBinaryArrayToInt(List listValue, int offset, int length) {
        return TbUtils.parseBinaryArrayToInt(Bytes.toArray((Collection)listValue), offset, length);
    }

    public static int parseBinaryArrayToInt(byte[] bytesValue) {
        return TbUtils.parseBinaryArrayToInt(bytesValue, 0);
    }

    public static int parseBinaryArrayToInt(byte[] bytesValue, int offset) {
        return TbUtils.parseBinaryArrayToInt(bytesValue, offset, bytesValue.length);
    }

    public static int parseBinaryArrayToInt(byte[] bytesValue, int offset, int length) {
        int result = 0;
        int len = Math.min(length + offset, bytesValue.length);
        for (int i = offset; i < len; ++i) {
            result = result << 1 | bytesValue[i] & 1;
        }
        if (bytesValue.length == 8 && offset == 0 && bytesValue[0] == 1) {
            result -= 1 << len - offset;
        }
        return result;
    }

    private static byte isValidIntegerToByte(Integer val) {
        if (val > 255 || val < -128) {
            throw new NumberFormatException("The value '" + val + "' could not be correctly converted to a byte. Integer to byte conversion requires the use of only 8 bits (with a range of min/max = -128/255)!");
        }
        return val.byteValue();
    }

    private static String reverseHexStringByOrder(String value) {
        String hex;
        if (value.startsWith("-")) {
            throw new IllegalArgumentException("The hexadecimal string must be without a negative sign.");
        }
        boolean isHexPref = value.startsWith("0x");
        String string = hex = isHexPref ? value.substring(2) : value;
        if (hex.length() % 2 > 0) {
            throw new IllegalArgumentException("The hexadecimal string must be even-length.");
        }
        StringBuilder reversedHex = new StringBuilder(8);
        for (int i = hex.length() - 2; i >= 0; i -= 2) {
            reversedHex.append(hex, i, i + 2);
        }
        String result = reversedHex.toString();
        return isHexPref ? "0x" + result : result;
    }

    private static void validationNumberByLength(byte[] data, int offset, int length, int bytesLenMax) {
        if (offset > data.length) {
            throw new IllegalArgumentException("Offset: " + offset + " is out of bounds for array with length: " + data.length + "!");
        }
        if (offset + length > data.length) {
            throw new IllegalArgumentException("Offset: " + offset + " and Length: " + length + " is out of bounds for array with length: " + data.length + "!");
        }
        if (length > bytesLenMax) {
            throw new IllegalArgumentException("Length: " + length + " is too large. Maximum " + bytesLenMax + " bytes is allowed!");
        }
    }

    private static int validateLength(int dataLength, int offset, int bytesLenMax) {
        return dataLength < offset ? dataLength : Math.min(dataLength - offset, bytesLenMax);
    }

    private static String formatBinary(String binaryString) {
        int format = binaryString.length() < 8 ? 8 : (binaryString.length() < 16 ? 16 : (binaryString.length() < 32 ? 32 : (binaryString.length() < 64 ? 64 : 0)));
        return format == 0 ? binaryString : String.format("%" + format + "s", binaryString).replace(' ', '0');
    }

    private static byte[] hexToBytes(String hex) {
        byte[] data = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); i += 2) {
            byte byteValue;
            String byteString = hex.substring(i, i + 2);
            data[i / 2] = byteValue = (byte)Integer.parseInt(byteString, 16);
        }
        return data;
    }

    static {
        mdnEncodingReplacements.put("\\+", "%20");
        mdnEncodingReplacements.put("%21", "!");
        mdnEncodingReplacements.put("%27", "'");
        mdnEncodingReplacements.put("%28", "\\(");
        mdnEncodingReplacements.put("%29", "\\)");
        mdnEncodingReplacements.put("%7E", "~");
        mdnEncodingReplacements.put("%3B", ";");
        mdnEncodingReplacements.put("%2C", ",");
        mdnEncodingReplacements.put("%2F", "/");
        mdnEncodingReplacements.put("%3F", "\\?");
        mdnEncodingReplacements.put("%3A", ":");
        mdnEncodingReplacements.put("%40", "@");
        mdnEncodingReplacements.put("%26", "&");
        mdnEncodingReplacements.put("%3D", "=");
        mdnEncodingReplacements.put("%2B", "\\+");
        mdnEncodingReplacements.put("%24", Matcher.quoteReplacement("$"));
        mdnEncodingReplacements.put("%23", "#");
    }
}

