/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api.tbel;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.mvel2.ExecutionContext;
import org.mvel2.util.ArgsRepackUtil;
import org.thingsboard.common.util.JacksonUtil;

public class TbJson {
    public static String stringify(Object value) {
        return value != null ? JacksonUtil.toString((Object)value) : "null";
    }

    public static Object parse(ExecutionContext ctx, String value) throws IOException {
        if (value != null) {
            JsonNode node = JacksonUtil.toJsonNode((String)value);
            if (node.isObject()) {
                return ArgsRepackUtil.repack((ExecutionContext)ctx, (Object)JacksonUtil.convertValue((Object)node, Map.class));
            }
            if (node.isArray()) {
                return ArgsRepackUtil.repack((ExecutionContext)ctx, (Object)JacksonUtil.convertValue((Object)node, List.class));
            }
            if (node.isDouble()) {
                return node.doubleValue();
            }
            if (node.isLong()) {
                return node.longValue();
            }
            if (node.isInt()) {
                return node.intValue();
            }
            if (node.isBoolean()) {
                return node.booleanValue();
            }
            if (node.isTextual()) {
                return node.asText();
            }
            if (node.isBinary()) {
                return node.binaryValue();
            }
            if (node.isNull()) {
                return null;
            }
            return node.asText();
        }
        return null;
    }
}

