/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api.tbel;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.function.BiFunction;
import org.mvel2.ConversionException;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.script.api.tbel.DateTimeFormatOptions;
import org.thingsboard.server.common.data.StringUtils;

public class TbDate
implements Serializable,
Cloneable {
    private Instant instant;
    private static final ZoneId zoneIdUTC = ZoneId.of("UTC");
    private static final Locale localeUTC = Locale.forLanguageTag("UTC");
    private static final DateTimeFormatter isoDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd[[ ]['T']HH:mm[:ss[.SSS]][ ][XXX][Z][z][VV][O]]").withZone(ZoneId.systemDefault());

    public TbDate() {
        this.instant = Instant.now();
    }

    public TbDate(String s) {
        this.instant = TbDate.parseInstant(s);
    }

    public TbDate(String s, String pattern) {
        this.instant = TbDate.parseInstant(s, Locale.getDefault().toLanguageTag(), pattern);
    }

    public TbDate(String s, String pattern, String locale) {
        this.instant = TbDate.parseInstant(s, locale, pattern);
    }

    public TbDate(String s, String pattern, String locale, String zoneId) {
        this.instant = TbDate.parseInstant(s, pattern, locale, zoneId);
    }

    public TbDate(String s, String pattern, Locale locale, ZoneId zoneId) {
        this.instant = TbDate.parseInstant(s, pattern, locale, zoneId);
    }

    public TbDate(long dateMilliSecond) {
        this.instant = Instant.ofEpochMilli(dateMilliSecond);
    }

    public TbDate(int year, int month, int date) {
        this(year, month, date, 0, 0, 0, 0, null);
    }

    public TbDate(int year, int month, int date, String tz) {
        this(year, month, date, 0, 0, 0, 0, tz);
    }

    public TbDate(int year, int month, int date, int hrs, int min) {
        this(year, month, date, hrs, min, 0, 0, null);
    }

    public TbDate(int year, int month, int date, int hrs, int min, String tz) {
        this(year, month, date, hrs, min, 0, 0, tz);
    }

    public TbDate(int year, int month, int date, int hrs, int min, int second) {
        this(year, month, date, hrs, min, second, 0, null);
    }

    public TbDate(int year, int month, int date, int hrs, int min, int second, String tz) {
        this(year, month, date, hrs, min, second, 0, tz);
    }

    public TbDate(int year, int month, int date, int hrs, int min, int second, int milliSecond) {
        this(year, month, date, hrs, min, second, milliSecond, null);
    }

    public TbDate(int year, int month, int date, int hrs, int min, int second, int milliSecond, String tz) {
        ZoneId zoneId = tz != null && tz.length() > 0 ? ZoneId.of(tz) : ZoneId.systemDefault();
        this.instant = TbDate.parseInstant(year, month, date, hrs, min, second, milliSecond, zoneId);
    }

    public Instant getInstant() {
        return this.instant;
    }

    public ZonedDateTime getZonedDateTime() {
        return this.getZonedDateTime(zoneIdUTC);
    }

    public ZonedDateTime getZonedDateTime(ZoneId zoneId) {
        return this.instant.atZone(zoneId);
    }

    public LocalDateTime getLocalDateTime() {
        return LocalDateTime.ofInstant(this.instant, ZoneId.systemDefault());
    }

    public LocalDateTime getUTCDateTime() {
        return LocalDateTime.ofInstant(this.instant, zoneIdUTC);
    }

    public String toDateString() {
        return this.toDateString(localeUTC.getLanguage());
    }

    public String toDateString(String locale) {
        return this.toDateString(locale, ZoneId.systemDefault().toString());
    }

    public String toDateString(String localeStr, String optionsStr) {
        return this.toLocaleString(localeStr, optionsStr, (locale, options) -> DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).withLocale((Locale)locale));
    }

    public String toTimeString() {
        return this.toTimeString(Locale.getDefault().getLanguage());
    }

    public String toTimeString(String locale) {
        return this.toTimeString(locale, ZoneId.systemDefault().toString());
    }

    public String toTimeString(String localeStr, String optionsStr) {
        return this.toLocaleString(localeStr, optionsStr, (locale, options) -> DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL).withLocale((Locale)locale));
    }

    public String toISOString() {
        return this.instant.toString();
    }

    public String toJSON() {
        return this.toISOString();
    }

    public String toUTCString() {
        return this.toUTCString(localeUTC.getLanguage());
    }

    public String toUTCString(String localeStr) {
        return this.toLocaleString(localeStr, zoneIdUTC.getId(), (locale, options) -> DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.MEDIUM).withLocale((Locale)locale));
    }

    @JsonValue
    public String toString() {
        return this.toString(Locale.getDefault().getLanguage());
    }

    public String toString(String locale) {
        return this.toString(locale, ZoneId.systemDefault().toString());
    }

    public String toString(String localeStr, String optionsStr) {
        return this.toLocaleString(localeStr, optionsStr, (locale, options) -> DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.FULL).withLocale((Locale)locale));
    }

    public String toLocaleDateString() {
        return this.toLocaleDateString(localeUTC.getLanguage());
    }

    public String toLocaleDateString(String localeStr) {
        return this.toLocaleString(localeStr, ZoneId.systemDefault().toString(), (locale, options) -> DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).withLocale((Locale)locale));
    }

    public String toLocaleDateString(String localeStr, String optionsStr) {
        return this.toLocaleString(localeStr, optionsStr, (locale, options) -> DateTimeFormatter.ofLocalizedDate(options.getDateStyle()).withLocale((Locale)locale));
    }

    public String toLocaleTimeString() {
        return this.toLocaleTimeString(Locale.getDefault().getLanguage());
    }

    public String toLocaleTimeString(String localeStr) {
        return this.toLocaleTimeString(localeStr, ZoneId.systemDefault().toString());
    }

    public String toLocaleTimeString(String localeStr, String optionsStr) {
        return this.toLocaleString(localeStr, optionsStr, (locale, options) -> DateTimeFormatter.ofLocalizedTime(options.getTimeStyle()).withLocale((Locale)locale));
    }

    public String toLocaleString() {
        return this.toLocaleString(localeUTC.getLanguage(), ZoneId.systemDefault().toString());
    }

    public String toLocaleString(String locale) {
        return this.toLocaleString(locale, ZoneId.systemDefault().toString());
    }

    public String toLocaleString(String localeStr, String optionsStr) {
        return this.toLocaleString(localeStr, optionsStr, (locale, options) -> DateTimeFormatter.ofLocalizedDateTime(options.getDateStyle(), options.getTimeStyle()).withLocale((Locale)locale));
    }

    public String toLocaleString(String localeStr, String optionsStr, BiFunction<Locale, DateTimeFormatOptions, DateTimeFormatter> formatterBuilder) {
        Locale locale = StringUtils.isNotEmpty((String)localeStr) ? Locale.forLanguageTag(localeStr) : Locale.getDefault();
        DateTimeFormatOptions options = this.getDateFormattingOptions(optionsStr);
        ZonedDateTime zdt = this.getInstant().atZone(options.getTimeZone().toZoneId());
        DateTimeFormatter formatter = StringUtils.isNotEmpty((String)options.getPattern()) ? new DateTimeFormatterBuilder().appendPattern(options.getPattern()).toFormatter(locale) : formatterBuilder.apply(locale, options);
        return formatter.format(zdt);
    }

    private DateTimeFormatOptions getDateFormattingOptions(String optionsStr) {
        DateTimeFormatOptions opt = null;
        if (StringUtils.isNotEmpty((String)optionsStr)) {
            try {
                opt = (DateTimeFormatOptions)JacksonUtil.fromString((String)optionsStr, DateTimeFormatOptions.class);
            }
            catch (IllegalArgumentException iae) {
                opt = new DateTimeFormatOptions(optionsStr);
            }
        }
        if (opt == null) {
            opt = new DateTimeFormatOptions();
        }
        return opt;
    }

    public static long now() {
        return Instant.now().toEpochMilli();
    }

    public long parseSecond() {
        return this.instant.getEpochSecond();
    }

    public long parseSecondMilli() {
        return this.instant.toEpochMilli();
    }

    public static long UTC(int year) {
        return TbDate.UTC(year, 0, 0, 0, 0, 0, 0);
    }

    public static long UTC(int year, int month) {
        return TbDate.UTC(year, month, 0, 0, 0, 0, 0);
    }

    public static long UTC(int year, int month, int date) {
        return TbDate.UTC(year, month, date, 0, 0, 0, 0);
    }

    public static long UTC(int year, int month, int date, int hrs) {
        return TbDate.UTC(year, month, date, hrs, 0, 0, 0);
    }

    public static long UTC(int year, int month, int date, int hrs, int min) {
        return TbDate.UTC(year, month, date, hrs, min, 0, 0);
    }

    public static long UTC(int year, int month, int date, int hrs, int min, int sec) {
        return TbDate.UTC(year, month, date, hrs, min, sec, 0);
    }

    public static long UTC(int year, int month, int date, int hrs, int min, int sec, int ms) {
        year = year == 0 ? (year = 1899) : year;
        month = month == 0 ? (month = 12) : month;
        date = date == 0 ? (date = 31) : date;
        return TbDate.parseInstant(year, month, date, hrs, min, sec, ms, zoneIdUTC).toEpochMilli();
    }

    public int getUTCFullYear() {
        return this.getUTCDateTime().getYear();
    }

    public int getUTCMonth() {
        return this.getUTCDateTime().getMonthValue();
    }

    public int getUTCDate() {
        return this.getUTCDateTime().getDayOfMonth();
    }

    public int getUTCDay() {
        return this.getUTCDateTime().getDayOfWeek().getValue();
    }

    public int getUTCHours() {
        return this.getUTCDateTime().getHour();
    }

    public int getUTCMinutes() {
        return this.getZonedDateTime().getMinute();
    }

    public int getUTCSeconds() {
        return this.getUTCDateTime().getSecond();
    }

    public int getUTCMilliseconds() {
        return this.getUTCDateTime().getNano() / 1000000;
    }

    public void setUTCFullYear(int year) {
        if (this.getUTCDate() > 28) {
            long time = this.getZonedDateTime().withYear(year).withDayOfMonth(1).toInstant().toEpochMilli() + (long)((this.getUTCDate() - 1) * 24 * 60 * 60) * 1000L;
            this.instant = Instant.ofEpochMilli(time);
        } else {
            this.instant = this.getZonedDateTime().withYear(year).toInstant();
        }
    }

    public void setUTCFullYear(int year, int month) {
        if (this.getUTCDate() > 28) {
            long time = this.getZonedDateTime().withYear(year).withMonth(month).withDayOfMonth(1).toInstant().toEpochMilli() + (long)((this.getUTCDate() - 1) * 24 * 60 * 60) * 1000L;
            this.instant = Instant.ofEpochMilli(time);
        } else {
            this.instant = this.getZonedDateTime().withYear(year).withMonth(month).toInstant();
        }
    }

    public void setUTCFullYear(int year, int month, int date) {
        this.instant = this.getZonedDateTime().withYear(year).withMonth(month).withDayOfMonth(date).toInstant();
    }

    public void setUTCMonth(int month) {
        if (this.getUTCDate() > 28) {
            long time = this.getZonedDateTime().withMonth(month).withDayOfMonth(1).toInstant().toEpochMilli() + (long)((this.getUTCDate() - 1) * 24 * 60 * 60) * 1000L;
            this.instant = Instant.ofEpochMilli(time);
        } else {
            this.instant = this.getZonedDateTime().withMonth(month).toInstant();
        }
    }

    public void setUTCMonth(int month, int date) {
        this.instant = this.getZonedDateTime().withMonth(month).withDayOfMonth(date).toInstant();
    }

    public void setUTCDate(int date) {
        this.instant = this.getZonedDateTime().withDayOfMonth(date).toInstant();
    }

    public void setUTCHours(int hrs) {
        this.instant = this.getZonedDateTime().withHour(hrs).toInstant();
    }

    public void setUTCHours(int hrs, int minutes) {
        this.instant = this.getZonedDateTime().withHour(hrs).withMinute(minutes).toInstant();
    }

    public void setUTCHours(int hrs, int minutes, int seconds) {
        this.instant = this.getZonedDateTime().withHour(hrs).withMinute(minutes).withSecond(seconds).toInstant();
    }

    public void setUTCHours(int hrs, int minutes, int seconds, int ms) {
        this.instant = this.getZonedDateTime().withHour(hrs).withMinute(minutes).withSecond(seconds).withNano(ms * 1000000).toInstant();
    }

    public void setUTCMinutes(int minutes) {
        this.instant = this.getZonedDateTime().withMinute(minutes).toInstant();
    }

    public void setUTCMinutes(int minutes, int seconds) {
        this.instant = this.getZonedDateTime().withMinute(minutes).withSecond(seconds).toInstant();
    }

    public void setUTCMinutes(int minutes, int seconds, int ms) {
        this.instant = TbDate.parseInstant(this.getUTCFullYear(), this.getUTCMonth(), this.getUTCDate(), this.getUTCHours(), minutes, seconds, ms, zoneIdUTC);
    }

    public void setUTCSeconds(int seconds) {
        this.instant = this.getZonedDateTime().withSecond(seconds).toInstant();
    }

    public void setUTCSeconds(int seconds, int ms) {
        this.instant = this.getZonedDateTime().withSecond(seconds).withNano(ms * 1000000).toInstant();
    }

    public void setUTCMilliseconds(int ms) {
        this.instant = this.getZonedDateTime().withNano(ms * 1000000).toInstant();
    }

    public int getFullYear() {
        return this.getLocalDateTime().getYear();
    }

    public int getMonth() {
        return this.getLocalDateTime().getMonthValue();
    }

    public int getDate() {
        return this.getLocalDateTime().getDayOfMonth();
    }

    public int getDay() {
        return this.getLocalDateTime().getDayOfWeek().getValue();
    }

    public int getHours() {
        return this.getLocalDateTime().getHour();
    }

    public int getMinutes() {
        return this.getLocalDateTime().getMinute();
    }

    public int getSeconds() {
        return this.getLocalDateTime().getSecond();
    }

    public int getMilliseconds() {
        return this.getLocalDateTime().getNano() / 1000000;
    }

    public long getTime() {
        return this.instant.toEpochMilli();
    }

    public long valueOf() {
        return this.getTime();
    }

    public void setFullYear(int year) {
        Instant instantEpochWithYear = this.getZonedDateTime().withYear(year).toInstant();
        if (this.getDate() > 28) {
            long time = this.getLocalDateTime().withYear(year).withDayOfMonth(1).toInstant(this.getLocaleZoneOffset(instantEpochWithYear)).toEpochMilli() + (long)((this.getDate() - 1) * 24 * 60 * 60) * 1000L;
            this.instant = Instant.ofEpochMilli(time);
        } else {
            this.instant = this.getLocalDateTime().withYear(year).toInstant(this.getLocaleZoneOffset(instantEpochWithYear));
        }
    }

    public void setFullYear(int year, int month) {
        Instant instantEpochWithYear = this.getZonedDateTime().withYear(year).withMonth(month).toInstant();
        if (this.getDate() > 28) {
            long time = this.getLocalDateTime().withYear(year).withMonth(month).withDayOfMonth(1).toInstant(this.getLocaleZoneOffset(instantEpochWithYear)).toEpochMilli() + (long)((this.getDate() - 1) * 24 * 60 * 60) * 1000L;
            this.instant = Instant.ofEpochMilli(time);
        } else {
            this.instant = this.getLocalDateTime().withYear(year).withMonth(month).toInstant(this.getLocaleZoneOffset(instantEpochWithYear));
        }
    }

    public void setFullYear(int year, int month, int date) {
        Instant instantEpochWithYearMonthDate = this.getZonedDateTime().withYear(year).withMonth(month).withDayOfMonth(date).toInstant();
        this.instant = this.getLocalDateTime().withYear(year).withMonth(month).withDayOfMonth(date).toInstant(this.getLocaleZoneOffset(instantEpochWithYearMonthDate));
    }

    public void setMonth(int month) {
        Instant instantEpochWithYear = this.getZonedDateTime().withMonth(month).toInstant();
        if (this.getDate() > 28) {
            long time = this.getLocalDateTime().withMonth(month).withDayOfMonth(1).toInstant(this.getLocaleZoneOffset(instantEpochWithYear)).toEpochMilli() + (long)((this.getDate() - 1) * 24 * 60 * 60) * 1000L;
            this.instant = Instant.ofEpochMilli(time);
        } else {
            this.instant = this.getLocalDateTime().withMonth(month).toInstant(this.getLocaleZoneOffset(instantEpochWithYear));
        }
    }

    public void setMonth(int month, int date) {
        Instant instantEpochWithMonthDate = this.getZonedDateTime().withMonth(month).withDayOfMonth(date).toInstant();
        this.instant = this.getLocalDateTime().withMonth(month).withDayOfMonth(date).toInstant(this.getLocaleZoneOffset(instantEpochWithMonthDate));
    }

    public void setDate(int date) {
        Instant instantEpochWithDate = this.getZonedDateTime().withDayOfMonth(date).toInstant();
        this.instant = this.getLocalDateTime().withDayOfMonth(date).toInstant(this.getLocaleZoneOffset(instantEpochWithDate));
    }

    public void setHours(int hrs) {
        this.instant = this.getLocalDateTime().withHour(hrs).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setHours(int hrs, int minutes) {
        this.instant = this.getLocalDateTime().withHour(hrs).withMinute(minutes).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setHours(int hrs, int minutes, int seconds) {
        this.instant = this.getLocalDateTime().withHour(hrs).withMinute(minutes).withSecond(seconds).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setHours(int hrs, int minutes, int seconds, int ms) {
        this.instant = this.getLocalDateTime().withHour(hrs).withMinute(minutes).withSecond(seconds).withNano(ms * 1000000).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setMinutes(int minutes) {
        this.instant = this.getLocalDateTime().withMinute(minutes).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setMinutes(int minutes, int seconds) {
        this.instant = this.getLocalDateTime().withMinute(minutes).withSecond(seconds).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setMinutes(int minutes, int seconds, int ms) {
        this.instant = this.getLocalDateTime().withMinute(minutes).withSecond(seconds).withNano(ms * 1000000).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setSeconds(int seconds) {
        this.instant = this.getLocalDateTime().withSecond(seconds).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setSeconds(int seconds, int ms) {
        this.instant = this.getLocalDateTime().withSecond(seconds).withNano(ms * 1000000).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setMilliseconds(int ms) {
        this.instant = this.getLocalDateTime().withNano(ms * 1000000).toInstant(this.getLocaleZoneOffset(this.instant));
    }

    public void setTime(long dateMilliSecond) {
        this.instant = Instant.ofEpochMilli(dateMilliSecond);
    }

    public ZoneOffset getLocaleZoneOffset(Instant ... instants) {
        return ZoneId.systemDefault().getRules().getOffset(instants.length > 0 ? instants[0] : this.instant);
    }

    public static long parse(String value, String format) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            return dateFormat.parse(value).getTime();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static long parse(String value) {
        try {
            TemporalAccessor accessor = isoDateFormatter.parseBest(value, ZonedDateTime::from, LocalDateTime::from, LocalDate::from);
            Instant instant = Instant.from(accessor);
            return Instant.EPOCH.until(instant, ChronoUnit.MILLIS);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static Instant parseInstant(String s) {
        boolean isIsoFormat;
        boolean bl = isIsoFormat = s.length() > 0 && Character.isDigit(s.charAt(0));
        if (isIsoFormat) {
            return TbDate.getInstant_ISO_OFFSET_DATE_TIME(s);
        }
        return TbDate.getInstant_RFC_1123(s);
    }

    private static Instant parseInstant(String s, String localeStr, String pattern) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.forLanguageTag(localeStr));
            return Instant.from(formatter.parse(s));
        }
        catch (Exception ex) {
            try {
                return TbDate.parseInstant(s, pattern, localeStr, ZoneId.systemDefault().getId());
            }
            catch (DateTimeParseException e) {
                ConversionException exception = new ConversionException("Cannot parse value [" + s + "] as instant", (Throwable)ex);
                throw exception;
            }
        }
    }

    private static Instant parseInstant(int year, int month, int date, int hrs, int min, int second, int secondMilli, ZoneId zoneId) {
        year = year < 70 ? 2000 + year : (year <= 99 ? 1900 + year : year);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(year, month, date, hrs, min, second, secondMilli * 1000000, zoneId);
        return zonedDateTime.toInstant();
    }

    private static Instant parseInstant(String s, String pattern, String localeStr, String zoneIdStr) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern, Locale.forLanguageTag(localeStr));
        LocalDateTime localDateTime = LocalDateTime.parse(s, dateTimeFormatter);
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.of(zoneIdStr));
        return zonedDateTime.toInstant();
    }

    private static Instant getInstant_ISO_OFFSET_DATE_TIME(String s) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        try {
            return Instant.from(formatter.parse(s));
        }
        catch (DateTimeParseException ex) {
            try {
                long timeMS = TbDate.parse(s);
                if (timeMS != -1L) {
                    return Instant.ofEpochMilli(timeMS);
                }
                throw new ConversionException("Cannot parse value [" + s + "] as instant");
            }
            catch (DateTimeParseException e) {
                throw new ConversionException("Cannot parse value [" + s + "] as instant");
            }
        }
    }

    private static Instant getInstant_RFC_1123(String s) {
        DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME;
        try {
            return Instant.from(formatter.parse(s));
        }
        catch (DateTimeParseException ex) {
            try {
                return TbDate.getInstantWithLocalZoneOffsetId_RFC_1123(s);
            }
            catch (DateTimeParseException e) {
                throw new ConversionException("Cannot parse value [" + s + "] as instant");
            }
        }
    }

    private static Instant getInstantWithLocalZoneOffsetId_RFC_1123(String value) {
        String s = ((String)value).trim() + " GMT";
        Instant instant = Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(s));
        ZoneId systemZone = ZoneId.systemDefault();
        String id = systemZone.getRules().getOffset(instant).getId();
        value = ((String)value).trim() + " " + id.replaceAll(":", "");
        return Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse((CharSequence)value));
    }

    private static Instant parseInstant(String s, String pattern, Locale locale, ZoneId zoneId) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern, locale);
        LocalDateTime localDateTime = LocalDateTime.parse(s, dateTimeFormatter);
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        return zonedDateTime.toInstant();
    }
}

