/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api.tbel;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mvel2.ExecutionContext;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.SandboxedParserConfiguration;
import org.mvel2.ScriptMemoryOverflowException;
import org.mvel2.optimizers.OptimizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.script.api.AbstractScriptInvokeService;
import org.thingsboard.script.api.ScriptType;
import org.thingsboard.script.api.TbScriptException;
import org.thingsboard.script.api.tbel.TbDate;
import org.thingsboard.script.api.tbel.TbJson;
import org.thingsboard.script.api.tbel.TbUtils;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.script.api.tbel.TbelScript;
import org.thingsboard.script.api.tbel.TbelScriptExecutionTask;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.common.stats.TbApiUsageStateClient;

@ConditionalOnProperty(prefix="tbel", value={"enabled"}, havingValue="true", matchIfMissing=true)
@Service
public class DefaultTbelInvokeService
extends AbstractScriptInvokeService
implements TbelInvokeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTbelInvokeService.class);
    protected final Map<UUID, String> scriptIdToHash = new ConcurrentHashMap<UUID, String>();
    protected final Map<String, TbelScript> scriptMap = new ConcurrentHashMap<String, TbelScript>();
    protected Cache<String, Serializable> compiledScriptsCache;
    private SandboxedParserConfiguration parserConfig;
    private final Optional<TbApiUsageStateClient> apiUsageStateClient;
    private final Optional<TbApiUsageReportClient> apiUsageReportClient;
    @Value(value="${tbel.max_total_args_size:100000}")
    private long maxTotalArgsSize;
    @Value(value="${tbel.max_result_size:300000}")
    private long maxResultSize;
    @Value(value="${tbel.max_script_body_size:50000}")
    private long maxScriptBodySize;
    @Value(value="${tbel.max_errors:3}")
    private int maxErrors;
    @Value(value="${tbel.max_black_list_duration_sec:60}")
    private int maxBlackListDurationSec;
    @Value(value="${tbel.max_requests_timeout:0}")
    private long maxInvokeRequestsTimeout;
    @Value(value="${tbel.stats.enabled:false}")
    private boolean statsEnabled;
    @Value(value="${tbel.thread_pool_size:50}")
    private int threadPoolSize;
    @Value(value="${tbel.max_memory_limit_mb:8}")
    private long maxMemoryLimitMb;
    @Value(value="${tbel.compiled_scripts_cache_size:1000}")
    private int compiledScriptsCacheSize;
    private ListeningExecutorService executor;
    private final Lock lock = new ReentrantLock();

    protected DefaultTbelInvokeService(Optional<TbApiUsageStateClient> apiUsageStateClient, Optional<TbApiUsageReportClient> apiUsageReportClient) {
        this.apiUsageStateClient = apiUsageStateClient;
        this.apiUsageReportClient = apiUsageReportClient;
    }

    @Override
    @Scheduled(fixedDelayString="${tbel.stats.print_interval_ms:10000}")
    public void printStats() {
        super.printStats();
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        this.parserConfig = ParserContext.enableSandboxedMode();
        this.parserConfig.addImport("JSON", TbJson.class);
        this.parserConfig.registerDataType("Date", TbDate.class, date -> 8L);
        this.parserConfig.registerDataType("Random", Random.class, date -> 8L);
        this.parserConfig.registerDataType("Calendar", Calendar.class, date -> 8L);
        TbUtils.register((ParserConfiguration)this.parserConfig);
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)this.threadPoolSize, (String)"tbel-executor"));
        try {
            Serializable script = this.compileScript("var warmUp = {}; warmUp");
            MVEL.executeTbExpression((Object)script, (ExecutionContext)new ExecutionContext(this.parserConfig), Collections.emptyMap());
        }
        catch (Exception script) {
            // empty catch block
        }
        this.compiledScriptsCache = Caffeine.newBuilder().maximumSize((long)this.compiledScriptsCacheSize).build();
    }

    @Override
    @PreDestroy
    public void stop() {
        super.stop();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    protected String getStatsName() {
        return "TBEL Scripts Stats";
    }

    @Override
    protected Executor getCallbackExecutor() {
        return MoreExecutors.directExecutor();
    }

    @Override
    protected boolean isScriptPresent(UUID scriptId) {
        return this.scriptIdToHash.containsKey(scriptId);
    }

    @Override
    protected boolean isExecEnabled(TenantId tenantId) {
        return !this.apiUsageStateClient.isPresent() || this.apiUsageStateClient.get().getApiUsageState(tenantId).isTbelExecEnabled();
    }

    @Override
    protected void reportExecution(TenantId tenantId, CustomerId customerId) {
        this.apiUsageReportClient.ifPresent(client -> client.report(tenantId, customerId, ApiUsageRecordKey.TBEL_EXEC_COUNT, 1L));
    }

    @Override
    protected ListenableFuture<UUID> doEvalScript(TenantId tenantId, ScriptType scriptType, String scriptBody, UUID scriptId, String[] argNames) {
        return this.executor.submit(() -> {
            try {
                String scriptHash = this.hash(scriptBody, argNames);
                this.compiledScriptsCache.get((Object)scriptHash, k -> this.compileScript(scriptBody));
                this.lock.lock();
                try {
                    this.scriptIdToHash.put(scriptId, scriptHash);
                    this.scriptMap.computeIfAbsent(scriptHash, k -> new TbelScript(scriptBody, argNames));
                }
                finally {
                    this.lock.unlock();
                }
                return scriptId;
            }
            catch (Exception e) {
                throw new TbScriptException(scriptId, TbScriptException.ErrorCode.COMPILATION, scriptBody, e);
            }
        });
    }

    @Override
    protected TbelScriptExecutionTask doInvokeFunction(UUID scriptId, Object[] args) {
        ExecutionContext executionContext = new ExecutionContext(this.parserConfig, this.maxMemoryLimitMb * 1024L * 1024L);
        return new TbelScriptExecutionTask(executionContext, (ListenableFuture<Object>)this.executor.submit(() -> {
            String scriptHash = this.scriptIdToHash.get(scriptId);
            if (scriptHash == null) {
                throw new TbScriptException(scriptId, TbScriptException.ErrorCode.OTHER, null, new RuntimeException("Script not found!"));
            }
            TbelScript script = this.scriptMap.get(scriptHash);
            Serializable compiledScript = (Serializable)this.compiledScriptsCache.get((Object)scriptHash, k -> this.compileScript(script.getScriptBody()));
            try {
                return MVEL.executeTbExpression((Object)compiledScript, (ExecutionContext)executionContext, (Map)script.createVars(args));
            }
            catch (ScriptMemoryOverflowException e) {
                throw new TbScriptException(scriptId, TbScriptException.ErrorCode.OTHER, script.getScriptBody(), new RuntimeException("Script memory overflow!"));
            }
            catch (Exception e) {
                throw new TbScriptException(scriptId, TbScriptException.ErrorCode.RUNTIME, script.getScriptBody(), e);
            }
        }));
    }

    @Override
    protected void doRelease(UUID scriptId) {
        String scriptHash = this.scriptIdToHash.remove(scriptId);
        if (scriptHash != null) {
            this.lock.lock();
            try {
                if (!this.scriptIdToHash.containsValue(scriptHash)) {
                    this.scriptMap.remove(scriptHash);
                    this.compiledScriptsCache.invalidate((Object)scriptHash);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private Serializable compileScript(String scriptBody) {
        return MVEL.compileExpression((String)scriptBody, (ParserContext)new ParserContext());
    }

    protected String hash(String scriptBody, String[] argNames) {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        hasher.putUnencodedChars((CharSequence)scriptBody);
        for (String argName : argNames) {
            hasher.putString((CharSequence)argName, StandardCharsets.UTF_8);
        }
        return hasher.hash().toString();
    }

    @Override
    protected long getMaxEvalRequestsTimeout() {
        return this.maxInvokeRequestsTimeout * 2L;
    }

    @Override
    public long getMaxTotalArgsSize() {
        return this.maxTotalArgsSize;
    }

    @Override
    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    @Override
    public long getMaxScriptBodySize() {
        return this.maxScriptBodySize;
    }

    @Override
    public int getMaxErrors() {
        return this.maxErrors;
    }

    @Override
    public int getMaxBlackListDurationSec() {
        return this.maxBlackListDurationSec;
    }

    @Override
    public long getMaxInvokeRequestsTimeout() {
        return this.maxInvokeRequestsTimeout;
    }

    @Override
    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }
}

