/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api.tbel;

import java.time.format.FormatStyle;
import java.util.TimeZone;
import org.thingsboard.server.common.data.StringUtils;

class DateTimeFormatOptions {
    private static final TimeZone DEFAULT_TZ = TimeZone.getDefault();
    private String timeZone;
    private String dateStyle;
    private String timeStyle;
    private String pattern;

    public DateTimeFormatOptions(String timeZone) {
        this.timeZone = timeZone;
    }

    TimeZone getTimeZone() {
        return StringUtils.isNotEmpty((String)this.timeZone) ? TimeZone.getTimeZone(this.timeZone) : TimeZone.getDefault();
    }

    FormatStyle getDateStyle() {
        return DateTimeFormatOptions.getFormatStyle(this.dateStyle, FormatStyle.SHORT);
    }

    FormatStyle getTimeStyle() {
        return DateTimeFormatOptions.getFormatStyle(this.timeStyle, FormatStyle.MEDIUM);
    }

    private static FormatStyle getFormatStyle(String style, FormatStyle defaultStyle) {
        if (StringUtils.isNotEmpty((String)style)) {
            try {
                return FormatStyle.valueOf(style.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return defaultStyle;
            }
        }
        return defaultStyle;
    }

    public DateTimeFormatOptions() {
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setDateStyle(String dateStyle) {
        this.dateStyle = dateStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this.timeStyle = timeStyle;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateTimeFormatOptions)) {
            return false;
        }
        DateTimeFormatOptions other = (DateTimeFormatOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TimeZone this$timeZone = this.getTimeZone();
        TimeZone other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        FormatStyle this$dateStyle = this.getDateStyle();
        FormatStyle other$dateStyle = other.getDateStyle();
        if (this$dateStyle == null ? other$dateStyle != null : !((Object)((Object)this$dateStyle)).equals((Object)other$dateStyle)) {
            return false;
        }
        FormatStyle this$timeStyle = this.getTimeStyle();
        FormatStyle other$timeStyle = other.getTimeStyle();
        if (this$timeStyle == null ? other$timeStyle != null : !((Object)((Object)this$timeStyle)).equals((Object)other$timeStyle)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DateTimeFormatOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        FormatStyle $dateStyle = this.getDateStyle();
        result = result * 59 + ($dateStyle == null ? 43 : ((Object)((Object)$dateStyle)).hashCode());
        FormatStyle $timeStyle = this.getTimeStyle();
        result = result * 59 + ($timeStyle == null ? 43 : ((Object)((Object)$timeStyle)).hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        return result;
    }

    public String toString() {
        return "DateTimeFormatOptions(timeZone=" + this.getTimeZone() + ", dateStyle=" + this.getDateStyle() + ", timeStyle=" + this.getTimeStyle() + ", pattern=" + this.getPattern() + ")";
    }

    public String getPattern() {
        return this.pattern;
    }
}

