/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api.js;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import delight.nashornsandbox.NashornSandbox;
import delight.nashornsandbox.NashornSandboxes;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.script.api.TbScriptException;
import org.thingsboard.script.api.js.AbstractJsInvokeService;
import org.thingsboard.script.api.js.JsScriptInfo;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.common.stats.TbApiUsageStateClient;

@ConditionalOnProperty(prefix="js", value={"evaluator"}, havingValue="local", matchIfMissing=true)
@Service
public class NashornJsInvokeService
extends AbstractJsInvokeService {
    private static final Logger log = LoggerFactory.getLogger(NashornJsInvokeService.class);
    private NashornSandbox sandbox;
    private ScriptEngine engine;
    private ExecutorService monitorExecutorService;
    private ListeningExecutorService jsExecutor;
    private final ReentrantLock evalLock = new ReentrantLock();
    @Value(value="${js.local.use_js_sandbox}")
    private boolean useJsSandbox;
    @Value(value="${js.local.monitor_thread_pool_size}")
    private int monitorThreadPoolSize;
    @Value(value="${js.local.max_cpu_time:8000}")
    private long maxCpuTime;
    @Value(value="${js.local.max_memory:104857600}")
    private long maxMemory;
    @Value(value="${js.local.max_errors}")
    private int maxErrors;
    @Value(value="${js.local.max_black_list_duration_sec:60}")
    private int maxBlackListDurationSec;
    @Value(value="${js.local.max_requests_timeout:0}")
    private long maxInvokeRequestsTimeout;
    @Value(value="${js.local.stats.enabled:false}")
    private boolean statsEnabled;
    @Value(value="${js.local.js_thread_pool_size:50}")
    private int jsExecutorThreadPoolSize;

    public NashornJsInvokeService(Optional<TbApiUsageStateClient> apiUsageStateClient, Optional<TbApiUsageReportClient> apiUsageReportClient) {
        super(apiUsageStateClient, apiUsageReportClient);
    }

    @Override
    protected String getStatsName() {
        return "Nashorn JS Invoke Stats";
    }

    @Override
    protected Executor getCallbackExecutor() {
        return MoreExecutors.directExecutor();
    }

    @Override
    @Scheduled(fixedDelayString="${js.local.stats.print_interval_ms:10000}")
    public void printStats() {
        super.printStats();
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.jsExecutor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)this.jsExecutorThreadPoolSize, (String)"nashorn-js-executor"));
        if (this.useJsSandbox) {
            this.sandbox = NashornSandboxes.create();
            this.monitorExecutorService = ThingsBoardExecutors.newWorkStealingPool((int)this.monitorThreadPoolSize, (String)"nashorn-js-monitor");
            this.sandbox.setExecutor(this.monitorExecutorService);
            this.sandbox.setMaxCPUTime(this.maxCpuTime);
            this.sandbox.setMaxMemory(this.maxMemory);
            this.sandbox.allowNoBraces(false);
            this.sandbox.allowLoadFunctions(true);
            this.sandbox.setMaxPreparedStatements(30);
        } else {
            ScriptEngineManager factory = new ScriptEngineManager();
            this.engine = factory.getEngineByName("nashorn");
        }
    }

    @Override
    @PreDestroy
    public void stop() {
        super.stop();
        if (this.monitorExecutorService != null) {
            this.monitorExecutorService.shutdownNow();
        }
        if (this.jsExecutor != null) {
            this.jsExecutor.shutdownNow();
        }
    }

    @Override
    protected ListenableFuture<UUID> doEval(UUID scriptId, JsScriptInfo scriptInfo, String jsScript) {
        return this.jsExecutor.submit(() -> {
            try {
                this.evalLock.lock();
                try {
                    if (this.useJsSandbox) {
                        this.sandbox.eval(jsScript);
                    } else {
                        this.engine.eval(jsScript);
                    }
                }
                finally {
                    this.evalLock.unlock();
                }
                this.scriptInfoMap.put(scriptId, scriptInfo);
                return scriptId;
            }
            catch (Exception e) {
                throw new TbScriptException(scriptId, TbScriptException.ErrorCode.COMPILATION, jsScript, e);
            }
        });
    }

    @Override
    protected ListenableFuture<Object> doInvokeFunction(UUID scriptId, JsScriptInfo scriptInfo, Object[] args) {
        return this.jsExecutor.submit(() -> {
            try {
                if (this.useJsSandbox) {
                    return this.sandbox.getSandboxedInvocable().invokeFunction(scriptInfo.getFunctionName(), args);
                }
                return ((Invocable)((Object)this.engine)).invokeFunction(scriptInfo.getFunctionName(), args);
            }
            catch (ScriptException e) {
                throw new TbScriptException(scriptId, TbScriptException.ErrorCode.RUNTIME, null, e);
            }
            catch (Exception e) {
                throw new TbScriptException(scriptId, TbScriptException.ErrorCode.OTHER, null, e);
            }
        });
    }

    @Override
    protected void doRelease(UUID scriptId, JsScriptInfo scriptInfo) throws ScriptException {
        if (this.useJsSandbox) {
            this.sandbox.eval(scriptInfo.getFunctionName() + " = undefined;");
        } else {
            this.engine.eval(scriptInfo.getFunctionName() + " = undefined;");
        }
    }

    @Override
    protected boolean isLocal() {
        return true;
    }

    @Override
    public int getMaxErrors() {
        return this.maxErrors;
    }

    @Override
    public int getMaxBlackListDurationSec() {
        return this.maxBlackListDurationSec;
    }

    @Override
    public long getMaxInvokeRequestsTimeout() {
        return this.maxInvokeRequestsTimeout;
    }

    @Override
    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }
}

