/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api.js;

import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.script.api.AbstractScriptInvokeService;
import org.thingsboard.script.api.RuleNodeScriptFactory;
import org.thingsboard.script.api.ScriptType;
import org.thingsboard.script.api.js.AttributesScriptFactory;
import org.thingsboard.script.api.js.DownlinkConverterScriptFactory;
import org.thingsboard.script.api.js.JsInvokeService;
import org.thingsboard.script.api.js.JsScriptExecutionTask;
import org.thingsboard.script.api.js.JsScriptInfo;
import org.thingsboard.script.api.js.UplinkConverterScriptFactory;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.common.stats.TbApiUsageStateClient;

public abstract class AbstractJsInvokeService
extends AbstractScriptInvokeService
implements JsInvokeService {
    private static final Logger log = LoggerFactory.getLogger(AbstractJsInvokeService.class);
    protected final Map<UUID, JsScriptInfo> scriptInfoMap = new ConcurrentHashMap<UUID, JsScriptInfo>();
    private final Optional<TbApiUsageStateClient> apiUsageStateClient;
    private final Optional<TbApiUsageReportClient> apiUsageReportClient;
    @Value(value="${js.max_total_args_size:100000}")
    private long maxTotalArgsSize;
    @Value(value="${js.max_result_size:300000}")
    private long maxResultSize;
    @Value(value="${js.max_script_body_size:50000}")
    private long maxScriptBodySize;

    protected AbstractJsInvokeService(Optional<TbApiUsageStateClient> apiUsageStateClient, Optional<TbApiUsageReportClient> apiUsageReportClient) {
        this.apiUsageStateClient = apiUsageStateClient;
        this.apiUsageReportClient = apiUsageReportClient;
    }

    @Override
    protected boolean isScriptPresent(UUID scriptId) {
        return this.scriptInfoMap.containsKey(scriptId);
    }

    @Override
    protected boolean isExecEnabled(TenantId tenantId) {
        return !this.apiUsageStateClient.isPresent() || this.apiUsageStateClient.get().getApiUsageState(tenantId).isJsExecEnabled();
    }

    @Override
    protected void reportExecution(TenantId tenantId, CustomerId customerId) {
        this.apiUsageReportClient.ifPresent(client -> client.report(tenantId, customerId, ApiUsageRecordKey.JS_EXEC_COUNT, 1L));
    }

    @Override
    protected JsScriptExecutionTask doInvokeFunction(UUID scriptId, Object[] args) {
        return new JsScriptExecutionTask(this.doInvokeFunction(scriptId, this.scriptInfoMap.get(scriptId), args));
    }

    @Override
    protected ListenableFuture<UUID> doEvalScript(TenantId tenantId, ScriptType scriptType, String scriptBody, UUID scriptId, String[] argNames) {
        String scriptHash = this.hash(tenantId, scriptBody);
        String functionName = this.constructFunctionName(scriptId, scriptHash);
        String jsScript = this.generateJsScript(scriptType, functionName, scriptBody, argNames);
        return this.doEval(scriptId, new JsScriptInfo(scriptHash, functionName), jsScript);
    }

    @Override
    protected void doRelease(UUID scriptId) throws Exception {
        this.doRelease(scriptId, this.scriptInfoMap.remove(scriptId));
    }

    protected abstract ListenableFuture<UUID> doEval(UUID var1, JsScriptInfo var2, String var3);

    protected abstract ListenableFuture<Object> doInvokeFunction(UUID var1, JsScriptInfo var2, Object[] var3);

    protected abstract void doRelease(UUID var1, JsScriptInfo var2) throws Exception;

    protected abstract boolean isLocal();

    private String generateJsScript(ScriptType scriptType, String functionName, String scriptBody, String ... argNames) {
        switch (scriptType) {
            case RULE_NODE_SCRIPT: {
                return RuleNodeScriptFactory.generateRuleNodeScript(functionName, scriptBody, argNames);
            }
            case ATTRIBUTES_SCRIPT: {
                return AttributesScriptFactory.generateAttributesScript(functionName, scriptBody);
            }
            case UPLINK_CONVERTER_SCRIPT: {
                return UplinkConverterScriptFactory.generateUplinkConverterScript(functionName, scriptBody, this.isLocal());
            }
            case DOWNLINK_CONVERTER_SCRIPT: {
                return DownlinkConverterScriptFactory.generateDownlinkConverterScript(functionName, scriptBody, this.isLocal());
            }
        }
        throw new RuntimeException("No script factory implemented for scriptType: " + scriptType);
    }

    protected String constructFunctionName(UUID scriptId, String scriptHash) {
        return "invokeInternal_" + scriptId.toString().replace('-', '_');
    }

    protected String hash(TenantId tenantId, String scriptBody) {
        return Hashing.murmur3_128().newHasher().putLong(tenantId.getId().getMostSignificantBits()).putLong(tenantId.getId().getLeastSignificantBits()).putUnencodedChars((CharSequence)scriptBody).hash().toString();
    }

    @Override
    public long getMaxTotalArgsSize() {
        return this.maxTotalArgsSize;
    }

    @Override
    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    @Override
    public long getMaxScriptBodySize() {
        return this.maxScriptBodySize;
    }
}

