/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api;

import com.google.common.util.concurrent.FutureCallback;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptStatCallback<T>
implements FutureCallback<T> {
    private static final Logger log = LoggerFactory.getLogger(ScriptStatCallback.class);
    private final AtomicInteger successMsgs;
    private final AtomicInteger timeoutMsgs;
    private final AtomicInteger failedMsgs;

    public void onSuccess(@Nullable T result) {
        this.successMsgs.incrementAndGet();
    }

    public void onFailure(Throwable t) {
        if (t instanceof TimeoutException || t.getCause() != null && t.getCause() instanceof TimeoutException) {
            this.timeoutMsgs.incrementAndGet();
        } else {
            this.failedMsgs.incrementAndGet();
        }
    }

    @ConstructorProperties(value={"successMsgs", "timeoutMsgs", "failedMsgs"})
    public ScriptStatCallback(AtomicInteger successMsgs, AtomicInteger timeoutMsgs, AtomicInteger failedMsgs) {
        this.successMsgs = successMsgs;
        this.timeoutMsgs = timeoutMsgs;
        this.failedMsgs = failedMsgs;
    }
}

