/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.script.api;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BlockedScriptInfo {
    private final long maxScriptBlockDurationMs;
    private final AtomicInteger counter;
    private long expirationTime;

    BlockedScriptInfo(int maxScriptBlockDuration) {
        this.maxScriptBlockDurationMs = TimeUnit.SECONDS.toMillis(maxScriptBlockDuration);
        this.counter = new AtomicInteger(0);
    }

    public int get() {
        return this.counter.get();
    }

    public int incrementAndGet() {
        int result = this.counter.incrementAndGet();
        this.expirationTime = System.currentTimeMillis() + this.maxScriptBlockDurationMs;
        return result;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }
}

