/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.script;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.script.api.TbScriptException;
import org.thingsboard.script.api.js.AbstractJsInvokeService;
import org.thingsboard.script.api.js.JsScriptInfo;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.common.stats.TbApiUsageStateClient;
import org.thingsboard.server.gen.js.JsInvokeProtos;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueRequestTemplate;
import org.thingsboard.server.queue.common.TbProtoJsQueueMsg;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;

@ConditionalOnExpression(value="'${js.evaluator:null}'=='remote' && ('${service.type:null}'=='monolith' || '${service.type:null}'=='tb-core' || '${service.type:null}'=='tb-rule-engine')")
@Service
public class RemoteJsInvokeService
extends AbstractJsInvokeService {
    private static final Logger log = LoggerFactory.getLogger(RemoteJsInvokeService.class);
    @Value(value="${queue.js.max_eval_requests_timeout}")
    private long maxEvalRequestsTimeout;
    @Value(value="${queue.js.max_requests_timeout}")
    private long maxInvokeRequestsTimeout;
    @Value(value="${queue.js.max_exec_requests_timeout:2000}")
    private long maxExecRequestsTimeout;
    @Value(value="${js.remote.max_errors}")
    private int maxErrors;
    @Value(value="${js.remote.max_black_list_duration_sec:60}")
    private int maxBlackListDurationSec;
    @Value(value="${js.remote.stats.enabled:false}")
    private boolean statsEnabled;
    private final ExecutorService callbackExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)ThingsBoardThreadFactory.forName((String)"js-executor-remote-callback"));
    @Autowired
    protected TbQueueRequestTemplate<TbProtoJsQueueMsg<JsInvokeProtos.RemoteJsRequest>, TbProtoQueueMsg<JsInvokeProtos.RemoteJsResponse>> requestTemplate;
    protected final Map<String, String> scriptHashToBodysMap = new ConcurrentHashMap<String, String>();
    private final Lock scriptsLock = new ReentrantLock();

    public RemoteJsInvokeService(Optional<TbApiUsageStateClient> apiUsageStateClient, Optional<TbApiUsageReportClient> apiUsageClient) {
        super(apiUsageStateClient, apiUsageClient);
    }

    protected Executor getCallbackExecutor() {
        return this.callbackExecutor;
    }

    protected String getStatsName() {
        return "Queue JS Invoke Stats";
    }

    @Scheduled(fixedDelayString="${js.remote.stats.print_interval_ms}")
    public void printStats() {
        super.printStats();
    }

    @PostConstruct
    public void init() {
        super.init();
        this.requestTemplate.init();
    }

    @PreDestroy
    public void stop() {
        super.stop();
        if (this.requestTemplate != null) {
            this.requestTemplate.stop();
        }
        this.callbackExecutor.shutdownNow();
    }

    protected ListenableFuture<UUID> doEval(UUID scriptId, JsScriptInfo jsInfo, String scriptBody) {
        JsInvokeProtos.JsCompileRequest jsRequest = JsInvokeProtos.JsCompileRequest.newBuilder().setScriptHash(jsInfo.getHash()).setFunctionName(jsInfo.getFunctionName()).setScriptBody(scriptBody).build();
        JsInvokeProtos.RemoteJsRequest jsRequestWrapper = JsInvokeProtos.RemoteJsRequest.newBuilder().setCompileRequest(jsRequest).build();
        log.trace("Post compile request for scriptId [{}] (hash: {})", (Object)scriptId, (Object)jsInfo.getHash());
        ListenableFuture future = this.requestTemplate.send((TbQueueMsg)new TbProtoJsQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)jsRequestWrapper));
        return Futures.transform((ListenableFuture)future, response -> {
            JsInvokeProtos.JsCompileResponse compilationResult = ((JsInvokeProtos.RemoteJsResponse)response.getValue()).getCompileResponse();
            if (compilationResult.getSuccess()) {
                this.scriptsLock.lock();
                try {
                    this.scriptInfoMap.put(scriptId, jsInfo);
                    this.scriptHashToBodysMap.put(jsInfo.getHash(), scriptBody);
                }
                finally {
                    this.scriptsLock.unlock();
                }
                return scriptId;
            }
            log.debug("[{}] (hash: {}) Failed to compile script due to [{}]: {}", new Object[]{scriptId, compilationResult.getScriptHash(), compilationResult.getErrorCode().name(), compilationResult.getErrorDetails()});
            throw new TbScriptException(scriptId, TbScriptException.ErrorCode.COMPILATION, scriptBody, (Exception)new RuntimeException(compilationResult.getErrorDetails()));
        }, (Executor)this.callbackExecutor);
    }

    protected ListenableFuture<Object> doInvokeFunction(UUID scriptId, JsScriptInfo jsInfo, Object[] args) {
        StopWatch stopWatch;
        String scriptHash = jsInfo.getHash();
        String scriptBody = this.scriptHashToBodysMap.get(scriptHash);
        if (scriptBody == null) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("No script body found for script hash [" + scriptHash + "] (script id: [" + String.valueOf(scriptId) + "])"));
        }
        JsInvokeProtos.RemoteJsRequest jsRequestWrapper = this.buildJsInvokeRequest(jsInfo, args, false, null);
        if (log.isTraceEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        } else {
            stopWatch = null;
        }
        UUID requestKey = UUID.randomUUID();
        ListenableFuture future = this.requestTemplate.send((TbQueueMsg)new TbProtoJsQueueMsg(requestKey, (GeneratedMessageV3)jsRequestWrapper));
        return Futures.transformAsync((ListenableFuture)future, response -> {
            JsInvokeProtos.JsInvokeResponse invokeResult;
            if (log.isTraceEnabled()) {
                stopWatch.stop();
                log.trace("doInvokeFunction js-response took {}ms for uuid {}", (Object)stopWatch.getTotalTimeMillis(), (Object)response.getKey());
            }
            if ((invokeResult = ((JsInvokeProtos.RemoteJsResponse)response.getValue()).getInvokeResponse()).getSuccess()) {
                return Futures.immediateFuture((Object)invokeResult.getResult());
            }
            return this.handleInvokeError(requestKey, scriptId, jsInfo, invokeResult.getErrorCode(), invokeResult.getErrorDetails(), scriptBody, args);
        }, (Executor)this.callbackExecutor);
    }

    private JsInvokeProtos.RemoteJsRequest buildJsInvokeRequest(JsScriptInfo jsInfo, Object[] args, boolean includeScriptBody, String scriptBody) {
        JsInvokeProtos.JsInvokeRequest.Builder jsRequestBuilder = JsInvokeProtos.JsInvokeRequest.newBuilder().setScriptHash(jsInfo.getHash()).setFunctionName(jsInfo.getFunctionName()).setTimeout((int)this.maxExecRequestsTimeout);
        if (includeScriptBody) {
            jsRequestBuilder.setScriptBody(scriptBody);
        }
        for (Object arg : args) {
            jsRequestBuilder.addArgs(arg.toString());
        }
        JsInvokeProtos.RemoteJsRequest jsRequestWrapper = JsInvokeProtos.RemoteJsRequest.newBuilder().setInvokeRequest(jsRequestBuilder.build()).build();
        return jsRequestWrapper;
    }

    private ListenableFuture<Object> handleInvokeError(UUID requestKey, UUID scriptId, JsScriptInfo jsInfo, JsInvokeProtos.JsInvokeErrorCode errorCode, String errorDetails, String scriptBody, Object[] args) {
        RuntimeException e = new RuntimeException(errorDetails);
        log.debug("[{}] Failed to invoke function due to [{}]: {}", new Object[]{scriptId, errorCode.name(), errorDetails});
        if (JsInvokeProtos.JsInvokeErrorCode.TIMEOUT_ERROR.equals((Object)errorCode)) {
            throw new TbScriptException(scriptId, TbScriptException.ErrorCode.TIMEOUT, scriptBody, (Exception)new TimeoutException());
        }
        if (JsInvokeProtos.JsInvokeErrorCode.COMPILATION_ERROR.equals((Object)errorCode)) {
            throw new TbScriptException(scriptId, TbScriptException.ErrorCode.COMPILATION, scriptBody, (Exception)e);
        }
        if (JsInvokeProtos.JsInvokeErrorCode.NOT_FOUND_ERROR.equals((Object)errorCode)) {
            log.debug("[{}] Remote JS executor couldn't find the script", (Object)scriptId);
            if (scriptBody != null) {
                JsInvokeProtos.RemoteJsRequest invokeRequestWithScriptBody = this.buildJsInvokeRequest(jsInfo, args, true, scriptBody);
                log.debug("[{}] Sending invoke request again with script body", (Object)scriptId);
                ListenableFuture future = this.requestTemplate.send((TbQueueMsg)new TbProtoJsQueueMsg(requestKey, (GeneratedMessageV3)invokeRequestWithScriptBody));
                return Futures.transformAsync((ListenableFuture)future, response -> {
                    JsInvokeProtos.JsInvokeResponse result = ((JsInvokeProtos.RemoteJsResponse)response.getValue()).getInvokeResponse();
                    if (result.getSuccess()) {
                        return Futures.immediateFuture((Object)result.getResult());
                    }
                    return this.handleInvokeError(requestKey, scriptId, jsInfo, result.getErrorCode(), result.getErrorDetails(), null, args);
                }, (Executor)MoreExecutors.directExecutor());
            }
        }
        throw new TbScriptException(scriptId, TbScriptException.ErrorCode.RUNTIME, scriptBody, (Exception)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doRelease(UUID scriptId, JsScriptInfo jsInfo) throws Exception {
        JsInvokeProtos.RemoteJsResponse response;
        JsInvokeProtos.JsReleaseResponse releaseResponse;
        String scriptHash = jsInfo.getHash();
        if (this.scriptInfoMap.values().stream().map(JsScriptInfo::getHash).anyMatch(hash -> hash.equals(scriptHash))) {
            return;
        }
        JsInvokeProtos.JsReleaseRequest jsRequest = JsInvokeProtos.JsReleaseRequest.newBuilder().setScriptHash(scriptHash).setFunctionName(jsInfo.getFunctionName()).build();
        JsInvokeProtos.RemoteJsRequest jsRequestWrapper = JsInvokeProtos.RemoteJsRequest.newBuilder().setReleaseRequest(jsRequest).build();
        ListenableFuture future = this.requestTemplate.send((TbQueueMsg)new TbProtoJsQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)jsRequestWrapper));
        if (this.getMaxInvokeRequestsTimeout() > 0L) {
            future = Futures.withTimeout((ListenableFuture)future, (long)this.getMaxInvokeRequestsTimeout(), (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.timeoutExecutorService);
        }
        if ((releaseResponse = (response = (JsInvokeProtos.RemoteJsResponse)((TbProtoQueueMsg)future.get()).getValue()).getReleaseResponse()).getSuccess()) {
            this.scriptsLock.lock();
            try {
                if (!this.scriptInfoMap.values().stream().map(JsScriptInfo::getHash).noneMatch(hash -> hash.equals(scriptHash))) return;
                this.scriptHashToBodysMap.remove(scriptHash);
                return;
            }
            finally {
                this.scriptsLock.unlock();
            }
        } else {
            log.debug("[{}] Failed to release script", (Object)scriptHash);
        }
    }

    protected String constructFunctionName(UUID scriptId, String scriptHash) {
        return "invokeInternal_" + scriptHash;
    }

    protected String getScriptHash(UUID scriptId) {
        JsScriptInfo jsScriptInfo = (JsScriptInfo)this.scriptInfoMap.get(scriptId);
        return jsScriptInfo != null ? jsScriptInfo.getHash() : null;
    }

    public long getMaxEvalRequestsTimeout() {
        return this.maxEvalRequestsTimeout;
    }

    public long getMaxInvokeRequestsTimeout() {
        return this.maxInvokeRequestsTimeout;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public int getMaxBlackListDurationSec() {
        return this.maxBlackListDurationSec;
    }

    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }
}

