/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.report.context;

import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.rest.client.RestClient;
import org.thingsboard.script.api.tbel.TbelInvokeService;
import org.thingsboard.server.common.data.job.task.ReportTask;
import org.thingsboard.server.common.data.report.configuration.ReportTemplateConfig;
import org.thingsboard.server.report.context.TbReportCtx;
import org.thingsboard.server.report.context.TbReportCtxProvider;
import org.thingsboard.server.report.util.ReportUtils;

@ConditionalOnExpression(value="'${service.type:null}' == 'tb-report'")
@Service
public class RemoteTbReportCtxProvider
implements TbReportCtxProvider {
    @Value(value="${service.tb_core.base_url:http://localhost:${server.port}}")
    private String tbCoreBaseUrl;
    private final TbelInvokeService tbelInvokeService;

    @Override
    public TbReportCtx newContext(ReportTask task) {
        return ((RemoteTbReportCtx.RemoteTbReportCtxBuilder)((TbReportCtx.TbReportCtxBuilder)((RemoteTbReportCtx.RemoteTbReportCtxBuilder)((RemoteTbReportCtx.RemoteTbReportCtxBuilder)((RemoteTbReportCtx.RemoteTbReportCtxBuilder)((RemoteTbReportCtx.RemoteTbReportCtxBuilder)((RemoteTbReportCtx.RemoteTbReportCtxBuilder)((RemoteTbReportCtx.RemoteTbReportCtxBuilder)((RemoteTbReportCtx.RemoteTbReportCtxBuilder)((RemoteTbReportCtx.RemoteTbReportCtxBuilder)RemoteTbReportCtx.builder().tenantId(task.getTenantId())).tbelInvokeService(this.tbelInvokeService)).configuration(task.getReportTemplateConfig())).userId(task.getUserId())).userOwnerId(task.getUserOwnerId())).timeZone(task.getTimezone())).accessToken(task.getAccessToken())).accessTokenExpTs(task.getAccessTokenExpirationTs())).restClient(new RestClient(new RestTemplate(), this.tbCoreBaseUrl, task.getAccessToken()))).reportCreatedTime(ReportUtils.formatTimestamp(System.currentTimeMillis(), task.getReportTemplateConfig().getTimeDataPattern(), task.getTimezone()))).build();
    }

    @ConstructorProperties(value={"tbelInvokeService"})
    @Generated
    public RemoteTbReportCtxProvider(TbelInvokeService tbelInvokeService) {
        this.tbelInvokeService = tbelInvokeService;
    }

    public static class RemoteTbReportCtx
    extends TbReportCtx {
        private final RestClient restClient;

        @Override
        public void close() throws IOException {
            super.close();
            this.restClient.close();
        }

        @Override
        public TbReportCtx createSubReportCxt(ReportTemplateConfig reportTemplateConfig) {
            TbReportCtx copy = ((RemoteTbReportCtxBuilder)((TbReportCtx.TbReportCtxBuilder)((RemoteTbReportCtxBuilder)((RemoteTbReportCtxBuilder)((RemoteTbReportCtxBuilder)((RemoteTbReportCtxBuilder)((RemoteTbReportCtxBuilder)((RemoteTbReportCtxBuilder)((RemoteTbReportCtxBuilder)((RemoteTbReportCtxBuilder)RemoteTbReportCtx.builder().tenantId(this.getTenantId())).tbelInvokeService(this.getTbelInvokeService())).configuration(reportTemplateConfig)).userId(this.getUserId())).userOwnerId(this.getUserOwnerId())).timeZone(this.getTimeZone())).accessToken(this.getAccessToken())).accessTokenExpTs(this.getAccessTokenExpTs())).restClient(this.getRestClient())).reportCreatedTime(this.getReportCreatedTime())).build();
            copy.getParams().putAll(this.getParams());
            return copy;
        }

        @Generated
        protected RemoteTbReportCtx(RemoteTbReportCtxBuilder<?, ?> b) {
            super(b);
            this.restClient = b.restClient;
        }

        @Generated
        public static RemoteTbReportCtxBuilder<?, ?> builder() {
            return new RemoteTbReportCtxBuilderImpl();
        }

        @Generated
        public RestClient getRestClient() {
            return this.restClient;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoteTbReportCtx)) {
                return false;
            }
            RemoteTbReportCtx other = (RemoteTbReportCtx)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RestClient this$restClient = this.getRestClient();
            RestClient other$restClient = other.getRestClient();
            return !(this$restClient == null ? other$restClient != null : !this$restClient.equals(other$restClient));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RemoteTbReportCtx;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RestClient $restClient = this.getRestClient();
            result = result * 59 + ($restClient == null ? 43 : $restClient.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "RemoteTbReportCtxProvider.RemoteTbReportCtx(restClient=" + String.valueOf(this.getRestClient()) + ")";
        }

        @Generated
        public static abstract class RemoteTbReportCtxBuilder<C extends RemoteTbReportCtx, B extends RemoteTbReportCtxBuilder<C, B>>
        extends TbReportCtx.TbReportCtxBuilder<C, B> {
            @Generated
            private RestClient restClient;

            @Generated
            public B restClient(RestClient restClient) {
                this.restClient = restClient;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "RemoteTbReportCtxProvider.RemoteTbReportCtx.RemoteTbReportCtxBuilder(super=" + super.toString() + ", restClient=" + String.valueOf(this.restClient) + ")";
            }
        }

        @Generated
        private static final class RemoteTbReportCtxBuilderImpl
        extends RemoteTbReportCtxBuilder<RemoteTbReportCtx, RemoteTbReportCtxBuilderImpl> {
            @Generated
            private RemoteTbReportCtxBuilderImpl() {
            }

            @Override
            @Generated
            protected RemoteTbReportCtxBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public RemoteTbReportCtx build() {
                return new RemoteTbReportCtx(this);
            }
        }
    }
}

