/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.report.consumer;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.consumer.QueueConsumerManager;
import org.thingsboard.server.queue.provider.TbReportQueueFactory;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.queue.util.TbReportComponent;

@TbReportComponent
@Service
public class TbReportConsumerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbReportConsumerService.class);
    private final TbReportQueueFactory queueFactory;
    private final ApplicationEventPublisher eventPublisher;
    @Value(value="${queue.report.poll_interval:125}")
    private int pollInterval;
    private final ExecutorService consumersExecutor = Executors.newCachedThreadPool((ThreadFactory)ThingsBoardThreadFactory.forName((String)"tb-report-consumer"));
    private QueueConsumerManager<TbProtoQueueMsg<TransportProtos.ToTbReportNotificationMsg>> notificationsConsumer;

    @PostConstruct
    private void init() {
        this.notificationsConsumer = QueueConsumerManager.builder().name("TB Report notifications").threadPrefix("notifications").msgPackProcessor(this::processNotificationMsgs).pollInterval((long)this.pollInterval).consumerCreator(() -> ((TbReportQueueFactory)this.queueFactory).createTbReportNotificationsConsumer()).consumerExecutor(this.consumersExecutor).build();
    }

    @AfterStartUp(order=11)
    public void onApplicationEvent() {
        this.notificationsConsumer.subscribe();
        this.notificationsConsumer.launch();
    }

    private void processNotificationMsgs(List<TbProtoQueueMsg<TransportProtos.ToTbReportNotificationMsg>> msgs, TbQueueConsumer<TbProtoQueueMsg<TransportProtos.ToTbReportNotificationMsg>> consumer) {
        for (TbProtoQueueMsg<TransportProtos.ToTbReportNotificationMsg> queueMsg : msgs) {
            try {
                TransportProtos.ToTbReportNotificationMsg msg = (TransportProtos.ToTbReportNotificationMsg)queueMsg.getValue();
                if (!msg.hasComponentLifecycleMsg()) continue;
                ComponentLifecycleMsg componentLifecycleMsg = ProtoUtils.fromProto((TransportProtos.ComponentLifecycleMsgProto)msg.getComponentLifecycleMsg());
                this.eventPublisher.publishEvent((Object)componentLifecycleMsg);
            }
            catch (Throwable e) {
                log.error("Failed to process notification msg: {}", queueMsg, (Object)e);
            }
        }
    }

    @PreDestroy
    private void destroy() {
        if (this.notificationsConsumer != null) {
            this.notificationsConsumer.stop();
        }
        this.consumersExecutor.shutdownNow();
    }

    @ConstructorProperties(value={"queueFactory", "eventPublisher"})
    @Generated
    public TbReportConsumerService(TbReportQueueFactory queueFactory, ApplicationEventPublisher eventPublisher) {
        this.queueFactory = queueFactory;
        this.eventPublisher = eventPublisher;
    }
}

