/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.report.consumer;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.common.data.job.task.ReportTask;
import org.thingsboard.server.common.data.job.task.ReportTaskResult;
import org.thingsboard.server.common.data.report.Report;
import org.thingsboard.server.queue.task.TaskProcessor;
import org.thingsboard.server.queue.util.TbReportComponent;
import org.thingsboard.server.report.service.TbReportService;

@TbReportComponent
@Component
public class ReportTaskProcessor
extends TaskProcessor<ReportTask, ReportTaskResult> {
    private final TbReportService tbReportService;
    @Value(value="${reports.generation_timeout_ms:120000}")
    private int timeoutMs;

    public ReportTaskResult process(ReportTask task) throws Exception {
        Report report = this.tbReportService.generateReport(task);
        return ReportTaskResult.success((ReportTask)task, (Report)report);
    }

    public long getProcessingTimeout(ReportTask task) {
        return this.timeoutMs;
    }

    public JobType getJobType() {
        return JobType.REPORT;
    }

    @ConstructorProperties(value={"tbReportService"})
    @Generated
    public ReportTaskProcessor(TbReportService tbReportService) {
        this.tbReportService = tbReportService;
    }
}

