/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.thingsboard.server.common.data.StringUtils;

public class PropertyUtils {
    public static Map<String, String> getProps(String properties) {
        HashMap<String, String> configs = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)properties)) {
            for (String property : properties.split(";")) {
                if (!StringUtils.isNotEmpty((String)property)) continue;
                int delimiterPosition = property.indexOf(":");
                String key = property.substring(0, delimiterPosition);
                String value = property.substring(delimiterPosition + 1);
                configs.put(key, value);
            }
        }
        return configs;
    }

    public static Map<String, List<String>> getGroupedProps(String properties) {
        HashMap<String, List<String>> configs = new HashMap<String, List<String>>();
        if (StringUtils.isNotEmpty((String)properties)) {
            for (String property : properties.split(";")) {
                if (!StringUtils.isNotEmpty((String)property)) continue;
                int delimiterPosition = property.indexOf(":");
                String topic = property.substring(0, delimiterPosition).trim();
                String value = property.substring(delimiterPosition + 1).trim();
                configs.computeIfAbsent(topic, k -> new ArrayList()).add(value);
            }
        }
        return configs;
    }

    public static Map<String, String> getProps(Map<String, String> defaultProperties, String propertiesStr) {
        return PropertyUtils.getProps(defaultProperties, propertiesStr, PropertyUtils::getProps);
    }

    public static Map<String, String> getProps(Map<String, String> defaultProperties, String propertiesStr, Function<String, Map<String, String>> parser) {
        HashMap<String, String> properties = new HashMap<String, String>(defaultProperties);
        if (StringUtils.isNotBlank((String)propertiesStr)) {
            properties.putAll(parser.apply(propertiesStr));
        }
        return properties;
    }
}

