/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.task;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.common.util.ThingsBoardThreadFactory;

@Lazy
@Component
public class TaskProcessorExecutors {
    private ExecutorService consumersExecutor;
    private ExecutorService mgmtExecutor;
    private ScheduledExecutorService scheduler;

    @PostConstruct
    private void init() {
        this.consumersExecutor = Executors.newCachedThreadPool((ThreadFactory)ThingsBoardThreadFactory.forName((String)"task-consumer"));
        this.mgmtExecutor = ThingsBoardExecutors.newWorkStealingPool((int)4, (String)"task-consumer-mgmt");
        this.scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"task-consumer-scheduler");
    }

    @PreDestroy
    private void destroy() {
        if (this.consumersExecutor != null) {
            this.consumersExecutor.shutdownNow();
        }
        if (this.mgmtExecutor != null) {
            this.mgmtExecutor.shutdownNow();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    @Generated
    public ExecutorService getConsumersExecutor() {
        return this.consumersExecutor;
    }

    @Generated
    public ExecutorService getMgmtExecutor() {
        return this.mgmtExecutor;
    }

    @Generated
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }
}

