/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.task;

import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.kafka.TbKafkaAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaProducerTemplate;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;
import org.thingsboard.server.queue.kafka.TbKafkaTopicConfigs;
import org.thingsboard.server.queue.task.TaskProducerQueueFactory;

@Component
@ConditionalOnExpression(value="'${queue.type:null}' == 'kafka' && ('${service.type:null}' == 'monolith' || '${service.type:null}' == 'tb-core' || '${service.type:null}' == 'tb-rule-engine')")
public class KafkaTaskProducerQueueFactory
implements TaskProducerQueueFactory {
    private final TopicService topicService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TbKafkaSettings kafkaSettings;
    private final TbQueueAdmin tasksAdmin;

    KafkaTaskProducerQueueFactory(TopicService topicService, TbServiceInfoProvider serviceInfoProvider, TbKafkaSettings kafkaSettings, TbKafkaTopicConfigs kafkaTopicConfigs) {
        this.topicService = topicService;
        this.kafkaSettings = kafkaSettings;
        this.serviceInfoProvider = serviceInfoProvider;
        this.tasksAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getTasksConfigs());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.TaskProto>> createTaskProducer(JobType jobType) {
        return TbKafkaProducerTemplate.builder().clientId(jobType.name().toLowerCase() + "-task-producer-" + this.serviceInfoProvider.getServiceId()).defaultTopic(this.topicService.buildTopicName(jobType.getTasksTopic())).settings(this.kafkaSettings).admin(this.tasksAdmin).build();
    }
}

