/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.task;

import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueAdmin;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.kafka.TbKafkaAdmin;
import org.thingsboard.server.queue.kafka.TbKafkaConsumerStatsService;
import org.thingsboard.server.queue.kafka.TbKafkaConsumerTemplate;
import org.thingsboard.server.queue.kafka.TbKafkaProducerTemplate;
import org.thingsboard.server.queue.kafka.TbKafkaSettings;
import org.thingsboard.server.queue.kafka.TbKafkaTopicConfigs;
import org.thingsboard.server.queue.settings.TasksQueueConfig;
import org.thingsboard.server.queue.task.TaskProcessorQueueFactory;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='kafka'")
public class KafkaTaskProcessorQueueFactory
implements TaskProcessorQueueFactory {
    private final TopicService topicService;
    private final TbServiceInfoProvider serviceInfoProvider;
    private final TasksQueueConfig tasksQueueConfig;
    private final TbKafkaSettings kafkaSettings;
    private final TbKafkaConsumerStatsService consumerStatsService;
    private final TbQueueAdmin tasksAdmin;

    public KafkaTaskProcessorQueueFactory(TopicService topicService, TbServiceInfoProvider serviceInfoProvider, TasksQueueConfig tasksQueueConfig, TbKafkaSettings kafkaSettings, TbKafkaConsumerStatsService consumerStatsService, TbKafkaTopicConfigs kafkaTopicConfigs) {
        this.topicService = topicService;
        this.serviceInfoProvider = serviceInfoProvider;
        this.tasksQueueConfig = tasksQueueConfig;
        this.kafkaSettings = kafkaSettings;
        this.consumerStatsService = consumerStatsService;
        this.tasksAdmin = new TbKafkaAdmin(kafkaSettings, kafkaTopicConfigs.getTasksConfigs());
    }

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.TaskProto>> createTaskConsumer(JobType jobType) {
        return TbKafkaConsumerTemplate.builder().settings(this.kafkaSettings).topic(this.topicService.buildTopicName(jobType.getTasksTopic())).clientId(jobType.name().toLowerCase() + "-task-consumer-" + this.serviceInfoProvider.getServiceId()).groupId(this.topicService.buildTopicName(jobType.name().toLowerCase() + "-task-consumer-group")).decoder(msg -> new TbProtoQueueMsg<TransportProtos.TaskProto>(msg.getKey(), TransportProtos.TaskProto.parseFrom((byte[])msg.getData()), msg.getHeaders())).admin(this.tasksAdmin).statsService(this.consumerStatsService).build();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.JobStatsMsg>> createJobStatsProducer() {
        return TbKafkaProducerTemplate.builder().clientId("job-stats-producer-" + this.serviceInfoProvider.getServiceId()).defaultTopic(this.topicService.buildTopicName(this.tasksQueueConfig.getStatsTopic())).settings(this.kafkaSettings).admin(this.tasksAdmin).build();
    }
}

