/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.task;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.JobId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.job.task.TaskResult;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.task.TaskProcessorQueueFactory;

@Lazy
@Service
public class JobStatsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobStatsService.class);
    private final TbQueueProducer<TbProtoQueueMsg<TransportProtos.JobStatsMsg>> producer;

    public JobStatsService(TaskProcessorQueueFactory queueFactory) {
        this.producer = queueFactory.createJobStatsProducer();
    }

    public void reportTaskResult(TenantId tenantId, JobId jobId, TaskResult result) {
        this.report(tenantId, jobId, TransportProtos.JobStatsMsg.newBuilder().setTaskResult(TransportProtos.TaskResultProto.newBuilder().setValue(JacksonUtil.toString((Object)result)).build()));
    }

    public void reportAllTasksSubmitted(TenantId tenantId, JobId jobId, int tasksCount) {
        this.report(tenantId, jobId, TransportProtos.JobStatsMsg.newBuilder().setTotalTasksCount(tasksCount));
    }

    private void report(TenantId tenantId, JobId jobId, TransportProtos.JobStatsMsg.Builder statsMsg) {
        log.debug("[{}][{}] Reporting: {}", new Object[]{tenantId, jobId, statsMsg});
        statsMsg.setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setJobIdMSB(jobId.getId().getMostSignificantBits()).setJobIdLSB(jobId.getId().getLeastSignificantBits());
        TbProtoQueueMsg<TransportProtos.JobStatsMsg> msg = new TbProtoQueueMsg<TransportProtos.JobStatsMsg>(jobId.getId(), statsMsg.build());
        this.producer.send(TopicPartitionInfo.builder().topic(this.producer.getDefaultTopic()).build(), msg, TbQueueCallback.EMPTY);
    }
}

