/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.task;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.memory.InMemoryStorage;
import org.thingsboard.server.queue.memory.InMemoryTbQueueProducer;
import org.thingsboard.server.queue.task.TaskProducerQueueFactory;

@Component
@ConditionalOnExpression(value="'${queue.type:null}' == 'in-memory'")
public class InMemoryTaskProducerQueueFactory
implements TaskProducerQueueFactory {
    private final InMemoryStorage storage;

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.TaskProto>> createTaskProducer(JobType jobType) {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.TaskProto>>(this.storage, jobType.getTasksTopic());
    }

    @ConstructorProperties(value={"storage"})
    @Generated
    public InMemoryTaskProducerQueueFactory(InMemoryStorage storage) {
        this.storage = storage;
    }
}

