/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.task;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.job.JobType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueConsumer;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.memory.InMemoryStorage;
import org.thingsboard.server.queue.memory.InMemoryTbQueueConsumer;
import org.thingsboard.server.queue.memory.InMemoryTbQueueProducer;
import org.thingsboard.server.queue.settings.TasksQueueConfig;
import org.thingsboard.server.queue.task.TaskProcessorQueueFactory;

@Component
@ConditionalOnExpression(value="'${queue.type:null}'=='in-memory'")
public class InMemoryTaskProcessorQueueFactory
implements TaskProcessorQueueFactory {
    private final InMemoryStorage storage;
    private final TasksQueueConfig tasksQueueConfig;

    @Override
    public TbQueueConsumer<TbProtoQueueMsg<TransportProtos.TaskProto>> createTaskConsumer(JobType jobType) {
        return new InMemoryTbQueueConsumer<TbProtoQueueMsg<TransportProtos.TaskProto>>(this.storage, jobType.getTasksTopic());
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.JobStatsMsg>> createJobStatsProducer() {
        return new InMemoryTbQueueProducer<TbProtoQueueMsg<TransportProtos.JobStatsMsg>>(this.storage, this.tasksQueueConfig.getStatsTopic());
    }

    @ConstructorProperties(value={"storage", "tasksQueueConfig"})
    @Generated
    public InMemoryTaskProcessorQueueFactory(InMemoryStorage storage, TasksQueueConfig tasksQueueConfig) {
        this.storage = storage;
        this.tasksQueueConfig = tasksQueueConfig;
    }
}

