/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.scheduler;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.server.queue.scheduler.SchedulerComponent;

@Component
public class DefaultSchedulerComponent
implements SchedulerComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSchedulerComponent.class);
    private ScheduledExecutorService schedulerExecutor;

    @PostConstruct
    public void init() {
        this.schedulerExecutor = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"queue-scheduler");
    }

    @PreDestroy
    public void destroy() {
        if (this.schedulerExecutor != null) {
            this.schedulerExecutor.shutdownNow();
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.schedulerExecutor.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.schedulerExecutor.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.schedulerExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.schedulerExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

