/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.queue.provider;

import jakarta.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.provider.TbRuleEngineQueueFactory;

@Service
@ConditionalOnExpression(value="'${service.type:null}'=='tb-rule-engine'")
public class TbRuleEngineProducerProvider
implements TbQueueProducerProvider {
    private final TbRuleEngineQueueFactory tbQueueProvider;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> toTransport;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> toRuleEngine;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> toTbCore;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> toRuleEngineNotifications;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> toTbCoreNotifications;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> toUsageStats;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> toHousekeeper;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeMsg>> toEdge;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeNotificationMsg>> toEdgeNotifications;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeEventNotificationMsg>> toEdgeEvents;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>> toCalculatedFields;
    private TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldNotificationMsg>> toCalculatedFieldNotifications;

    public TbRuleEngineProducerProvider(TbRuleEngineQueueFactory tbQueueProvider) {
        this.tbQueueProvider = tbQueueProvider;
    }

    @PostConstruct
    public void init() {
        this.toTbCore = this.tbQueueProvider.createTbCoreMsgProducer();
        this.toTransport = this.tbQueueProvider.createTransportNotificationsMsgProducer();
        this.toRuleEngine = this.tbQueueProvider.createRuleEngineMsgProducer();
        this.toRuleEngineNotifications = this.tbQueueProvider.createRuleEngineNotificationsMsgProducer();
        this.toTbCoreNotifications = this.tbQueueProvider.createTbCoreNotificationsMsgProducer();
        this.toUsageStats = this.tbQueueProvider.createToUsageStatsServiceMsgProducer();
        this.toHousekeeper = this.tbQueueProvider.createHousekeeperMsgProducer();
        this.toEdge = this.tbQueueProvider.createEdgeMsgProducer();
        this.toEdgeNotifications = this.tbQueueProvider.createEdgeNotificationsMsgProducer();
        this.toEdgeEvents = this.tbQueueProvider.createEdgeEventMsgProducer();
        this.toCalculatedFields = this.tbQueueProvider.createToCalculatedFieldMsgProducer();
        this.toCalculatedFieldNotifications = this.tbQueueProvider.createToCalculatedFieldNotificationMsgProducer();
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> getTransportNotificationsMsgProducer() {
        return this.toTransport;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineMsg>> getRuleEngineMsgProducer() {
        return this.toRuleEngine;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToRuleEngineNotificationMsg>> getRuleEngineNotificationsMsgProducer() {
        return this.toRuleEngineNotifications;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreMsg>> getTbCoreMsgProducer() {
        return this.toTbCore;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCoreNotificationMsg>> getTbCoreNotificationsMsgProducer() {
        return this.toTbCoreNotifications;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeMsg>> getTbEdgeMsgProducer() {
        return this.toEdge;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeNotificationMsg>> getTbEdgeNotificationsMsgProducer() {
        return this.toEdgeNotifications;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToEdgeEventNotificationMsg>> getTbEdgeEventsMsgProducer() {
        return this.toEdgeEvents;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToUsageStatsServiceMsg>> getTbUsageStatsMsgProducer() {
        return this.toUsageStats;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToVersionControlServiceMsg>> getTbVersionControlMsgProducer() {
        throw new RuntimeException("Not Implemented! Should not be used by Rule Engine!");
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToHousekeeperServiceMsg>> getHousekeeperMsgProducer() {
        return this.toHousekeeper;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldMsg>> getCalculatedFieldsMsgProducer() {
        return this.toCalculatedFields;
    }

    @Override
    public TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToCalculatedFieldNotificationMsg>> getCalculatedFieldsNotificationsMsgProducer() {
        return this.toCalculatedFieldNotifications;
    }
}

